/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.acl;

import java.security.Principal;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.api.jsr283.security.AccessControlEntry;
import org.apache.jackrabbit.api.jsr283.security.AccessControlException;
import org.apache.jackrabbit.api.jsr283.security.AccessControlList;
import org.apache.jackrabbit.api.jsr283.security.AccessControlPolicy;
import org.apache.jackrabbit.api.jsr283.security.Privilege;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SecurityItemModifier;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.security.authorization.AccessControlEditor;
import org.apache.jackrabbit.core.security.authorization.AccessControlUtils;
import org.apache.jackrabbit.core.security.authorization.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.core.security.authorization.acl.ACLProvider;
import org.apache.jackrabbit.core.security.authorization.acl.ACLTemplate;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NameParser;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACLEditor
extends SecurityItemModifier
implements AccessControlEditor,
AccessControlConstants {
    private static final Logger log = LoggerFactory.getLogger((Class)ACLEditor.class);
    private static final String DEFAULT_ACE_NAME = "ace";
    private final SessionImpl session;
    private final PrivilegeRegistry privilegeRegistry;
    private final AccessControlUtils utils;

    ACLEditor(Session editingSession, AccessControlUtils utils) {
        if (!(editingSession instanceof SessionImpl)) {
            throw new IllegalArgumentException("org.apache.jackrabbit.core.SessionImpl expected. Found " + editingSession.getClass());
        }
        this.session = (SessionImpl)editingSession;
        this.privilegeRegistry = new PrivilegeRegistry((NameResolver)this.session);
        this.utils = utils;
    }

    AccessControlList getACL(NodeImpl aclNode) throws RepositoryException {
        return new ACLTemplate(aclNode, this.privilegeRegistry);
    }

    public AccessControlPolicy[] getPolicies(String nodePath) throws AccessControlException, PathNotFoundException, RepositoryException {
        this.checkProtectsNode(nodePath);
        NodeImpl aclNode = this.getAclNode(nodePath);
        if (aclNode == null) {
            return new AccessControlPolicy[0];
        }
        return new AccessControlPolicy[]{this.getACL(aclNode)};
    }

    public AccessControlPolicy[] editAccessControlPolicies(String nodePath) throws AccessControlException, PathNotFoundException, RepositoryException {
        this.checkProtectsNode(nodePath);
        NodeImpl aclNode = this.getAclNode(nodePath);
        AccessControlList acl = aclNode == null ? new ACLTemplate(nodePath, this.session.getPrincipalManager(), this.privilegeRegistry) : this.getACL(aclNode);
        return new AccessControlPolicy[]{acl};
    }

    public AccessControlPolicy[] editAccessControlPolicies(Principal principal) throws AccessDeniedException, AccessControlException, RepositoryException {
        if (!this.session.getPrincipalManager().hasPrincipal(principal.getName())) {
            throw new AccessControlException("Unknown principal.");
        }
        return new AccessControlPolicy[0];
    }

    public void setPolicy(String nodePath, AccessControlPolicy policy) throws RepositoryException {
        this.checkProtectsNode(nodePath);
        ACLEditor.checkValidPolicy(nodePath, policy);
        NodeImpl aclNode = this.getAclNode(nodePath);
        if (aclNode != null) {
            this.removeSecurityItem(aclNode);
        }
        aclNode = this.createAclNode(nodePath);
        AccessControlEntry[] entries = ((ACLTemplate)policy).getAccessControlEntries();
        for (int i = 0; i < entries.length; ++i) {
            JackrabbitAccessControlEntry ace = (JackrabbitAccessControlEntry)entries[i];
            Name nodeName = ACLEditor.getUniqueNodeName((Node)aclNode, ace.isAllow() ? "allow" : "deny");
            Name ntName = ace.isAllow() ? NT_REP_GRANT_ACE : NT_REP_DENY_ACE;
            ValueFactory vf = this.session.getValueFactory();
            NodeImpl aceNode = this.addSecurityNode(aclNode, nodeName, ntName);
            String principalName = ace.getPrincipal().getName();
            this.setSecurityProperty(aceNode, P_PRINCIPAL_NAME, vf.createValue(principalName));
            Privilege[] pvlgs = ace.getPrivileges();
            Value[] names = ACLEditor.getPrivilegeNames(pvlgs, vf);
            this.setSecurityProperty(aceNode, P_PRIVILEGES, names);
        }
    }

    public synchronized void removePolicy(String nodePath, AccessControlPolicy policy) throws AccessControlException, RepositoryException {
        this.checkProtectsNode(nodePath);
        ACLEditor.checkValidPolicy(nodePath, policy);
        NodeImpl aclNode = this.getAclNode(nodePath);
        if (aclNode == null) {
            throw new AccessControlException("No policy to remove at " + nodePath);
        }
        this.removeSecurityItem(aclNode);
    }

    private void checkProtectsNode(String nodePath) throws RepositoryException {
        NodeImpl node = this.getNode(nodePath);
        if (this.utils.isAcItem(node)) {
            throw new AccessControlException("Node " + nodePath + " defines ACL or ACE itself.");
        }
    }

    private static void checkValidPolicy(String nodePath, AccessControlPolicy policy) throws AccessControlException {
        if (policy == null || !(policy instanceof ACLTemplate)) {
            throw new AccessControlException("Attempt to set/remove invalid policy " + policy);
        }
        ACLTemplate acl = (ACLTemplate)policy;
        if (!nodePath.equals(acl.getPath())) {
            throw new AccessControlException("Policy " + policy + " cannot be applied/removed from the node at " + nodePath);
        }
    }

    private NodeImpl getNode(String path) throws PathNotFoundException, RepositoryException {
        return (NodeImpl)this.session.getNode(path);
    }

    private NodeImpl getAclNode(String nodePath) throws PathNotFoundException, RepositoryException {
        NodeImpl aclNode = null;
        NodeImpl protectedNode = this.getNode(nodePath);
        if (ACLProvider.isAccessControlled(protectedNode)) {
            aclNode = protectedNode.getNode(N_POLICY);
        }
        return aclNode;
    }

    private NodeImpl createAclNode(String nodePath) throws RepositoryException {
        NodeImpl protectedNode = this.getNode(nodePath);
        if (!protectedNode.isNodeType(NT_REP_ACCESS_CONTROLLABLE)) {
            protectedNode.addMixin(NT_REP_ACCESS_CONTROLLABLE);
        }
        return this.addSecurityNode(protectedNode, N_POLICY, NT_REP_ACL);
    }

    protected static Name getUniqueNodeName(Node node, String name) throws RepositoryException {
        if (name == null) {
            name = DEFAULT_ACE_NAME;
        } else {
            try {
                NameParser.checkFormat((String)name);
            }
            catch (NameException e) {
                name = DEFAULT_ACE_NAME;
                log.debug("Invalid path name for Permission: " + name + ".");
            }
        }
        int i = 0;
        String check = name;
        while (node.hasNode(check)) {
            check = name + i;
            ++i;
        }
        return ((SessionImpl)node.getSession()).getQName(check);
    }

    private static Value[] getPrivilegeNames(Privilege[] privileges, ValueFactory valueFactory) {
        Value[] names = new Value[privileges.length];
        for (int i = 0; i < privileges.length; ++i) {
            names[i] = valueFactory.createValue(privileges[i].getName());
        }
        return names;
    }
}

