/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.commons.collections.map.LRUMap;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.AuthorizableExistsException;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SecurityItemModifier;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.core.security.user.GroupImpl;
import org.apache.jackrabbit.core.security.user.IndexNodeResolver;
import org.apache.jackrabbit.core.security.user.NodeResolver;
import org.apache.jackrabbit.core.security.user.TraversingNodeResolver;
import org.apache.jackrabbit.core.security.user.UserConstants;
import org.apache.jackrabbit.core.security.user.UserImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserManagerImpl
extends SecurityItemModifier
implements UserManager,
UserConstants {
    private static final Logger log = LoggerFactory.getLogger((Class)UserManagerImpl.class);
    private final SessionImpl session;
    private final String adminId;
    private final NodeResolver authResolver;
    private final Map idPathMap = new LRUMap(1000);

    public UserManagerImpl(SessionImpl session, String adminId) throws RepositoryException {
        NodeResolver nr;
        this.session = session;
        this.adminId = adminId;
        try {
            nr = new IndexNodeResolver((Session)session, session);
        }
        catch (RepositoryException e) {
            log.debug("UserManger: no QueryManager available for workspace '" + session.getWorkspace().getName() + "' -> Use traversing node resolver.");
            nr = new TraversingNodeResolver((Session)session, session);
        }
        this.authResolver = nr;
    }

    public Authorizable getAuthorizable(String id) throws RepositoryException {
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException("Invalid authorizable name '" + id + "'");
        }
        User authorz = null;
        NodeImpl n = this.getUserNode(id);
        if (n != null) {
            authorz = this.createUser(n);
        } else {
            n = this.getGroupNode(id);
            if (n != null) {
                authorz = this.createGroup(n);
            }
        }
        return authorz;
    }

    public Authorizable getAuthorizable(Principal principal) throws RepositoryException {
        Item authItem;
        String authPath;
        NodeImpl n = null;
        if (principal instanceof ItemBasedPrincipal && this.session.itemExists(authPath = ((ItemBasedPrincipal)principal).getPath()) && (authItem = this.session.getItem(authPath)).isNode()) {
            n = (NodeImpl)authItem;
        }
        if (n == null) {
            String name = principal.getName();
            n = (NodeImpl)this.authResolver.findNode(P_PRINCIPAL_NAME, name, NT_REP_AUTHORIZABLE);
        }
        if (n != null) {
            if (n.isNodeType(NT_REP_USER)) {
                return this.createUser(n);
            }
            if (n.isNodeType(NT_REP_GROUP)) {
                return this.createGroup(n);
            }
            log.warn("Unexpected user nodetype " + n.getPrimaryNodeType().getName());
        }
        return null;
    }

    public Iterator findAuthorizables(String propertyName, String value) throws RepositoryException {
        return this.findAuthorizables(propertyName, value, 3);
    }

    public Iterator findAuthorizables(String propertyName, String value, int searchType) throws RepositoryException {
        Name ntName;
        Name name = this.session.getQName(propertyName);
        switch (searchType) {
            case 3: {
                ntName = NT_REP_AUTHORIZABLE;
                break;
            }
            case 2: {
                ntName = NT_REP_GROUP;
                break;
            }
            case 1: {
                ntName = NT_REP_USER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid search type " + searchType);
            }
        }
        NodeIterator nodes = this.authResolver.findNodes(name, value, ntName, true);
        return new AuthorizableIterator(nodes);
    }

    public User createUser(String userID, String password) throws RepositoryException {
        return this.createUser(userID, password, new PrincipalImpl(userID), null);
    }

    public User createUser(String userID, String password, Principal principal, String intermediatePath) throws AuthorizableExistsException, RepositoryException {
        if (userID == null || password == null || principal == null) {
            throw new IllegalArgumentException("Not possible to create user with null parameters");
        }
        if (this.getAuthorizable(userID) != null) {
            throw new AuthorizableExistsException("User for '" + userID + "' already exists");
        }
        if (this.hasAuthorizableOrReferee(principal)) {
            throw new AuthorizableExistsException("Authorizable for '" + principal.getName() + "' already exists");
        }
        ItemImpl parent = null;
        try {
            String parentPath = UserManagerImpl.getParentPath(intermediatePath, this.getCurrentUserPath());
            parent = this.createParentNode(parentPath);
            Name nodeName = this.session.getQName(Text.escapeIllegalJcrChars((String)userID));
            NodeImpl userNode = this.addSecurityNode((NodeImpl)parent, nodeName, NT_REP_USER);
            this.setSecurityProperty(userNode, P_USERID, this.getValue(userID));
            this.setSecurityProperty(userNode, P_PASSWORD, this.getValue(UserImpl.buildPasswordValue(password)));
            this.setSecurityProperty(userNode, P_PRINCIPAL_NAME, this.getValue(principal.getName()));
            parent.save();
            log.info("User created: " + userID + "; " + userNode.getPath());
            return this.createUser(userNode);
        }
        catch (RepositoryException e) {
            if (parent != null) {
                parent.refresh(false);
                log.debug("Failed to create new User, reverting changes.");
            }
            throw e;
        }
    }

    public Group createGroup(Principal principal) throws RepositoryException {
        return this.createGroup(principal, null);
    }

    public Group createGroup(Principal principal, String intermediatePath) throws AuthorizableExistsException, RepositoryException {
        if (principal == null) {
            throw new IllegalArgumentException("Principal might not be null.");
        }
        if (this.hasAuthorizableOrReferee(principal)) {
            throw new AuthorizableExistsException("Authorizable for '" + principal.getName() + "' already exists: ");
        }
        ItemImpl parent = null;
        try {
            String parentPath = UserManagerImpl.getParentPath(intermediatePath, "/rep:security/rep:authorizables/rep:groups");
            parent = this.createParentNode(parentPath);
            Name groupID = this.getGroupId(principal.getName());
            NodeImpl groupNode = this.addSecurityNode((NodeImpl)parent, groupID, NT_REP_GROUP);
            this.setSecurityProperty(groupNode, P_PRINCIPAL_NAME, this.getValue(principal.getName()));
            parent.save();
            log.info("Group created: " + groupID + "; " + groupNode.getPath());
            return this.createGroup(groupNode);
        }
        catch (RepositoryException e) {
            if (parent != null) {
                parent.refresh(false);
                log.debug("newInstance new Group failed, revert changes on parent");
            }
            throw e;
        }
    }

    boolean hasAuthorizableOrReferee(Principal principal) throws RepositoryException {
        HashSet<Name> s = new HashSet<Name>(2);
        s.add(P_PRINCIPAL_NAME);
        s.add(P_REFEREES);
        NodeIterator res = this.authResolver.findNodes(s, principal.getName(), NT_REP_AUTHORIZABLE, true, 1L);
        return res.hasNext();
    }

    void setProtectedProperty(NodeImpl node, Name propName, Value value) throws RepositoryException, LockException, ConstraintViolationException, ItemExistsException, VersionException {
        this.setSecurityProperty(node, propName, value);
        node.save();
    }

    void setProtectedProperty(NodeImpl node, Name propName, Value[] values) throws RepositoryException, LockException, ConstraintViolationException, ItemExistsException, VersionException {
        this.setSecurityProperty(node, propName, values);
        node.save();
    }

    void removeProtectedItem(ItemImpl item, Node parent) throws RepositoryException, AccessDeniedException, VersionException {
        this.removeSecurityItem(item);
        parent.save();
    }

    private Name getGroupId(String principalName) throws RepositoryException {
        String escHint;
        String groupID = escHint = Text.escapeIllegalJcrChars((String)principalName);
        int i = 0;
        while (this.getAuthorizable(groupID) != null) {
            groupID = escHint + "_" + i;
            ++i;
        }
        return this.session.getQName(groupID);
    }

    private Value getValue(String strValue) throws RepositoryException {
        return this.session.getValueFactory().createValue(strValue);
    }

    boolean isAdminId(String userID) {
        return this.adminId == null ? false : this.adminId.equals(userID);
    }

    User createUser(NodeImpl userNode) throws RepositoryException {
        User user = UserImpl.create(userNode, this);
        this.idPathMap.put(user.getID(), userNode.getPath());
        return user;
    }

    Group createGroup(NodeImpl groupNode) throws RepositoryException {
        Group group = GroupImpl.create(groupNode, this);
        this.idPathMap.put(group.getID(), groupNode.getPath());
        return group;
    }

    private NodeImpl getUserNode(String userID) throws RepositoryException {
        NodeImpl tmp;
        Item itm;
        String path;
        NodeImpl n = null;
        if (this.idPathMap.containsKey(userID) && this.session.itemExists(path = this.idPathMap.get(userID).toString()) && (itm = this.session.getItem(path)).isNode() && (tmp = (NodeImpl)itm).isNodeType(NT_REP_USER) && userID.equals(((NodeImpl)itm).getProperty(P_USERID).getString())) {
            n = (NodeImpl)itm;
        }
        if (n == null) {
            this.idPathMap.remove(userID);
            n = (NodeImpl)this.authResolver.findNode(P_USERID, userID, NT_REP_USER);
        }
        return n;
    }

    private NodeImpl getGroupNode(String groupID) throws RepositoryException {
        NodeImpl tmp;
        Item itm;
        String path;
        NodeImpl n = null;
        if (this.idPathMap.containsKey(groupID) && this.session.itemExists(path = this.idPathMap.get(groupID).toString()) && (itm = this.session.getItem(path)).isNode() && (tmp = (NodeImpl)itm).isNodeType(NT_REP_GROUP) && groupID.equals(tmp.getName())) {
            n = (NodeImpl)itm;
        }
        if (n == null) {
            this.idPathMap.remove(groupID);
            Name nodeName = this.session.getQName(groupID);
            n = (NodeImpl)this.authResolver.findNode(nodeName, NT_REP_GROUP);
        }
        return n;
    }

    private String getCurrentUserPath() {
        String currentUserPath = "/rep:security/rep:authorizables/rep:users";
        String userId = this.session.getUserID();
        if (this.idPathMap.containsKey(userId)) {
            currentUserPath = this.idPathMap.get(userId).toString();
        } else {
            try {
                NodeImpl n = this.getUserNode(userId);
                if (n != null) {
                    currentUserPath = n.getPath();
                }
            }
            catch (RepositoryException e) {
                log.error("Internal error: unable to build current user path.", (Object)e.getMessage());
            }
        }
        return currentUserPath;
    }

    private static String getParentPath(String hint, String root) {
        StringBuffer b = new StringBuffer();
        if (hint == null || !hint.startsWith(root)) {
            b.append(root);
        }
        if (hint != null && hint.length() > 1) {
            if (!hint.startsWith("/")) {
                b.append("/");
            }
            b.append(hint);
        }
        return b.toString();
    }

    private NodeImpl createParentNode(String path) throws RepositoryException {
        NodeImpl parent = (NodeImpl)this.session.getRootNode();
        String[] elem = path.split("/");
        for (int i = 0; i < elem.length; ++i) {
            String name = elem[i];
            if (name.length() < 1) continue;
            Name nName = this.session.getQName(name);
            if (!parent.hasNode(nName)) {
                Name ntName = i == 0 ? NameConstants.NT_UNSTRUCTURED : NT_REP_AUTHORIZABLE_FOLDER;
                NodeImpl added = this.addSecurityNode(parent, nName, ntName);
                parent.save();
                parent = added;
                continue;
            }
            parent = parent.getNode(nName);
        }
        return parent;
    }

    private final class AuthorizableIterator
    implements Iterator {
        private final Set served = new HashSet();
        private Authorizable next;
        private NodeIterator authNodeIter;

        private AuthorizableIterator(NodeIterator authNodeIter) {
            this.authNodeIter = authNodeIter;
            this.next = this.seekNext();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            Authorizable authr = this.next;
            if (authr == null) {
                throw new NoSuchElementException();
            }
            this.next = this.seekNext();
            return authr;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Authorizable seekNext() {
            while (this.authNodeIter.hasNext()) {
                NodeImpl node = (NodeImpl)this.authNodeIter.nextNode();
                try {
                    User authr;
                    if (this.served.contains(node.getUUID())) continue;
                    if (node.isNodeType(UserConstants.NT_REP_USER)) {
                        authr = UserManagerImpl.this.createUser(node);
                    } else if (node.isNodeType(UserConstants.NT_REP_GROUP)) {
                        authr = UserManagerImpl.this.createGroup(node);
                    } else {
                        log.warn("Ignoring unexpected nodetype: " + node.getPrimaryNodeType().getName());
                        continue;
                    }
                    this.served.add(node.getUUID());
                    return authr;
                }
                catch (RepositoryException e) {
                    log.debug(e.getMessage());
                }
            }
            return null;
        }
    }
}

