/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xml.fragment;

import java.util.Collection;
import java.util.List;
import org.apache.vysper.xml.fragment.Attribute;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xml.fragment.XMLFragment;

public class XMLElementVerifier {
    protected XMLElement element;

    protected XMLElementVerifier(XMLElement element) {
        if (element == null) {
            throw new IllegalArgumentException("null not allowed for element");
        }
        this.element = element;
    }

    public boolean nameEquals(String name) {
        return this.element.getName().equals(name);
    }

    public boolean attributePresent(String name) {
        return this.attributePresent("", name);
    }

    public boolean attributePresent(String namespaceUri, String name) {
        return null != this.element.getAttribute(namespaceUri, name);
    }

    public boolean allAttributesPresent(String ... names) {
        if (names == null) {
            return false;
        }
        for (String name : names) {
            if (this.attributePresent(name)) continue;
            return false;
        }
        return true;
    }

    public boolean onlyAttributesPresent(String ... names) {
        if (names == null) {
            return false;
        }
        return this.element.getAttributes().size() == names.length && this.allAttributesPresent(names);
    }

    public boolean anyAttributePresent(String ... names) {
        if (names == null) {
            return false;
        }
        for (String name : names) {
            if (!this.attributePresent(name)) continue;
            return true;
        }
        return false;
    }

    public boolean attributeEquals(String name, String value) {
        return this.attributeEquals("", name, value);
    }

    public boolean attributeEquals(String namespaceUri, String name, String value) {
        return this.attributePresent(namespaceUri, name) && this.element.getAttributeValue(namespaceUri, name).equals(value);
    }

    public boolean subElementPresent(String name) {
        for (XMLFragment xmlFragment : this.element.getInnerFragments()) {
            XMLElement xmlElement;
            if (!(xmlFragment instanceof XMLElement) || !(xmlElement = (XMLElement)xmlFragment).getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean subElementsPresentExact(int numberOfSubelements) {
        return this.element.getInnerElements().size() == numberOfSubelements;
    }

    public boolean subElementsPresentAtLeast(int numberOfSubelements) {
        return this.element.getInnerElements().size() >= numberOfSubelements;
    }

    public boolean subElementsPresentAtMost(int numberOfSubelements) {
        return this.element.getInnerElements().size() <= numberOfSubelements;
    }

    public boolean namespacePresent(String namespaceURI) {
        Collection<String> nsUris = this.element.getDeclaredNamespaces().values();
        if (nsUris.contains(namespaceURI)) {
            return true;
        }
        for (Attribute attribute : this.element.getAttributes()) {
            if (!attribute.getName().startsWith("xmlns") || !attribute.getValue().equals(namespaceURI)) continue;
            return true;
        }
        return namespaceURI.equals(this.element.getNamespaceURI());
    }

    public String getNamespaceIdentifier(String namespace) {
        for (Attribute attribute : this.element.getAttributes()) {
            if (!attribute.getValue().equals(namespace) || !attribute.getName().startsWith("xmlns:")) continue;
            return attribute.getName().substring("xmlns:".length());
        }
        return null;
    }

    private boolean isNamespaceAttribute(Attribute attribute) {
        return attribute.getName().equalsIgnoreCase("xmlns") || attribute.getName().startsWith("xmlns:");
    }

    public String getUniqueXMLNSValue() {
        Attribute found = null;
        for (Attribute attribute : this.element.getAttributes()) {
            if (!this.isNamespaceAttribute(attribute)) continue;
            if (found != null) {
                return null;
            }
            found = attribute;
        }
        if (found == null) {
            return null;
        }
        return found.getValue();
    }

    public boolean toAttributeEquals(String toValue) {
        return this.attributeEquals("to", toValue);
    }

    public boolean fromAttributeEquals(String fromValue) {
        return this.attributeEquals("from", fromValue);
    }

    public boolean onlySubelementEquals(String name, String namespaceURI) {
        boolean nameEquals;
        List<XMLFragment> innerFragments = this.element.getInnerFragments();
        if (innerFragments == null || innerFragments.size() != 1) {
            return false;
        }
        XMLFragment onlySubelement = innerFragments.get(0);
        if (!(onlySubelement instanceof XMLElement)) {
            return false;
        }
        XMLElement xmlElement = (XMLElement)onlySubelement;
        boolean bl = name == null ? xmlElement.getName() == null : (nameEquals = name.equals(xmlElement.getName()));
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        return nameEquals && namespaceURI.equals(xmlElement.getNamespaceURI());
    }
}

