/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.core.im.handler;

import org.apache.vysper.xmpp.modules.core.base.handler.XMPPCoreStanzaHandler;
import org.apache.vysper.xmpp.modules.core.im.handler.PresenceAvailabilityHandler;
import org.apache.vysper.xmpp.modules.core.im.handler.PresenceSubscriptionHandler;
import org.apache.vysper.xmpp.modules.roster.persistence.RosterManager;
import org.apache.vysper.xmpp.modules.roster.persistence.RosterManagerUtils;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.stanza.PresenceStanza;
import org.apache.vysper.xmpp.stanza.PresenceStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.XMPPCoreStanza;

public class PresenceHandler
extends XMPPCoreStanzaHandler {
    private static final PresenceAvailabilityHandler AVAILABILITY_HANDLER = new PresenceAvailabilityHandler();
    private static final PresenceSubscriptionHandler SUBSCRIPTION_HANDLER = new PresenceSubscriptionHandler();

    public String getName() {
        return "presence";
    }

    protected boolean verifyType(Stanza stanza) {
        return PresenceStanza.isOfType(stanza);
    }

    protected Stanza executeCore(XMPPCoreStanza stanza, ServerRuntimeContext serverRuntimeContext, boolean isOutboundStanza, SessionContext sessionContext) {
        PresenceStanza presenceStanza = (PresenceStanza)stanza;
        boolean subscriptionRelated = PresenceStanzaType.isSubscriptionType(presenceStanza.getPresenceType());
        RosterManager rosterManager = RosterManagerUtils.getRosterInstance(serverRuntimeContext, sessionContext);
        if (!subscriptionRelated) {
            return AVAILABILITY_HANDLER.executeCorePresence(serverRuntimeContext, isOutboundStanza, sessionContext, presenceStanza, rosterManager);
        }
        return SUBSCRIPTION_HANDLER.executeCorePresence(serverRuntimeContext, isOutboundStanza, sessionContext, presenceStanza, rosterManager);
    }
}

