/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0133_service_administration;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityFormatException;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.authorization.AccountManagement;
import org.apache.vysper.xmpp.modules.DefaultModule;
import org.apache.vysper.xmpp.modules.ServerRuntimeContextService;
import org.apache.vysper.xmpp.modules.extension.xep0050_adhoc_commands.AdhocCommandHandler;
import org.apache.vysper.xmpp.modules.extension.xep0050_adhoc_commands.AdhocCommandSupport;
import org.apache.vysper.xmpp.modules.extension.xep0050_adhoc_commands.AdhocCommandsService;
import org.apache.vysper.xmpp.modules.extension.xep0050_adhoc_commands.CommandInfo;
import org.apache.vysper.xmpp.modules.extension.xep0133_service_administration.ServerAdministrationService;
import org.apache.vysper.xmpp.modules.extension.xep0133_service_administration.command.AddUserCommandHandler;
import org.apache.vysper.xmpp.modules.extension.xep0133_service_administration.command.ChangeUserPasswordCommandHandler;
import org.apache.vysper.xmpp.modules.extension.xep0133_service_administration.command.GetOnlineUsersCommandHandler;
import org.apache.vysper.xmpp.modules.servicediscovery.management.InfoRequest;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.state.resourcebinding.ResourceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceAdministrationModule
extends DefaultModule
implements AdhocCommandSupport,
ServerRuntimeContextService,
ServerAdministrationService {
    private final Logger logger = LoggerFactory.getLogger(ServiceAdministrationModule.class);
    public static final String COMMAND_NODE_ADD_USER = "http://jabber.org/protocol/admin#add-user";
    public static final String COMMAND_GET_ONLINE_USERS_NUM = "http://jabber.org/protocol/admin#get-online-users-num";
    public static final String COMMAND_CHANGE_USER_PASSWORD = "http://jabber.org/protocol/admin#change-user-password";
    private ServerRuntimeContext serverRuntimeContext;
    protected Collection<Entity> admins = new HashSet<Entity>();
    protected final Map<String, CommandInfo> allCommandInfos = new HashMap<String, CommandInfo>();

    public ServiceAdministrationModule() {
        this.allCommandInfos.put(COMMAND_NODE_ADD_USER, new CommandInfo(COMMAND_NODE_ADD_USER, "Add User"));
        this.allCommandInfos.put(COMMAND_CHANGE_USER_PASSWORD, new CommandInfo(COMMAND_CHANGE_USER_PASSWORD, "Change User Password"));
        this.allCommandInfos.put(COMMAND_GET_ONLINE_USERS_NUM, new CommandInfo(COMMAND_GET_ONLINE_USERS_NUM, "Get Number of Online Users"));
    }

    @Override
    public void initialize(ServerRuntimeContext serverRuntimeContext) {
        super.initialize(serverRuntimeContext);
        this.serverRuntimeContext = serverRuntimeContext;
        AdhocCommandsService adhocCommandsService = (AdhocCommandsService)((Object)serverRuntimeContext.getServerRuntimeContextService("adhoc_commands"));
        adhocCommandsService.registerCommandSupport(this);
        serverRuntimeContext.registerServerRuntimeContextService(this);
    }

    @Override
    public void setAddAdminJIDs(Collection<Entity> admins) {
        this.admins.addAll(admins);
    }

    @Override
    public void setAddAdmins(Collection<String> admins) {
        HashSet<EntityImpl> adminEntities = new HashSet<EntityImpl>();
        for (String admin : admins) {
            try {
                adminEntities.add(EntityImpl.parse(admin));
            }
            catch (EntityFormatException e) {
                this.logger.error("could not add mal-formed JID as administrator: " + admin);
            }
        }
        this.admins.addAll(adminEntities);
    }

    @Override
    public boolean isAdmin(Entity adminCandidate) {
        return this.admins.contains(adminCandidate);
    }

    @Override
    public String getName() {
        return "XEP-0133 Service Administration";
    }

    @Override
    public String getVersion() {
        return "1.1";
    }

    @Override
    public String getServiceName() {
        return "ServerAdministrationService";
    }

    @Override
    public Collection<CommandInfo> getCommandInfosForInfoRequest(InfoRequest infoRequest, boolean hintListAll) {
        if (!this.admins.contains(infoRequest.getFrom())) {
            return Arrays.asList(this.allCommandInfos.get(COMMAND_CHANGE_USER_PASSWORD));
        }
        if (hintListAll) {
            return this.allCommandInfos.values();
        }
        CommandInfo commandInfo = this.allCommandInfos.get(infoRequest.getNode());
        return commandInfo == null ? null : Arrays.asList(commandInfo);
    }

    @Override
    public AdhocCommandHandler getCommandHandler(String commandNode, Entity executingUser) {
        if (executingUser == null) {
            return null;
        }
        AccountManagement accountManagement = (AccountManagement)this.serverRuntimeContext.getStorageProvider(AccountManagement.class);
        ResourceRegistry resourceRegistry = this.serverRuntimeContext.getResourceRegistry();
        if (!this.admins.contains(executingUser.getBareJID())) {
            if (commandNode.equals(COMMAND_CHANGE_USER_PASSWORD)) {
                return new ChangeUserPasswordCommandHandler(accountManagement, executingUser);
            }
            return null;
        }
        if (commandNode.equals(COMMAND_NODE_ADD_USER)) {
            if (accountManagement == null) {
                return null;
            }
            return new AddUserCommandHandler(accountManagement, Arrays.asList(this.serverRuntimeContext.getServerEnitity().getDomain()));
        }
        if (commandNode.equals(COMMAND_CHANGE_USER_PASSWORD)) {
            return new ChangeUserPasswordCommandHandler(accountManagement, null);
        }
        if (commandNode.equals(COMMAND_GET_ONLINE_USERS_NUM)) {
            return new GetOnlineUsersCommandHandler(resourceRegistry);
        }
        return null;
    }
}

