/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.roster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.modules.roster.AskSubscriptionType;
import org.apache.vysper.xmpp.modules.roster.RosterGroup;
import org.apache.vysper.xmpp.modules.roster.SubscriptionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RosterItem {
    private Entity jid;
    private String name;
    private final List<RosterGroup> groups = new ArrayList<RosterGroup>();
    private SubscriptionType subscriptionType;
    private AskSubscriptionType askSubscriptionType;

    public RosterItem(Entity jid, SubscriptionType subscriptionType) {
        this(jid, null, subscriptionType, null);
    }

    public RosterItem(Entity jid, SubscriptionType subscriptionType, AskSubscriptionType askSubscriptionType) {
        this(jid, null, subscriptionType, askSubscriptionType);
    }

    public RosterItem(Entity jid, String name, SubscriptionType subscriptionType, AskSubscriptionType askSubscriptionType) {
        this.jid = jid;
        this.name = name;
        this.subscriptionType = subscriptionType;
        this.askSubscriptionType = askSubscriptionType == null ? AskSubscriptionType.NOT_SET : askSubscriptionType;
    }

    public RosterItem(Entity jid, String name, SubscriptionType subscriptionType, AskSubscriptionType askSubscriptionType, List<RosterGroup> groups) {
        this(jid, name, subscriptionType, askSubscriptionType);
        this.groups.addAll(groups);
    }

    public Entity getJid() {
        return this.jid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<RosterGroup> getGroups() {
        return Collections.unmodifiableList(this.groups);
    }

    public void setGroups(List<RosterGroup> newGroups) {
        this.groups.clear();
        if (newGroups != null) {
            this.groups.addAll(newGroups);
        }
    }

    public SubscriptionType getSubscriptionType() {
        return this.subscriptionType;
    }

    void setSubscriptionType(SubscriptionType subscriptionType) {
        this.subscriptionType = subscriptionType;
    }

    public AskSubscriptionType getAskSubscriptionType() {
        return this.askSubscriptionType;
    }

    void setAskSubscriptionType(AskSubscriptionType askSubscribe) {
        this.askSubscriptionType = askSubscribe;
    }

    public boolean hasTo() {
        return this.subscriptionType == SubscriptionType.TO || this.subscriptionType == SubscriptionType.BOTH;
    }

    public boolean hasFrom() {
        return this.subscriptionType == SubscriptionType.FROM || this.subscriptionType == SubscriptionType.BOTH;
    }

    public boolean isBoth() {
        return this.subscriptionType == SubscriptionType.BOTH;
    }

    public String toString() {
        return "RosterItem{jid=" + (this.jid == null ? "NULL" : this.jid.getFullQualifiedName()) + ", name='" + this.name + '\'' + ", groups=" + this.groups + ", subscriptionType=" + (Object)((Object)this.subscriptionType) + ", askSubscriptionType=" + (Object)((Object)this.askSubscriptionType) + '}';
    }
}

