/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.roster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SubscriptionType {
    BOTH("both"),
    FROM("from"),
    NONE("none"),
    REMOVE("remove"),
    TO("to");

    private final String value;

    private SubscriptionType(String value) {
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    public boolean includesFrom() {
        return this == FROM || this == BOTH;
    }

    public boolean includesTo() {
        return this == TO || this == BOTH;
    }

    public boolean acceptsTo() {
        return this == NONE || this == FROM;
    }

    public boolean acceptsFrom() {
        return this == NONE || this == TO;
    }

    public static SubscriptionType addState(SubscriptionType old, SubscriptionType add) {
        switch (add) {
            case BOTH: {
                throw new RuntimeException("add 'both' not valid");
            }
            case FROM: {
                if (!old.acceptsFrom()) {
                    throw new RuntimeException("cannot add " + add.value() + " to " + old.value());
                }
                if (old == NONE) {
                    return FROM;
                }
                if (old == TO) {
                    return BOTH;
                }
                throw new RuntimeException("add FROM not supported for " + old.value());
            }
            case NONE: {
                return add;
            }
            case REMOVE: {
                throw new RuntimeException("add 'remove' not valid");
            }
            case TO: {
                if (!old.acceptsTo()) {
                    throw new RuntimeException("cannot add " + add.value() + " to " + old.value());
                }
                if (old == NONE) {
                    return TO;
                }
                if (old == FROM) {
                    return BOTH;
                }
                throw new RuntimeException("add TO not supported for " + old.value());
            }
        }
        throw new RuntimeException("not implemented: adding " + add.value());
    }
}

