/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.servicediscovery.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.vysper.xmpp.modules.ServerRuntimeContextService;
import org.apache.vysper.xmpp.modules.servicediscovery.collection.ServiceDiscoveryRequestListenerRegistry;
import org.apache.vysper.xmpp.modules.servicediscovery.management.ComponentInfoRequestListener;
import org.apache.vysper.xmpp.modules.servicediscovery.management.Feature;
import org.apache.vysper.xmpp.modules.servicediscovery.management.InfoElement;
import org.apache.vysper.xmpp.modules.servicediscovery.management.InfoRequest;
import org.apache.vysper.xmpp.modules.servicediscovery.management.InfoRequestListener;
import org.apache.vysper.xmpp.modules.servicediscovery.management.Item;
import org.apache.vysper.xmpp.modules.servicediscovery.management.ItemRequestListener;
import org.apache.vysper.xmpp.modules.servicediscovery.management.ServerInfoRequestListener;
import org.apache.vysper.xmpp.modules.servicediscovery.management.ServiceDiscoveryRequestException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceCollector
implements ServerRuntimeContextService,
ServiceDiscoveryRequestListenerRegistry {
    private static final Feature DEFAULT_FEATURE = new Feature("http://jabber.org/protocol/disco#info");
    protected final List<InfoRequestListener> infoRequestListeners = new ArrayList<InfoRequestListener>();
    protected final List<ServerInfoRequestListener> serverInfoRequestListeners = new ArrayList<ServerInfoRequestListener>();
    protected final List<ComponentInfoRequestListener> componentInfoRequestListeners = new ArrayList<ComponentInfoRequestListener>();
    protected final List<ItemRequestListener> itemRequestListeners = new ArrayList<ItemRequestListener>();

    @Override
    public void addInfoRequestListener(InfoRequestListener infoRequestListener) {
        this.infoRequestListeners.add(infoRequestListener);
    }

    @Override
    public void addServerInfoRequestListener(ServerInfoRequestListener infoRequestListener) {
        this.serverInfoRequestListeners.add(infoRequestListener);
    }

    @Override
    public void addComponentInfoRequestListener(ComponentInfoRequestListener infoRequestListener) {
        this.componentInfoRequestListeners.add(infoRequestListener);
    }

    @Override
    public void addItemRequestListener(ItemRequestListener itemRequestListener) {
        this.itemRequestListeners.add(itemRequestListener);
    }

    public List<InfoElement> processServerInfoRequest(InfoRequest infoRequest) throws ServiceDiscoveryRequestException {
        ArrayList<InfoElement> elements = new ArrayList<InfoElement>();
        elements.add(DEFAULT_FEATURE);
        for (ServerInfoRequestListener serverInfoRequestListener : this.serverInfoRequestListeners) {
            List<InfoElement> elementList = null;
            try {
                elementList = serverInfoRequestListener.getServerInfosFor(infoRequest);
            }
            catch (ServiceDiscoveryRequestException abortion) {
                throw abortion;
            }
            catch (Throwable e) {
                continue;
            }
            if (elementList == null) continue;
            elements.addAll(elementList);
        }
        Collections.sort(elements, new ElementPartitioningComparator());
        return elements;
    }

    public List<InfoElement> processComponentInfoRequest(InfoRequest infoRequest) throws ServiceDiscoveryRequestException {
        ArrayList<InfoElement> elements = new ArrayList<InfoElement>();
        for (ComponentInfoRequestListener componentInfoRequestListener : this.componentInfoRequestListeners) {
            List<InfoElement> elementList = null;
            try {
                elementList = componentInfoRequestListener.getComponentInfosFor(infoRequest);
            }
            catch (ServiceDiscoveryRequestException abortion) {
                throw abortion;
            }
            catch (Throwable e) {
                continue;
            }
            if (elementList == null) continue;
            elements.addAll(elementList);
        }
        Collections.sort(elements, new ElementPartitioningComparator());
        return elements;
    }

    public List<InfoElement> processInfoRequest(InfoRequest infoRequest) throws ServiceDiscoveryRequestException {
        ArrayList<InfoElement> elements = new ArrayList<InfoElement>();
        elements.add(DEFAULT_FEATURE);
        for (InfoRequestListener infoRequestListener : this.infoRequestListeners) {
            List<InfoElement> elementList = null;
            try {
                elementList = infoRequestListener.getInfosFor(infoRequest);
            }
            catch (ServiceDiscoveryRequestException abortion) {
                throw abortion;
            }
            catch (Throwable e) {
                continue;
            }
            if (elementList == null) continue;
            elements.addAll(elementList);
        }
        Collections.sort(elements, new ElementPartitioningComparator());
        return elements;
    }

    public List<Item> processItemRequest(InfoRequest infoRequest) throws ServiceDiscoveryRequestException {
        ArrayList<Item> elements = new ArrayList<Item>();
        for (ItemRequestListener itemRequestListener : this.itemRequestListeners) {
            List<Item> elementList;
            try {
                elementList = itemRequestListener.getItemsFor(infoRequest);
            }
            catch (ServiceDiscoveryRequestException abortion) {
                throw abortion;
            }
            catch (Throwable e) {
                continue;
            }
            if (elementList == null) continue;
            elements.addAll(elementList);
        }
        return elements;
    }

    @Override
    public String getServiceName() {
        return "discoRequestListenerRegistry";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ElementPartitioningComparator
    implements Comparator<InfoElement> {
        ElementPartitioningComparator() {
        }

        @Override
        public int compare(InfoElement o1, InfoElement o2) {
            return o1.getElementClassId().compareTo(o2.getElementClassId());
        }
    }
}

