/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.protocol;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.vysper.xmpp.protocol.ProtocolWorker;
import org.apache.vysper.xmpp.protocol.ResponseWriter;
import org.apache.vysper.xmpp.protocol.SessionStateHolder;
import org.apache.vysper.xmpp.protocol.StanzaProcessor;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.stanza.Stanza;

public class QueuedStanzaProcessor
implements StanzaProcessor {
    private final ResponseWriter responseWriter = new ResponseWriter();
    protected ExecutorService executor;
    protected StanzaProcessor stanzaProcessor;

    public QueuedStanzaProcessor(StanzaProcessor stanzaProcessor) {
        int coreThreadCount = 10;
        int maxThreadCount = 20;
        int threadTimeoutSeconds = 120000;
        this.executor = new ThreadPoolExecutor(coreThreadCount, maxThreadCount, threadTimeoutSeconds, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.stanzaProcessor = stanzaProcessor;
    }

    public void processStanza(ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext, Stanza stanza, SessionStateHolder sessionStateHolder) {
        this.executor.submit(new StanzaProcessorUnitOfWork(sessionContext, stanza, sessionStateHolder));
    }

    public void processTLSEstablished(SessionContext sessionContext, SessionStateHolder sessionStateHolder) {
        ProtocolWorker.processTLSEstablishedInternal(sessionContext, sessionStateHolder, this.responseWriter);
    }

    private class StanzaProcessorUnitOfWork
    implements Runnable {
        private SessionContext sessionContext;
        private Stanza stanza;
        private SessionStateHolder sessionStateHolder;

        private StanzaProcessorUnitOfWork(SessionContext sessionContext, Stanza stanza, SessionStateHolder sessionStateHolder) {
            this.sessionContext = sessionContext;
            this.stanza = stanza;
            this.sessionStateHolder = sessionStateHolder;
        }

        public void run() {
            QueuedStanzaProcessor.this.stanzaProcessor.processStanza(this.sessionContext.getServerRuntimeContext(), this.sessionContext, this.stanza, this.sessionStateHolder);
        }
    }
}

