/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hslf.record.FontEntityAtom;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordContainer;
import org.apache.poi.hslf.record.RecordTypes;

public class FontCollection
extends RecordContainer {
    private List fonts;
    private byte[] _header = new byte[8];

    protected FontCollection(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._children = Record.findChildRecords(source, start + 8, len - 8);
        this.fonts = new ArrayList();
        for (int i = 0; i < this._children.length; ++i) {
            if (this._children[i] instanceof FontEntityAtom) {
                FontEntityAtom atom = (FontEntityAtom)this._children[i];
                this.fonts.add(atom.getFontName());
                continue;
            }
            this.logger.log(5, (Object)("Warning: FontCollection child wasn't a FontEntityAtom, was " + this._children[i]));
        }
    }

    public long getRecordType() {
        return RecordTypes.FontCollection.typeID;
    }

    public void writeOut(OutputStream out) throws IOException {
        this.writeOut(this._header[0], this._header[1], this.getRecordType(), this._children, out);
    }

    public int addFont(String name) {
        for (int i = 0; i < this.fonts.size(); ++i) {
            if (!this.fonts.get(i).equals(name)) continue;
            return i;
        }
        FontEntityAtom fnt = new FontEntityAtom();
        fnt.setFontIndex(this.fonts.size() << 4);
        fnt.setFontName(name);
        this.fonts.add(name);
        this.appendChildRecord(fnt);
        return this.fonts.size() - 1;
    }

    public String getFontWithId(int id) {
        if (id >= this.fonts.size()) {
            return null;
        }
        return (String)this.fonts.get(id);
    }
}

