/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.StringEval;
import org.apache.poi.hssf.record.formula.eval.StringValueEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.TextFunction;

public class Trim
extends TextFunction {
    public Eval evaluate(Eval[] operands, int srcCellRow, short srcCellCol) {
        ValueEval retval = ErrorEval.VALUE_INVALID;
        String str = null;
        switch (operands.length) {
            default: {
                break;
            }
            case 1: {
                ValueEval veval = this.singleOperandEvaluate(operands[0], srcCellRow, srcCellCol);
                if (veval instanceof StringValueEval) {
                    StringValueEval sve = (StringValueEval)veval;
                    str = sve.getStringValue();
                    if (str != null && !str.trim().equals("")) break;
                    return BlankEval.INSTANCE;
                }
                if (veval instanceof NumberEval) {
                    NumberEval neval = (NumberEval)veval;
                    str = neval.getStringValue();
                    break;
                }
                if (!(veval instanceof BlankEval)) break;
                return BlankEval.INSTANCE;
            }
        }
        if (str != null) {
            retval = new StringEval(str.trim());
        }
        return retval;
    }
}

