/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.wrapper;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.TypeLiteral;
import javax.faces.FacesWrapper;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.cdi.wrapper.FacesConverterAnnotationLiteral;

public class FacesConverterCDIWrapper
implements PartialStateHolder,
Converter,
FacesWrapper<Converter> {
    private static final Type CONVERTER_TYPE = new TypeLiteral<Converter<?>>(){
        private static final long serialVersionUID = 1L;
    }.getType();
    private transient Converter delegate;
    private Class<?> forClass;
    private String converterId;
    private boolean _transient;
    private boolean _initialStateMarked = false;

    public FacesConverterCDIWrapper() {
    }

    public FacesConverterCDIWrapper(Class<? extends Converter> converterClass, Class<?> forClass, String converterId) {
        this.forClass = forClass;
        this.converterId = converterId;
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
        return this.getWrapped().getAsObject(context, component, value);
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
        return this.getWrapped().getAsString(context, component, value);
    }

    public Converter getWrapped() {
        if (this.delegate == null) {
            BeanManager bm = CDIUtils.getBeanManager(FacesContext.getCurrentInstance().getExternalContext());
            if (this.converterId != null) {
                FacesConverterAnnotationLiteral literal = new FacesConverterAnnotationLiteral(Object.class, this.converterId);
                this.delegate = (Converter)CDIUtils.get(bm, CONVERTER_TYPE, true, new Annotation[]{literal});
                if (this.delegate == null) {
                    this.delegate = CDIUtils.get(bm, Converter.class, true, new Annotation[]{literal});
                }
            } else if (this.forClass != null) {
                FacesConverterAnnotationLiteral literal = new FacesConverterAnnotationLiteral(this.forClass, "");
                this.delegate = (Converter)CDIUtils.get(bm, CONVERTER_TYPE, true, new Annotation[]{literal});
                if (this.delegate == null) {
                    this.delegate = CDIUtils.get(bm, Converter.class, true, new Annotation[]{literal});
                }
            }
        }
        return this.delegate;
    }

    public Object saveState(FacesContext context) {
        if (!this.initialStateMarked()) {
            Object[] values = new Object[]{this.forClass, this.converterId};
            return values;
        }
        return null;
    }

    public void restoreState(FacesContext context, Object state) {
        if (state != null) {
            Object[] values = (Object[])state;
            this.forClass = (Class)values[0];
            this.converterId = (String)values[1];
        }
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean newTransientValue) {
        this._transient = newTransientValue;
    }

    public void clearInitialState() {
        this._initialStateMarked = false;
    }

    public boolean initialStateMarked() {
        return this._initialStateMarked;
    }

    public void markInitialState() {
        this._initialStateMarked = true;
    }
}

