/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.util.Collections;
import java.util.List;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.LiteralTree;
import jpt.sun.source.tree.MemberSelectTree;
import jpt.sun.source.tree.MethodInvocationTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.TreePath;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

public class StringBuilderAppend {
    public static ErrorDescription builder(HintContext ctx) {
        return StringBuilderAppend.hint(ctx, "StringBuilder");
    }

    public static ErrorDescription buffer(HintContext ctx) {
        return StringBuilderAppend.hint(ctx, "StringBuffer");
    }

    private static ErrorDescription hint(HintContext ctx, String clazzName) {
        CompilationInfo info = ctx.getInfo();
        MethodInvocationTree mit = (MethodInvocationTree)ctx.getPath().getLeaf();
        ExpressionTree param = mit.getArguments().get(0);
        List<List<TreePath>> sorted = Utilities.splitStringConcatenationToElements(info, new TreePath(ctx.getPath(), param));
        if (sorted.size() > 1) {
            String error = NbBundle.getMessage(StringBuilderAppend.class, "ERR_StringBuilderAppend", clazzName);
            return ErrorDescriptionFactory.forTree(ctx, param, error, new FixImpl(info, ctx.getPath()).toEditorFix());
        }
        return null;
    }

    private static final class FixImpl
    extends JavaFix {
        public FixImpl(CompilationInfo info, TreePath tp) {
            super(info, tp);
        }

        @Override
        public String getText() {
            return NbBundle.getMessage(StringBuilderAppend.class, "FIX_StringBuilderAppend");
        }

        private ExpressionTree merge(TreeMaker make, ExpressionTree arg1, ExpressionTree arg2) {
            if (arg1 == null) {
                return arg2;
            }
            if (arg2 == null) {
                return arg1;
            }
            if (arg1 == arg2) {
                return arg1;
            }
            return make.Binary(Tree.Kind.PLUS, arg1, arg2);
        }

        private ExpressionTree merge(TreeMaker make, ExpressionTree arg, ExpressionTree singleLeaf, StringBuilder literal, ExpressionTree l) {
            ExpressionTree n;
            if (singleLeaf != null) {
                n = singleLeaf;
                literal.delete(0, literal.length());
                n = this.merge(make, n, l);
            } else if (literal.length() > 0) {
                n = make.Literal(literal.toString());
                literal.delete(0, literal.length());
                n = this.merge(make, n, l);
            } else {
                n = l;
            }
            return this.merge(make, arg, n);
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy copy = ctx.getWorkingCopy();
            TreePath tp = ctx.getPath();
            MethodInvocationTree mit = (MethodInvocationTree)tp.getLeaf();
            ExpressionTree param = mit.getArguments().get(0);
            List<List<TreePath>> sorted = Utilities.splitStringConcatenationToElements(copy, new TreePath(tp, param));
            ExpressionTree site = ((MemberSelectTree)mit.getMethodSelect()).getExpression();
            TreeMaker make = copy.getTreeMaker();
            for (List<TreePath> cluster : sorted) {
                StringBuilder literal = new StringBuilder();
                ExpressionTree singleLeaf = null;
                ExpressionTree arg = null;
                if (cluster.size() == 1 && !Utilities.isConstantString(copy, cluster.get(0), true)) {
                    arg = (ExpressionTree)cluster.get(0).getLeaf();
                } else {
                    for (TreePath p : cluster) {
                        ExpressionTree l = (ExpressionTree)p.getLeaf();
                        if (Utilities.isStringOrCharLiteral(l)) {
                            singleLeaf = literal.length() == 0 ? l : null;
                            literal.append(((LiteralTree)l).getValue().toString());
                            continue;
                        }
                        arg = this.merge(make, arg, singleLeaf, literal, l);
                        singleLeaf = null;
                    }
                }
                arg = this.merge(make, arg, singleLeaf, literal, null);
                site = make.MethodInvocation(Collections.emptyList(), make.MemberSelect(site, "append"), Collections.singletonList(arg));
            }
            copy.rewrite(mit, site);
        }
    }
}

