/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.finalize;

import java.util.Set;
import jpt.sun.source.tree.MethodTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Modifier;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.finalize.Util;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

public class FinalizeNotProtected {
    public static ErrorDescription hint(HintContext ctx) {
        Set<Modifier> modifiers;
        assert (ctx != null);
        TreePath tp = ctx.getPath();
        MethodTree tree = (MethodTree)tp.getLeaf();
        if (Util.isFinalize(tree) && (modifiers = tree.getModifiers().getFlags()).contains((Object)Modifier.PUBLIC)) {
            return ErrorDescriptionFactory.forName(ctx, tp, NbBundle.getMessage(FinalizeNotProtected.class, "TXT_FinalizeNotProtected"), new FixImpl(TreePathHandle.create(tp, ctx.getInfo())).toEditorFix());
        }
        return null;
    }

    static class FixImpl
    extends JavaFix {
        FixImpl(TreePathHandle handle) {
            super(handle);
            assert (handle != null);
        }

        @Override
        public String getText() {
            return NbBundle.getMessage(FinalizeNotProtected.class, "FIX_FinalizeNotProtected_MakePublic");
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath tp = ctx.getPath();
            Tree tree = tp.getLeaf();
            if (tree.getKind() != Tree.Kind.METHOD) {
                return;
            }
            TreeMaker tm = wc.getTreeMaker();
            wc.rewrite(((MethodTree)tree).getModifiers(), tm.addModifiersModifier(tm.removeModifiersModifier(((MethodTree)tree).getModifiers(), Modifier.PUBLIC), Modifier.PROTECTED));
        }
    }
}

