/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbpackage.appimage;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.netbeans.nbpackage.AbstractPackagerTask;
import org.apache.netbeans.nbpackage.ExecutionContext;
import org.apache.netbeans.nbpackage.NBPackage;
import org.apache.netbeans.nbpackage.StringUtils;
import org.apache.netbeans.nbpackage.appimage.AppImagePackager;

class AppImageTask
extends AbstractPackagerTask {
    AppImageTask(ExecutionContext context) {
        super(context);
    }

    @Override
    protected void checkPackageRequirements() throws Exception {
        Path tool = this.context().getValue(AppImagePackager.APPIMAGE_TOOL).orElseThrow(() -> new IllegalStateException(AppImagePackager.MESSAGES.getString("message.noappimagetool")));
        if (!Files.isExecutable(tool)) {
            throw new IllegalStateException(AppImagePackager.MESSAGES.getString("message.noappimagetool"));
        }
    }

    @Override
    protected void customizeImage(Path image) throws Exception {
        Path usrLib = image.resolve("usr").resolve("lib");
        String execName = this.findLauncher(usrLib.resolve("APPDIR").resolve("bin")).getFileName().toString();
        Path appDir = usrLib.resolve(execName);
        Files.move(usrLib.resolve("APPDIR"), appDir, new CopyOption[0]);
        Path usrBin = image.resolve("usr").resolve("bin");
        Files.createDirectories(usrBin, new FileAttribute[0]);
        Files.createSymbolicLink(usrBin.resolve(execName), usrBin.relativize(appDir.resolve("bin").resolve(execName)), new FileAttribute[0]);
        this.setupIcons(image, execName);
        this.setupDesktopFile(image, execName);
        this.setupAppRunScript(image, execName);
    }

    @Override
    protected Path buildPackage(Path image) throws Exception {
        Path tool = this.context().getValue(AppImagePackager.APPIMAGE_TOOL).orElseThrow(() -> new IllegalStateException(AppImagePackager.MESSAGES.getString("message.noappimagetool"))).toAbsolutePath();
        String arch = this.context().getValue(NBPackage.PACKAGE_ARCH).orElse(this.archFromAppImageTool(tool));
        Object targetName = image.getFileName().toString();
        if (((String)targetName).endsWith(".AppDir")) {
            targetName = ((String)targetName).substring(0, ((String)targetName).length() - 7);
        }
        targetName = (String)targetName + "-" + arch + ".AppImage";
        Path target = this.context().destination().resolve((String)targetName);
        List<String> cmd = List.of(tool.toString(), image.toAbsolutePath().toString(), target.toString());
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.environment().put("ARCH", arch);
        int result = this.context().exec(pb);
        if (result != 0) {
            throw new Exception();
        }
        return target;
    }

    @Override
    protected String calculateImageName(Path input) throws Exception {
        String version = this.sanitize(this.context().getValue(NBPackage.PACKAGE_VERSION).orElse(""));
        return this.sanitize(this.context().getValue(NBPackage.PACKAGE_NAME).orElseThrow()) + (String)(version.isBlank() ? ".AppDir" : "-" + version + ".AppDir");
    }

    @Override
    protected Path calculateAppPath(Path image) throws Exception {
        return image.resolve("usr").resolve("lib").resolve("APPDIR");
    }

    @Override
    protected Path calculateRuntimePath(Path image, Path application) throws Exception {
        return image.resolve("usr").resolve("lib").resolve("jdk");
    }

    private String sanitize(String name) {
        return name.replaceAll("[^a-zA-Z0-9-_\\.]", "_");
    }

    private Path findLauncher(Path binDir) throws IOException {
        try (Stream<Path> files = Files.list(binDir);){
            Path path = files.filter(f -> !f.getFileName().toString().endsWith(".exe")).findFirst().orElseThrow(IOException::new);
            return path;
        }
    }

    private void setupIcons(Path image, String execName) throws IOException {
        Path iconDir = image.resolve("usr").resolve("share").resolve("icons").resolve("hicolor").resolve("48x48").resolve("apps");
        Files.createDirectories(iconDir, new FileAttribute[0]);
        Path iconFile = iconDir.resolve(execName + ".png");
        Path icon = this.context().getValue(AppImagePackager.APPIMAGE_ICON).orElse(null);
        if (icon != null) {
            Files.copy(icon, iconFile, new CopyOption[0]);
        } else {
            Files.copy(this.getClass().getResourceAsStream("/org/apache/netbeans/nbpackage/apache-netbeans-48x48.png"), iconFile, new CopyOption[0]);
        }
        Files.createSymbolicLink(image.resolve(".AppDir"), image.relativize(iconFile), new FileAttribute[0]);
        Files.createSymbolicLink(image.resolve(execName + ".png"), image.relativize(iconFile), new FileAttribute[0]);
    }

    private void setupDesktopFile(Path image, String execName) throws IOException {
        String template = AppImagePackager.DESKTOP_TEMPLATE.load(this.context());
        String desktop = StringUtils.replaceTokens(template, key -> "EXEC".equals(key) ? execName : this.context().tokenReplacementFor((String)key));
        Path desktopDir = image.resolve("usr").resolve("share").resolve("applications");
        Files.createDirectories(desktopDir, new FileAttribute[0]);
        Path desktopFile = desktopDir.resolve(execName + ".desktop");
        Files.writeString(desktopFile, (CharSequence)desktop, StandardOpenOption.CREATE_NEW);
        Files.createSymbolicLink(image.resolve(execName + ".desktop"), image.relativize(desktopFile), new FileAttribute[0]);
    }

    private void setupAppRunScript(Path image, String execName) throws IOException {
        String template = AppImagePackager.LAUNCHER_TEMPLATE.load(this.context());
        String appRun = StringUtils.replaceTokens(template, Map.of("EXEC", execName));
        Path appRunPath = image.resolve("AppRun");
        Files.writeString(appRunPath, (CharSequence)appRun, StandardOpenOption.CREATE_NEW);
        Files.setPosixFilePermissions(appRunPath, PosixFilePermissions.fromString("rwxr-xr-x"));
    }

    private String archFromAppImageTool(Path appImageTool) {
        String filename = appImageTool.getFileName().toString();
        for (String arch : new String[]{"x86_64", "i686", "aarch64", "armhf"}) {
            if (!filename.contains(arch)) continue;
            return arch;
        }
        return "";
    }
}

