/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate.binop;

import java.util.NoSuchElementException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.binop.BinaryOperatorEntityIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddNullDecoratorIterable
extends BinaryOperatorEntityIterable {
    public AddNullDecoratorIterable(@NotNull PersistentStoreTransaction txn, @NotNull EntityIterableBase decorated, @NotNull EntityIterableBase nullContainer) {
        super(txn, decorated, nullContainer, false);
        if (decorated.isSortedById()) {
            this.depth += 0x20000000;
        }
    }

    @Override
    @NotNull
    public EntityIterator getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new EntityIteratorBase(this){
            private EntityIterator iterator;
            private Boolean hasNull;
            {
                this.iterator = null;
                this.hasNull = null;
            }

            @Override
            public boolean hasNextImpl() {
                if (this.iterator == null) {
                    this.iterator = AddNullDecoratorIterable.this.getLeft().iterator();
                }
                if (this.iterator.hasNext()) {
                    return true;
                }
                if (this.hasNull == null) {
                    this.hasNull = false;
                    EntityIterator entityIterator = AddNullDecoratorIterable.this.getRight().iterator();
                    while (entityIterator.hasNext()) {
                        Entity entity = (Entity)entityIterator.next();
                        if (entity != null) continue;
                        this.hasNull = true;
                        break;
                    }
                }
                return this.hasNull;
            }

            @Override
            @Nullable
            protected EntityId nextIdImpl() {
                if (this.hasNextImpl()) {
                    if (this.hasNull == null) {
                        EntityId result = this.iterator.nextId();
                        if (result == null) {
                            this.hasNull = false;
                        }
                        return result;
                    }
                    this.hasNull = false;
                    return null;
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    protected EntityIterableType getIterableType() {
        return EntityIterableType.ADD_NULL;
    }

    static {
        AddNullDecoratorIterable.registerType(EntityIterableType.ADD_NULL, (txn, store, parameters) -> new AddNullDecoratorIterable(txn, (EntityIterableBase)parameters[0], (EntityIterableBase)parameters[1]));
    }
}

