/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.AtomicIntList;
import io.questdb.std.BoolList;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.FilesFacade;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import java.io.Closeable;

class WalWriterEvents
implements Closeable {
    private final MemoryMARW eventMem = Vm.getMARWInstance();
    private final FilesFacade ff;
    private final StringSink sink = new StringSink();
    private AtomicIntList initialSymbolCounts;
    private long startOffset = 0L;
    private BoolList symbolMapNullFlags;
    private int txn = 0;
    private ObjList<CharSequenceIntHashMap> txnSymbolMaps;

    WalWriterEvents(FilesFacade ff) {
        this.ff = ff;
    }

    @Override
    public void close() {
        this.eventMem.close(true, (byte)1);
    }

    private void init() {
        this.eventMem.putLong(16L);
        this.eventMem.putInt(0);
        this.eventMem.putInt(-1);
        this.txn = 0;
    }

    private void writeFunction(Function function) {
        int type = function.getType();
        this.eventMem.putInt(type);
        switch (ColumnType.tagOf(type)) {
            case 1: {
                this.eventMem.putBool(function.getBool(null));
                break;
            }
            case 2: {
                this.eventMem.putByte(function.getByte(null));
                break;
            }
            case 14: {
                this.eventMem.putByte(function.getGeoByte(null));
                break;
            }
            case 3: {
                this.eventMem.putShort(function.getShort(null));
                break;
            }
            case 15: {
                this.eventMem.putShort(function.getGeoShort(null));
                break;
            }
            case 4: {
                this.eventMem.putChar(function.getChar(null));
                break;
            }
            case 5: {
                this.eventMem.putInt(function.getInt(null));
                break;
            }
            case 16: {
                this.eventMem.putInt(function.getGeoInt(null));
                break;
            }
            case 9: {
                this.eventMem.putFloat(function.getFloat(null));
                break;
            }
            case 6: {
                this.eventMem.putLong(function.getLong(null));
                break;
            }
            case 17: {
                this.eventMem.putLong(function.getGeoLong(null));
                break;
            }
            case 7: {
                this.eventMem.putLong(function.getDate(null));
                break;
            }
            case 8: {
                this.eventMem.putLong(function.getTimestamp(null));
                break;
            }
            case 10: {
                this.eventMem.putDouble(function.getDouble(null));
                break;
            }
            case 11: {
                this.eventMem.putStr(function.getStr(null));
                break;
            }
            case 18: {
                this.eventMem.putBin(function.getBin(null));
                break;
            }
            case 19: {
                this.eventMem.putLong128(function.getLong128Lo(null), function.getLong128Hi(null));
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported column type: " + ColumnType.nameOf(type));
            }
        }
    }

    private void writeIndexedVariables(BindVariableService bindVariableService) {
        int count = bindVariableService != null ? bindVariableService.getIndexedVariableCount() : 0;
        this.eventMem.putInt(count);
        for (int i = 0; i < count; ++i) {
            this.writeFunction(bindVariableService.getFunction(i));
        }
    }

    private void writeNamedVariables(BindVariableService bindVariableService) {
        int count = bindVariableService != null ? bindVariableService.getNamedVariables().size() : 0;
        this.eventMem.putInt(count);
        if (count > 0) {
            ObjList<CharSequence> namedVariables = bindVariableService.getNamedVariables();
            for (int i = 0; i < count; ++i) {
                CharSequence name = namedVariables.get(i);
                this.eventMem.putStr(name);
                this.sink.clear();
                this.sink.put(':').put(name);
                this.writeFunction(bindVariableService.getFunction(this.sink));
            }
        }
    }

    private void writeSymbolMapDiffs() {
        int columns = this.txnSymbolMaps.size();
        for (int i = 0; i < columns; ++i) {
            int initialCount;
            CharSequenceIntHashMap symbolMap = this.txnSymbolMaps.getQuick(i);
            if (symbolMap == null || (initialCount = this.initialSymbolCounts.get(i)) <= 0 && (initialCount != 0 || symbolMap.size() <= 0)) continue;
            this.eventMem.putInt(i);
            this.eventMem.putBool(this.symbolMapNullFlags.get(i));
            this.eventMem.putInt(initialCount);
            int size = symbolMap.size();
            long appendAddress = this.eventMem.getAppendOffset();
            this.eventMem.putInt(size);
            int symbolCount = 0;
            for (int j = 0; j < size; ++j) {
                CharSequence symbol = symbolMap.keys().getQuick(j);
                int value = symbolMap.get(symbol);
                if (value < initialCount) continue;
                this.eventMem.putInt(value);
                this.eventMem.putStr(symbol);
                ++symbolCount;
            }
            this.eventMem.putInt(appendAddress, symbolCount);
            this.eventMem.putInt(-1);
        }
        this.eventMem.putInt(-1);
    }

    int appendData(long startRowID, long endRowID, long minTimestamp, long maxTimestamp, boolean outOfOrder) {
        this.startOffset = this.eventMem.getAppendOffset() - 4L;
        this.eventMem.putLong(this.txn);
        this.eventMem.putByte((byte)0);
        this.eventMem.putLong(startRowID);
        this.eventMem.putLong(endRowID);
        this.eventMem.putLong(minTimestamp);
        this.eventMem.putLong(maxTimestamp);
        this.eventMem.putBool(outOfOrder);
        this.writeSymbolMapDiffs();
        this.eventMem.putInt(this.startOffset, (int)(this.eventMem.getAppendOffset() - this.startOffset));
        this.eventMem.putInt(-1);
        this.eventMem.putLong(0L, this.eventMem.getAppendOffset());
        return this.txn++;
    }

    int appendSql(int cmdType, CharSequence sqlText, SqlExecutionContext sqlExecutionContext) {
        this.startOffset = this.eventMem.getAppendOffset() - 4L;
        this.eventMem.putLong(this.txn);
        this.eventMem.putByte((byte)1);
        this.eventMem.putInt(cmdType);
        this.eventMem.putStr(sqlText);
        Rnd rnd = sqlExecutionContext.getRandom();
        this.eventMem.putLong(rnd.getSeed0());
        this.eventMem.putLong(rnd.getSeed1());
        BindVariableService bindVariableService = sqlExecutionContext.getBindVariableService();
        this.writeIndexedVariables(bindVariableService);
        this.writeNamedVariables(bindVariableService);
        this.eventMem.putInt(this.startOffset, (int)(this.eventMem.getAppendOffset() - this.startOffset));
        this.eventMem.putInt(-1);
        this.eventMem.putLong(0L, this.eventMem.getAppendOffset());
        return this.txn++;
    }

    void of(ObjList<CharSequenceIntHashMap> txnSymbolMaps, AtomicIntList initialSymbolCounts, BoolList symbolMapNullFlags) {
        this.txnSymbolMaps = txnSymbolMaps;
        this.initialSymbolCounts = initialSymbolCounts;
        this.symbolMapNullFlags = symbolMapNullFlags;
    }

    void openEventFile(Path path, int pathLen) {
        if (this.eventMem.getFd() > -1) {
            this.close();
        }
        TableUtils.openSmallFile(this.ff, path, pathLen, this.eventMem, "_event", 37);
        this.init();
    }

    void rollback() {
        this.eventMem.jumpTo(this.startOffset);
        this.eventMem.putInt(-1);
        this.eventMem.putLong(0L, this.eventMem.getAppendOffset());
    }

    int truncate() {
        this.startOffset = this.eventMem.getAppendOffset() - 4L;
        this.eventMem.putLong(this.txn);
        this.eventMem.putByte((byte)2);
        this.eventMem.putInt(this.startOffset, (int)(this.eventMem.getAppendOffset() - this.startOffset));
        this.eventMem.putInt(-1);
        this.eventMem.putLong(0L, this.eventMem.getAppendOffset());
        return this.txn++;
    }
}

