/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font.descriptor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.fontbox.ttf.CIDFontType2Parser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptorDictionary;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.font.FontValidator;
import org.apache.pdfbox.preflight.font.container.CIDType2Container;
import org.apache.pdfbox.preflight.font.descriptor.FontDescriptorHelper;
import org.apache.pdfbox.preflight.utils.COSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CIDType2DescriptorHelper
extends FontDescriptorHelper<CIDType2Container> {
    public CIDType2DescriptorHelper(PreflightContext context, PDFont font, CIDType2Container fontContainer) {
        super(context, font, fontContainer);
    }

    protected void checkCIDSet(PDFontDescriptorDictionary pfDescriptor) {
        if (FontValidator.isSubSet(pfDescriptor.getFontName())) {
            COSDocument cosDocument = this.context.getDocument().getDocument();
            COSBase cidset = pfDescriptor.getCOSDictionary().getItem(COSName.getPDFName((String)"CIDSet"));
            if (cidset == null || !COSUtils.isStream(cidset, cosDocument)) {
                ((CIDType2Container)this.fContainer).push(new ValidationResult.ValidationError("3.1.11", "The CIDSet entry is missing for the Composite Subset"));
            }
        }
    }

    @Override
    public PDStream extractFontFile(PDFontDescriptorDictionary fontDescriptor) {
        COSStream stream;
        PDStream ff2 = fontDescriptor.getFontFile2();
        if (ff2 != null && (stream = ff2.getStream()) == null) {
            ((CIDType2Container)this.fContainer).push(new ValidationResult.ValidationError("3.1.3", "The FontFile is missing for " + fontDescriptor.getFontName()));
            ((CIDType2Container)this.fContainer).notEmbedded();
        }
        this.checkCIDSet(fontDescriptor);
        return ff2;
    }

    @Override
    protected void processFontFile(PDFontDescriptorDictionary fontDescriptor, PDStream fontFile) {
        TrueTypeFont ttf = null;
        try {
            ttf = new CIDFontType2Parser(true).parseTTF((InputStream)new ByteArrayInputStream(fontFile.getByteArray()));
            ((CIDType2Container)this.fContainer).setTtf(ttf);
        }
        catch (Exception e) {
            ((CIDType2Container)this.fContainer).push(new ValidationResult.ValidationError("3.2.3", "The FontFile can't be read"));
        }
    }
}

