/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.process.reflect;

import java.io.IOException;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingResources;
import org.apache.pdfbox.preflight.PreflightConfiguration;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightPath;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.graphic.ColorSpaceHelper;
import org.apache.pdfbox.preflight.graphic.ColorSpaceHelperFactory;
import org.apache.pdfbox.preflight.process.AbstractProcess;
import org.apache.pdfbox.preflight.utils.ContextHelper;

public class ShaddingPatternValidationProcess
extends AbstractProcess {
    public void validate(PreflightContext context) throws ValidationException {
        PreflightPath vPath = context.getValidationPath();
        if (vPath.isEmpty()) {
            return;
        }
        if (!vPath.isExpectedType(PDShadingResources.class)) {
            context.addValidationError(new ValidationResult.ValidationError("2.1.9", "ShadingPattern validation required at least a PDResources"));
        } else {
            PDShadingResources shaddingResource = (PDShadingResources)vPath.peek();
            PDPage page = vPath.getClosestPathElement(PDPage.class);
            this.checkColorSpace(context, page, shaddingResource);
            this.checkGraphicState(context, page, shaddingResource);
        }
    }

    protected void checkColorSpace(PreflightContext context, PDPage page, PDShadingResources shadingRes) throws ValidationException {
        try {
            PDColorSpace pColorSpace = shadingRes.getColorSpace();
            PreflightConfiguration config = context.getConfig();
            ColorSpaceHelperFactory csFact = config.getColorSpaceHelperFact();
            ColorSpaceHelper csh = csFact.getColorSpaceHelper(context, pColorSpace, ColorSpaceHelperFactory.ColorSpaceRestriction.NO_PATTERN);
            csh.validate();
        }
        catch (IOException e) {
            context.addValidationError(new ValidationResult.ValidationError("2.4.4", e.getMessage()));
        }
    }

    protected void checkGraphicState(PreflightContext context, PDPage page, PDShadingResources shadingRes) throws ValidationException {
        COSDictionary resources = (COSDictionary)shadingRes.getCOSDictionary().getDictionaryObject("ExtGState");
        if (resources != null) {
            ContextHelper.validateElement(context, resources, "extgstate-process");
        }
    }
}

