/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.function.Consumer;
import javax.xml.transform.Result;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceiverOption;
import net.sf.saxon.event.RegularSequenceChecker;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.Durability;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.GenericTreeInfo;
import net.sf.saxon.om.Genre;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.s9api.HostLanguage;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.StringConstants;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UniStringConsumer;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public final class ComplexContentOutputter
extends Outputter
implements Receiver,
Result {
    private Receiver nextReceiver;
    private NodeName pendingStartTag = null;
    private int level = -1;
    private boolean[] currentLevelIsDocument = new boolean[20];
    private final List<AttributeInfo> pendingAttributes = new ArrayList<AttributeInfo>();
    private NamespaceMap pendingNSMap;
    private final Stack<NamespaceMap> inheritedNamespaces = new Stack();
    private SchemaType currentSimpleType = null;
    private int startElementProperties;
    private Location startElementLocationId = Loc.NONE;
    private HostLanguage hostLanguage = HostLanguage.XSLT;
    private RegularSequenceChecker.State state = RegularSequenceChecker.State.INITIAL;
    private boolean previousAtomic = false;

    public ComplexContentOutputter(Receiver next) {
        PipelineConfiguration pipe = next.getPipelineConfiguration();
        this.setPipelineConfiguration(pipe);
        this.setReceiver(next);
        Objects.requireNonNull(pipe);
        this.setHostLanguage(pipe.getHostLanguage());
        this.inheritedNamespaces.push(NamespaceMap.emptyMap());
    }

    public static ComplexContentOutputter makeComplexContentReceiver(Receiver receiver, ParseOptions options) {
        boolean validate;
        String systemId = receiver.getSystemId();
        boolean bl = validate = options != null && options.getSchemaValidationMode() != 3;
        if (validate) {
            Configuration config = receiver.getPipelineConfiguration().getConfiguration();
            receiver = config.getDocumentValidator(receiver, systemId, options, null);
        }
        ComplexContentOutputter result = new ComplexContentOutputter(receiver);
        result.setSystemId(systemId);
        return result;
    }

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        if (this.pipelineConfiguration != pipe) {
            this.pipelineConfiguration = pipe;
            if (this.nextReceiver != null) {
                this.nextReceiver.setPipelineConfiguration(pipe);
            }
        }
    }

    @Override
    public void setSystemId(String systemId) {
        super.setSystemId(systemId);
        this.nextReceiver.setSystemId(systemId);
    }

    public void setHostLanguage(HostLanguage language) {
        this.hostLanguage = language;
    }

    public void setReceiver(Receiver receiver) {
        this.nextReceiver = receiver;
    }

    public Receiver getReceiver() {
        return this.nextReceiver;
    }

    @Override
    public void open() throws XPathException {
        this.nextReceiver.open();
        this.previousAtomic = false;
        this.state = RegularSequenceChecker.State.OPEN;
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        ++this.level;
        if (this.level == 0) {
            this.nextReceiver.startDocument(properties);
        } else if (this.state == RegularSequenceChecker.State.START_TAG) {
            this.startContent();
        }
        this.previousAtomic = false;
        if (this.currentLevelIsDocument.length < this.level + 1) {
            this.currentLevelIsDocument = Arrays.copyOf(this.currentLevelIsDocument, this.level * 2);
        }
        this.currentLevelIsDocument[this.level] = true;
        this.state = RegularSequenceChecker.State.CONTENT;
    }

    @Override
    public void endDocument() throws XPathException {
        if (this.level == 0) {
            this.nextReceiver.endDocument();
        }
        this.previousAtomic = false;
        --this.level;
        this.state = this.level < 0 ? RegularSequenceChecker.State.OPEN : RegularSequenceChecker.State.CONTENT;
    }

    @Override
    public void setUnparsedEntity(String name, String systemID, String publicID) throws XPathException {
        this.nextReceiver.setUnparsedEntity(name, systemID, publicID);
    }

    @Override
    public void characters(UnicodeString s, Location locationId, int properties) throws XPathException {
        if (this.level >= 0) {
            this.previousAtomic = false;
            if (s == null) {
                return;
            }
            if (s.isEmpty()) {
                return;
            }
            if (this.state == RegularSequenceChecker.State.START_TAG) {
                this.startContent();
            }
        }
        this.nextReceiver.characters(s, locationId, properties);
    }

    @Override
    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        ++this.level;
        if (this.state == RegularSequenceChecker.State.START_TAG) {
            this.startContent();
        }
        this.startElementProperties = properties;
        this.startElementLocationId = location.saveLocation();
        this.pendingAttributes.clear();
        this.pendingNSMap = NamespaceMap.emptyMap();
        this.pendingStartTag = elemName;
        this.currentSimpleType = typeCode;
        this.previousAtomic = false;
        if (this.currentLevelIsDocument.length < this.level + 1) {
            this.currentLevelIsDocument = Arrays.copyOf(this.currentLevelIsDocument, this.level * 2);
        }
        this.currentLevelIsDocument[this.level] = false;
        this.state = RegularSequenceChecker.State.START_TAG;
    }

    @Override
    public void namespace(String prefix, NamespaceUri namespaceUri, int properties) throws XPathException {
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(namespaceUri);
        if (ReceiverOption.contains(properties, 64)) {
            this.pendingNSMap = this.pendingNSMap.put(prefix, namespaceUri);
        } else if (this.level >= 0) {
            NamespaceUri uri;
            if (this.state != RegularSequenceChecker.State.START_TAG) {
                throw NoOpenStartTagException.makeNoOpenStartTagException(13, prefix, this.hostLanguage, this.currentLevelIsDocument[this.level], this.startElementLocationId);
            }
            if (prefix.isEmpty() && !namespaceUri.isEmpty() && this.pendingStartTag.hasURI(NamespaceUri.NULL)) {
                throw new XPathException("Cannot output a namespace node for the default namespace (" + namespaceUri + ") when the element is in no namespace").withErrorCode(this.hostLanguage == HostLanguage.XSLT ? "XTDE0440" : "XQDY0102");
            }
            boolean rejectDuplicates = ReceiverOption.contains(properties, 32);
            if (rejectDuplicates && (uri = this.pendingNSMap.getNamespaceUri(prefix)) != null && !uri.equals(namespaceUri)) {
                throw new XPathException("Cannot create two namespace nodes with the same prefix mapped to different URIs (prefix=\"" + prefix + "\", URIs=(" + uri + "\", \"" + namespaceUri + "\")").withErrorCode(this.hostLanguage == HostLanguage.XSLT ? "XTDE0430" : "XQDY0102");
            }
            this.pendingNSMap = this.pendingNSMap.put(prefix, namespaceUri);
        } else {
            Orphan orphan = new Orphan(this.getConfiguration());
            orphan.setNodeKind((short)13);
            orphan.setNodeName(new NoNamespaceName(prefix));
            orphan.setStringValue(namespaceUri.toUnicodeString());
            this.nextReceiver.append(orphan, Loc.NONE, properties);
        }
        this.previousAtomic = false;
    }

    @Override
    public void namespaces(NamespaceBindingSet bindings, int properties) throws XPathException {
        if (bindings instanceof NamespaceMap && this.pendingNSMap.isEmpty() && ReceiverOption.contains(properties, 64)) {
            this.pendingNSMap = (NamespaceMap)bindings;
        } else {
            super.namespaces(bindings, properties);
        }
    }

    @Override
    public void attribute(NodeName attName, SimpleType typeCode, String value, Location locationId, int properties) throws XPathException {
        if (this.level >= 0 && this.state != RegularSequenceChecker.State.START_TAG) {
            NoOpenStartTagException err = NoOpenStartTagException.makeNoOpenStartTagException(2, attName.getDisplayName(), this.hostLanguage, this.currentLevelIsDocument[this.level], this.startElementLocationId);
            err.setLocator(locationId);
            throw err;
        }
        AttributeInfo attInfo = new AttributeInfo(attName, typeCode, value, locationId, properties);
        if (this.level >= 0 && !ReceiverOption.contains(properties, 0x100000)) {
            for (int a = 0; a < this.pendingAttributes.size(); ++a) {
                if (!this.pendingAttributes.get(a).getNodeName().equals(attName)) continue;
                if (this.hostLanguage == HostLanguage.XSLT) {
                    this.pendingAttributes.set(a, attInfo);
                    return;
                }
                throw new XPathException("Cannot create an element having two attributes with the same name: " + Err.wrap(attName.getDisplayName(), 2)).withErrorCode("XQDY0025");
            }
        }
        if (this.level == 0 && !typeCode.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && this.currentLevelIsDocument[0] && typeCode.isNamespaceSensitive()) {
            throw new XPathException("Cannot copy attributes whose type is namespace-sensitive (QName or NOTATION): " + Err.wrap(attName.getDisplayName(), 2)).withErrorCode(this.hostLanguage == HostLanguage.XSLT ? "XTTE0950" : "XQTY0086");
        }
        if (this.level < 0) {
            Orphan orphan = new Orphan(this.getConfiguration());
            ((GenericTreeInfo)orphan.getTreeInfo()).setDurability(Durability.MUTABLE);
            orphan.setNodeKind((short)2);
            orphan.setNodeName(attName);
            orphan.setTypeAnnotation(typeCode);
            orphan.setStringValue(StringView.tidy(value));
            this.nextReceiver.append(orphan, locationId, properties);
        }
        this.pendingAttributes.add(attInfo);
        this.previousAtomic = false;
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        NamespaceMap ns2;
        boolean inherit;
        if (this.state == RegularSequenceChecker.State.START_TAG) {
            this.startContent();
        }
        ++this.level;
        this.startElementLocationId = location.saveLocation();
        if (this.currentLevelIsDocument.length < this.level + 1) {
            this.currentLevelIsDocument = Arrays.copyOf(this.currentLevelIsDocument, this.level * 2);
        }
        this.currentLevelIsDocument[this.level] = false;
        if (elemName.hasURI(NamespaceUri.NULL) && !namespaces.getDefaultNamespace().isEmpty()) {
            namespaces = namespaces.remove("");
        }
        boolean bl = inherit = !ReceiverOption.contains(properties, 128);
        if (inherit) {
            NamespaceMap inherited = this.inheritedNamespaces.peek();
            if (!inherited.getDefaultNamespace().isEmpty() && elemName.getNamespaceUri().isEmpty()) {
                inherited = inherited.remove("");
            }
            ns2 = inherited.putAll(namespaces);
            if (ReceiverOption.contains(properties, 131072)) {
                this.inheritedNamespaces.push(inherited);
            } else {
                this.inheritedNamespaces.push(ns2);
            }
        } else {
            ns2 = namespaces;
            this.inheritedNamespaces.push(NamespaceMap.emptyMap());
        }
        boolean refuseInheritedNamespaces = ReceiverOption.contains(properties, 65536);
        NamespaceMap ns3 = refuseInheritedNamespaces ? namespaces : ns2;
        this.nextReceiver.startElement(elemName, type, attributes, ns3, location, properties);
        this.state = RegularSequenceChecker.State.CONTENT;
    }

    private NodeName checkProposedPrefix(NodeName nodeName, int seq) {
        String nodePrefix = nodeName.getPrefix();
        NamespaceUri nodeURI = nodeName.getNamespaceUri();
        if (nodeURI.isEmpty()) {
            return nodeName;
        }
        NamespaceUri uri = this.pendingNSMap.getNamespaceUri(nodePrefix);
        if (uri == null) {
            this.pendingNSMap = this.pendingNSMap.put(nodePrefix, nodeURI);
            return nodeName;
        }
        if (nodeURI.equals(uri)) {
            return nodeName;
        }
        String newPrefix = this.getSubstitutePrefix(nodePrefix, nodeURI, seq);
        FingerprintedQName newName = new FingerprintedQName(newPrefix, nodeURI, nodeName.getLocalPart());
        this.pendingNSMap = this.pendingNSMap.put(newPrefix, nodeURI);
        return newName;
    }

    private String getSubstitutePrefix(String prefix, NamespaceUri uri, int seq) {
        if (uri.equals(NamespaceUri.XML)) {
            return "xml";
        }
        return prefix + '_' + seq;
    }

    @Override
    public void endElement() throws XPathException {
        if (this.state == RegularSequenceChecker.State.START_TAG) {
            this.startContent();
        } else {
            this.pendingStartTag = null;
        }
        this.nextReceiver.endElement();
        --this.level;
        this.previousAtomic = false;
        this.state = this.level < 0 ? RegularSequenceChecker.State.OPEN : RegularSequenceChecker.State.CONTENT;
        this.inheritedNamespaces.pop();
    }

    @Override
    public void comment(UnicodeString comment, Location locationId, int properties) throws XPathException {
        if (this.level >= 0) {
            if (this.state == RegularSequenceChecker.State.START_TAG) {
                this.startContent();
            }
            this.previousAtomic = false;
        }
        this.nextReceiver.comment(comment, locationId, properties);
    }

    @Override
    public void processingInstruction(String target, UnicodeString data, Location locationId, int properties) throws XPathException {
        if (this.level >= 0) {
            if (this.state == RegularSequenceChecker.State.START_TAG) {
                this.startContent();
            }
            this.previousAtomic = false;
        }
        this.nextReceiver.processingInstruction(target, data, locationId, properties);
    }

    @Override
    public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
        if (this.level >= 0) {
            this.decompose(item, locationId, copyNamespaces);
        } else {
            this.nextReceiver.append(item, locationId, copyNamespaces);
        }
    }

    @Override
    public UniStringConsumer getStringReceiver(boolean asTextNode, Location loc) {
        if (this.level >= 0) {
            return new UnicodeStringReceiver(this, this.previousAtomic, asTextNode, loc, prev -> {
                this.previousAtomic = prev;
            });
        }
        return super.getStringReceiver(asTextNode, loc);
    }

    @Override
    public void close() throws XPathException {
        this.nextReceiver.close();
        this.previousAtomic = false;
        this.state = RegularSequenceChecker.State.FINAL;
    }

    @Override
    public void startContent() throws XPathException {
        NamespaceMap inherited;
        if (this.state != RegularSequenceChecker.State.START_TAG) {
            return;
        }
        NodeName elcode = this.checkProposedPrefix(this.pendingStartTag, 0);
        int props = this.startElementProperties | 0x40;
        for (int a = 0; a < this.pendingAttributes.size(); ++a) {
            NodeName newName;
            NodeName oldName = this.pendingAttributes.get(a).getNodeName();
            if (oldName.hasURI(NamespaceUri.NULL) || (newName = this.checkProposedPrefix(oldName, a + 1)) == oldName) continue;
            AttributeInfo newInfo = this.pendingAttributes.get(a).withNodeName(newName);
            this.pendingAttributes.set(a, newInfo);
        }
        NamespaceMap namespaceMap = inherited = this.inheritedNamespaces.isEmpty() ? NamespaceMap.emptyMap() : this.inheritedNamespaces.peek();
        if (!ReceiverOption.contains(this.startElementProperties, 65536)) {
            this.pendingNSMap = inherited.putAll(this.pendingNSMap);
        }
        if (this.pendingStartTag.hasURI(NamespaceUri.NULL) && !this.pendingNSMap.getDefaultNamespace().isEmpty()) {
            this.pendingNSMap = this.pendingNSMap.remove("");
        }
        AttributeMap attributes = SequenceTool.attributeMapFromList(this.pendingAttributes);
        this.nextReceiver.startElement(elcode, this.currentSimpleType, attributes, this.pendingNSMap, this.startElementLocationId, props);
        this.finishStartContent(inherited);
    }

    private void finishStartContent(NamespaceMap inherited) {
        boolean inherit = !ReceiverOption.contains(this.startElementProperties, 128);
        this.inheritedNamespaces.push(inherit ? this.pendingNSMap : inherited);
        this.pendingAttributes.clear();
        this.pendingNSMap = NamespaceMap.emptyMap();
        this.previousAtomic = false;
        this.state = RegularSequenceChecker.State.CONTENT;
    }

    @Override
    public boolean usesTypeAnnotations() {
        return this.nextReceiver.usesTypeAnnotations();
    }

    private void flatten(ArrayItem array, Location locationId, int copyNamespaces) throws XPathException {
        for (Sequence sequence : array.members()) {
            SequenceTool.supply(sequence.iterate(), it -> this.append(it, locationId, copyNamespaces));
        }
    }

    private void decompose(Item item, Location locationId, int copyNamespaces) throws XPathException {
        if (item != null) {
            Genre genre = item.getGenre();
            switch (genre) {
                case ATOMIC: 
                case EXTERNAL: {
                    if (this.previousAtomic) {
                        this.characters(StringConstants.SINGLE_SPACE, locationId, 0);
                    }
                    this.characters(item.getUnicodeStringValue(), locationId, 0);
                    this.previousAtomic = true;
                    break;
                }
                case ARRAY: {
                    this.flatten((ArrayItem)item, locationId, copyNamespaces);
                    break;
                }
                case FUNCTION: 
                case MAP: {
                    String thing = item instanceof MapItem ? "map" : "function item";
                    String errorCode = this.getErrorCodeForDecomposingFunctionItems();
                    if (errorCode.startsWith("SENR")) {
                        throw new XPathException("Cannot serialize a " + thing + " using this output method", errorCode, locationId);
                    }
                    String msg = "Cannot add a " + thing + " (" + Err.depict(item) + ") to an XDM node tree";
                    if (this.pendingStartTag != null) {
                        msg = msg + " (currently writing element " + this.pendingStartTag.getDisplayName() + ")";
                    }
                    throw new XPathException(msg, errorCode, locationId);
                }
                default: {
                    this.decomposeNodeOrDefault(item, locationId, copyNamespaces);
                }
            }
        }
    }

    private void decomposeNodeOrDefault(Item item, Location locationId, int copyNamespaces) throws XPathException {
        NodeInfo node = (NodeInfo)item;
        switch (node.getNodeKind()) {
            case 3: {
                int options = 0;
                if (node instanceof Orphan && ((Orphan)node).isDisableOutputEscaping()) {
                    options = 1;
                }
                this.characters(item.getUnicodeStringValue(), locationId, options);
                break;
            }
            case 2: {
                if (((SimpleType)node.getSchemaType()).isNamespaceSensitive()) {
                    throw new XPathException("Cannot copy attributes whose type is namespace-sensitive (QName or NOTATION): " + Err.wrap(node.getDisplayName(), 2)).withErrorCode(this.getPipelineConfiguration().isXSLT() ? "XTTE0950" : "XQTY0086");
                }
                this.attribute(NameOfNode.makeName(node), (SimpleType)node.getSchemaType(), node.getStringValue(), locationId, 0);
                break;
            }
            case 13: {
                this.namespace(node.getLocalPart(), NamespaceUri.of(node.getStringValue()), 0);
                break;
            }
            case 9: {
                this.startDocument(0);
                for (NodeInfo nodeInfo : node.children()) {
                    this.append(nodeInfo, locationId, copyNamespaces);
                }
                this.endDocument();
                break;
            }
            default: {
                int copyOptions = 4;
                if (ReceiverOption.contains(copyNamespaces, 524288)) {
                    copyOptions |= 2;
                }
                ((NodeInfo)item).copy(this, copyOptions, locationId);
            }
        }
        this.previousAtomic = false;
    }

    private String getErrorCodeForDecomposingFunctionItems() {
        return this.getPipelineConfiguration().isXSLT() ? "XTDE0450" : "XQTY0105";
    }

    private static class UnicodeStringReceiver
    implements UniStringConsumer {
        private final ComplexContentOutputter cco;
        private final boolean previousAtomic;
        private final boolean asTextNode;
        private final Location location;
        private final Consumer<Boolean> resetPreviousAtomic;

        public UnicodeStringReceiver(ComplexContentOutputter cco, boolean previousAtomic, boolean asTextNode, Location loc, Consumer<Boolean> resetPreviousAtomic) {
            this.cco = cco;
            this.previousAtomic = previousAtomic;
            this.asTextNode = asTextNode;
            this.location = loc;
            this.resetPreviousAtomic = resetPreviousAtomic;
        }

        @Override
        public void open() throws XPathException {
            if (this.previousAtomic && !this.asTextNode) {
                this.cco.characters(StringConstants.SINGLE_SPACE, this.location, 0);
            }
        }

        @Override
        public UniStringConsumer accept(UnicodeString chars) throws XPathException {
            this.cco.characters(chars, this.location, 0);
            return this;
        }

        @Override
        public void close() {
            this.resetPreviousAtomic.accept(!this.asTextNode);
        }
    }
}

