/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller;

import java.io.File;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.taskdefs.Execute;
import org.tp23.antinstaller.Installer;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.renderer.AntOutputRenderer;
import org.tp23.antinstaller.renderer.MessageRenderer;
import org.tp23.antinstaller.runtime.Logger;
import org.tp23.antinstaller.runtime.Runner;
import org.tp23.antinstaller.runtime.exe.AntLauncherFilter;

public class InstallerContext {
    public static final String ENV_PREFIX = "env.";
    public static final String JAVA_PREFIX = "java.";
    private Logger logger = null;
    private Installer installer = null;
    private MessageRenderer messageRenderer = null;
    private AntOutputRenderer antOutputRenderer = null;
    private Runner runner = null;
    private Page currentPage = null;
    private File fileRoot = null;
    private BuildListener buildListener = null;
    private AntLauncherFilter antRunner = null;
    private String uIOverride = null;
    private String installerConfigFile = "antinstall-config.xml";
    private String antBuildFile = "build.xml";
    private String configResource;
    private boolean installedSucceded = false;

    public void setInstallSucceded(boolean installedSucceded) {
        this.installedSucceded = installedSucceded;
    }

    public boolean isInstallSucceded() {
        return this.installedSucceded;
    }

    public void log(String message) {
        if (this.logger != null) {
            this.logger.log(message);
        }
    }

    public void log(Throwable message) {
        if (this.logger != null) {
            this.logger.log(message);
        }
    }

    public void log(boolean vebose, Throwable message) {
        if (vebose && this.logger != null) {
            this.logger.log(message);
        }
    }

    public static boolean isUnix() {
        return System.getProperty("os.name").toLowerCase().indexOf("windows") == -1;
    }

    public static Properties getEnvironment() {
        Properties props = new Properties();
        try {
            Vector osEnv = Execute.getProcEnvironment();
            Enumeration e = osEnv.elements();
            while (e.hasMoreElements()) {
                String entry = (String)e.nextElement();
                int pos = entry.indexOf(61);
                if (pos == -1) continue;
                props.put(ENV_PREFIX + entry.substring(0, pos), entry.substring(pos + 1));
            }
        }
        catch (Exception ex) {
            System.out.println("Can't load environment:" + ex.getClass() + "," + ex.getMessage());
        }
        Properties javaSysProps = System.getProperties();
        Iterator<Object> iter = javaSysProps.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            props.put(JAVA_PREFIX + key.toString(), javaSysProps.get(key));
        }
        return props;
    }

    public Installer getInstaller() {
        return this.installer;
    }

    public String getMinJavaVersion() {
        return this.installer.getMinJavaVersion();
    }

    public MessageRenderer getMessageRenderer() {
        return this.messageRenderer;
    }

    public void setMessageRenderer(MessageRenderer messageRenderer) {
        this.messageRenderer = messageRenderer;
        this.messageRenderer.setInstallerContext(this);
    }

    public AntOutputRenderer getAntOutputRenderer() {
        return this.antOutputRenderer;
    }

    public void setAntOutputRenderer(AntOutputRenderer antOutputRenderer) {
        this.antOutputRenderer = antOutputRenderer;
    }

    public Page getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(Page currentPage) {
        this.currentPage = currentPage;
    }

    public File getFileRoot() {
        return this.fileRoot;
    }

    public void setFileRoot(File fileRoot) {
        this.fileRoot = fileRoot;
    }

    public BuildListener getBuildListener() {
        return this.buildListener;
    }

    public void setBuildListener(BuildListener buildListener) {
        this.buildListener = buildListener;
    }

    public AntLauncherFilter getAntRunner() {
        return this.antRunner;
    }

    public void setAntRunner(AntLauncherFilter antRunner) {
        this.antRunner = antRunner;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Runner getRunner() {
        return this.runner;
    }

    public void setRunner(Runner runner) {
        this.runner = runner;
    }

    public void setInstaller(Installer installer) {
        this.installer = installer;
    }

    public String getUIOverride() {
        return this.uIOverride;
    }

    public void setUIOverride(String override) {
        this.uIOverride = override;
    }

    public boolean isAutoBuild() {
        return this.uIOverride != null && this.uIOverride.indexOf("-auto") > -1;
    }

    public String getInstallerConfigFile() {
        return this.installerConfigFile;
    }

    public void setInstallerConfigFile(String installerConfigFile) {
        this.installerConfigFile = installerConfigFile;
    }

    public String getAntBuildFile() {
        return this.antBuildFile;
    }

    public void setAntBuildFile(String antBuildFile) {
        this.antBuildFile = antBuildFile;
    }

    public String getConfigResource() {
        return this.configResource;
    }

    public void setConfigResource(String configResource) {
        this.configResource = configResource;
    }
}

