/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.input;

import java.io.File;
import java.util.ResourceBundle;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.DirectoryInput;
import org.tp23.antinstaller.renderer.MessageRenderer;

public class AppRootInput
extends DirectoryInput {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.Res");
    private String checkFile1;
    private String checkFile2;
    private String checkDir1;
    private String checkDir2;

    public boolean validate(InstallerContext cxt) throws ValidationException {
        if (this.getInputResult() == null) {
            return false;
        }
        MessageRenderer mr = cxt.getMessageRenderer();
        String directorySelected = this.getInputResult();
        File file = new File(directorySelected);
        if (!file.isDirectory()) {
            mr.printMessage(res.getString("dirNotExist") + ":" + file.getAbsolutePath());
            return false;
        }
        if (this.checkFile1 != null && !this.checkExists(mr, file, this.checkFile1)) {
            return false;
        }
        if (this.checkFile2 != null && !this.checkExists(mr, file, this.checkFile2)) {
            return false;
        }
        if (this.checkDir1 != null && !this.checkExists(mr, file, this.checkDir1)) {
            return false;
        }
        return this.checkDir2 == null || this.checkExists(mr, file, this.checkDir2);
    }

    private boolean checkExists(MessageRenderer mr, File root, String check) {
        File checkFile = new File(root, this.checkFile1);
        if (!checkFile.exists()) {
            this.reportMissing(mr, checkFile);
            return false;
        }
        return true;
    }

    private void reportMissing(MessageRenderer mr, File missing) {
        StringBuffer message = new StringBuffer();
        message.append(res.getString("appRootInvalid"));
        message.append(System.getProperty("line.separator"));
        if (missing.isDirectory()) {
            message.append(res.getString("dirNotExist"));
        } else {
            message.append(res.getString("fileNotExist"));
        }
        message.append(":");
        message.append(missing.getAbsolutePath());
        mr.printMessage(message.toString());
    }

    public String getCheckDir1() {
        return this.checkDir1;
    }

    public String getCheckDir2() {
        return this.checkDir2;
    }

    public String getCheckFile1() {
        return this.checkFile1;
    }

    public String getCheckFile2() {
        return this.checkFile2;
    }

    public void setCheckFile2(String checkFile2) {
        this.checkFile2 = checkFile2;
    }

    public void setCheckFile1(String checkFile1) {
        this.checkFile1 = checkFile1;
    }

    public void setCheckDir2(String checkDir2) {
        this.checkDir2 = checkDir2;
    }

    public void setCheckDir1(String checkDir1) {
        this.checkDir1 = checkDir1;
    }

    public boolean validateObject() {
        if (this.getDisplayText() == null) {
            System.out.println("AppRoot:displayText must be set");
            return false;
        }
        if (this.getProperty() == null) {
            System.out.println("AppRoot:property must be set");
            return false;
        }
        if (this.getDefaultValue() == null) {
            System.out.println("AppRoot:defaultValue must be set");
            return false;
        }
        return true;
    }
}

