/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer;

import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.renderer.swing.SwingOutputFieldRenderer;
import org.tp23.antinstaller.renderer.swing.SwingPageRenderer;
import org.tp23.antinstaller.renderer.text.AbstractTextPageRenderer;
import org.tp23.antinstaller.renderer.text.TextOutputFieldRenderer;

public class RendererFactory {
    public static TextOutputFieldRenderer getTextRenderer(OutputField field) throws ClassNotFoundException {
        String fullyQualified = field.getClass().getName();
        int lastDot = fullyQualified.lastIndexOf(46);
        if (lastDot == -1) {
            throw new UnsupportedOperationException("InputField can not be a member of the default package");
        }
        int prevDot = fullyQualified.substring(0, lastDot - 1).lastIndexOf(46, lastDot - 1);
        if (prevDot == -1) {
            throw new UnsupportedOperationException("InputField can not be a member of a single level package");
        }
        StringBuffer rendererClassName = new StringBuffer();
        rendererClassName.append(fullyQualified.substring(0, prevDot));
        rendererClassName.append(".renderer.text.");
        rendererClassName.append(fullyQualified.substring(lastDot + 1));
        rendererClassName.append("Renderer");
        try {
            Class<?> clazz = Class.forName(rendererClassName.toString());
            return (TextOutputFieldRenderer)clazz.newInstance();
        }
        catch (Exception ex) {
            throw new ClassNotFoundException("Class does not meet the contract for TextInputFieldRenderer:" + rendererClassName);
        }
    }

    public static AbstractTextPageRenderer getTextPageRenderer(Page page) throws ClassNotFoundException {
        String fullyQualified = page.getClass().getName();
        int lastDot = fullyQualified.lastIndexOf(46);
        if (lastDot == -1) {
            throw new UnsupportedOperationException("Pages can not be a member of the default package");
        }
        int prevDot = fullyQualified.substring(0, lastDot - 1).lastIndexOf(46, lastDot - 1);
        if (prevDot == -1) {
            throw new UnsupportedOperationException("Pages can not be a member of a single level package");
        }
        StringBuffer rendererClassName = new StringBuffer();
        rendererClassName.append(fullyQualified.substring(0, prevDot));
        rendererClassName.append(".renderer.text.");
        rendererClassName.append(fullyQualified.substring(lastDot + 1));
        rendererClassName.append("Renderer");
        try {
            Class<?> clazz = Class.forName(rendererClassName.toString());
            return (AbstractTextPageRenderer)clazz.newInstance();
        }
        catch (Exception ex) {
            throw new ClassNotFoundException("Class does not meet the contract for TextPageRenderer:" + rendererClassName);
        }
    }

    public static SwingPageRenderer getSwingPageRenderer(Page page) throws ClassNotFoundException {
        String fullyQualified = page.getClass().getName();
        int lastDot = fullyQualified.lastIndexOf(46);
        if (lastDot == -1) {
            throw new UnsupportedOperationException("Pages can not be a member of the default package");
        }
        int prevDot = fullyQualified.substring(0, lastDot - 1).lastIndexOf(46, lastDot - 1);
        if (prevDot == -1) {
            throw new UnsupportedOperationException("Pages can not be a member of a single level package");
        }
        StringBuffer rendererClassName = new StringBuffer();
        rendererClassName.append(fullyQualified.substring(0, prevDot));
        rendererClassName.append(".renderer.swing.");
        rendererClassName.append(fullyQualified.substring(lastDot + 1));
        rendererClassName.append("Renderer");
        try {
            Class<?> clazz = Class.forName(rendererClassName.toString());
            return (SwingPageRenderer)clazz.newInstance();
        }
        catch (Exception ex) {
            throw new ClassNotFoundException("Class does not meet the contract for SwingPageRenderer:" + rendererClassName);
        }
    }

    public static SwingOutputFieldRenderer getSwingRenderer(OutputField field) throws ClassNotFoundException {
        String fullyQualified = field.getClass().getName();
        int lastDot = fullyQualified.lastIndexOf(46);
        if (lastDot == -1) {
            throw new UnsupportedOperationException("OutputField can not be a member of the default package");
        }
        int prevDot = fullyQualified.substring(0, lastDot - 1).lastIndexOf(46, lastDot - 1);
        if (prevDot == -1) {
            throw new UnsupportedOperationException("OutputField can not be a member of a single level package");
        }
        StringBuffer rendererClassName = new StringBuffer();
        rendererClassName.append(fullyQualified.substring(0, prevDot));
        rendererClassName.append(".renderer.swing.");
        rendererClassName.append(fullyQualified.substring(lastDot + 1));
        rendererClassName.append("Renderer");
        try {
            Class<?> clazz = Class.forName(rendererClassName.toString());
            return (SwingOutputFieldRenderer)clazz.newInstance();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ClassNotFoundException("Class does not meet the contract for SwingInputFieldRenderer:" + rendererClassName);
        }
    }
}

