/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import org.tp23.antinstaller.input.DateInput;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.renderer.MessageRenderer;
import org.tp23.antinstaller.renderer.swing.AILabel;
import org.tp23.antinstaller.renderer.swing.AITextfield;
import org.tp23.antinstaller.renderer.swing.SizeConstants;
import org.tp23.antinstaller.renderer.swing.SwingOutputFieldRenderer;
import org.tp23.gui.GBCF;

public class DateInputRenderer
extends SwingOutputFieldRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.Res");
    protected DateInput inputField;
    protected AILabel fieldLabel = new AILabel();
    protected AITextfield jTextField = new AITextfield();
    protected Color origFore = this.jTextField.getForeground();

    public void initComponent(JPanel parent) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOutputField(OutputField inputField) {
        this.inputField = (DateInput)inputField;
        this.inputField.setValue(this.inputField.getDefaultValue());
    }

    public void updateInputField() {
        this.inputField.setValue(this.jTextField.getText());
    }

    public void updateDefaultValue() {
        if (!this.inputField.isEditted()) {
            this.jTextField.setText(this.inputField.getDefaultValue());
        }
    }

    private void jbInit() throws Exception {
        this.fieldLabel.setText(this.inputField.getDisplayText());
        this.jTextField.setText(this.inputField.getDefaultValue());
        this.jTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() != '\t') {
                    DateInputRenderer.this.inputField.setEditted(true);
                }
            }
        });
        this.jTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                DateInputRenderer.this.jTextField.setForeground(DateInputRenderer.this.origFore);
            }
        });
    }

    public int addSelf(JPanel content, GBCF cf, int row, boolean overflow) {
        content.add((Component)this.fieldLabel, cf.getCell(row, 0));
        content.add((Component)this.jTextField, cf.getCell(row, 1));
        if (overflow) {
            this.jTextField.setOverflow(SizeConstants.OVERFLOW_FIELD_SIZE);
        }
        return ++row;
    }

    public void renderError() {
        MessageRenderer mr = this.ctx.getMessageRenderer();
        mr.printMessage(res.getString("notCorrectFormat") + "\n\n " + this.inputField.getDateFormat());
        this.jTextField.requestFocus();
        this.jTextField.setForeground(Color.red);
    }
}

