/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.tp23.antinstaller.input.LargeSelectInput;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.renderer.swing.AILabel;
import org.tp23.antinstaller.renderer.swing.SizeConstants;
import org.tp23.antinstaller.renderer.swing.SwingOutputFieldRenderer;
import org.tp23.gui.GBCF;

public class LargeSelectInputRenderer
extends SwingOutputFieldRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.Res");
    protected LargeSelectInput inputField;
    protected JLabel fieldLabel = new AILabel();
    protected JComboBox optionCombo = new JComboBox();

    public void initComponent(JPanel parent) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOutputField(OutputField inputField) {
        this.inputField = (LargeSelectInput)inputField;
    }

    public void updateInputField() {
        int selectedIdx = this.optionCombo.getSelectedIndex();
        if (selectedIdx != -1) {
            this.inputField.setValue(this.inputField.getOptions()[selectedIdx].value);
        } else {
            this.inputField.setValue(this.inputField.getDefaultValue());
        }
    }

    public void updateDefaultValue() {
        if (!this.inputField.isEditted()) {
            String newDefault = this.inputField.getDefaultValue();
            for (int i = 0; i < this.optionCombo.getItemCount(); ++i) {
                if (!newDefault.equals(this.inputField.getOptions()[i].value)) continue;
                this.optionCombo.setSelectedIndex(i);
                break;
            }
        }
    }

    private void jbInit() throws Exception {
        this.fieldLabel.setText(this.inputField.getDisplayText());
        LargeSelectInput.Option[] options = this.inputField.getOptions();
        for (int i = 0; i < options.length; ++i) {
            this.optionCombo.addItem(options[i].getText());
            if (!options[i].value.equals(this.inputField.getDefaultValue())) continue;
            this.optionCombo.setSelectedIndex(i);
        }
        this.optionCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                LargeSelectInputRenderer.this.inputField.setEditted(true);
            }
        });
    }

    public int addSelf(JPanel content, GBCF cf, int row, boolean overflow) {
        content.add((Component)this.fieldLabel, cf.getCell(row, 0));
        content.add((Component)this.optionCombo, cf.getCell(row, 1));
        if (overflow) {
            this.optionCombo.setPreferredSize(SizeConstants.OVERFLOW_FIELD_SIZE);
        }
        return ++row;
    }

    public void renderError() {
        this.ctx.getMessageRenderer().printMessage(res.getString("notValidSelection"));
        this.optionCombo.requestFocus();
    }
}

