/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.Target;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.renderer.swing.SizeConstants;

public class ProgressPanel
extends JPanel
implements Scrollable {
    public static final int tHeight = 19;
    public static final int leftIndent = 15;
    public static final int DONE = 0;
    public static final int INPROGRESS = 1;
    public static final int TODO = 2;
    private static final Color progressColor = new Color(0, 125, 0);
    private static final Font mainFont = new Font("Dialog", 0, 11);
    private static final Font subFont = new Font("Dialog", 0, 10);
    List targets = null;
    private final InstallerContext ctx;
    private int mainTargetPos = 0;
    private ProgressModel currentPM = null;

    public ProgressPanel(InstallerContext ctx) {
        super(true);
        this.ctx = ctx;
    }

    public synchronized void prepareCalledTargets() {
        Vector targetStrings = this.ctx.getInstaller().getTargets(this.ctx);
        Iterator iter = targetStrings.iterator();
        this.targets = new ArrayList();
        while (iter.hasNext()) {
            String tgt = (String)iter.next();
            this.targets.add(new ProgressModel(tgt));
        }
        this.setSize(this.getSize());
        this.revalidate();
        this.repaint();
    }

    public synchronized void targetStarted(BuildEvent buildEvent) {
        try {
            Target tgt = buildEvent.getTarget();
            ProgressModel pm = (ProgressModel)this.targets.get(this.mainTargetPos);
            pm.state = 1;
            if (tgt.getName().equals(pm.name)) {
                this.currentPM = pm;
                ++this.mainTargetPos;
                this.revalidate();
                this.repaint();
            } else {
                ProgressModel dependency = new ProgressModel(tgt.getName());
                dependency.state = 1;
                if (this.currentPM != null) {
                    this.currentPM.state = 0;
                }
                this.currentPM = dependency;
                pm.subTargets.add(dependency);
                this.setSize(this.getSize());
                this.revalidate();
                this.repaint();
            }
        }
        catch (Exception e) {
            this.ctx.log(e);
        }
    }

    public synchronized void targetFinished() {
        this.currentPM.state = 0;
    }

    public synchronized void buildFinished() {
        this.setToDone(this.targets);
        this.repaint();
    }

    private void setToDone(List pModels) {
        if (pModels == null || pModels.size() == 0) {
            return;
        }
        Iterator iter = pModels.iterator();
        while (iter.hasNext()) {
            ProgressModel pm = (ProgressModel)iter.next();
            pm.state = 0;
            this.setToDone(pm.subTargets);
        }
    }

    public synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.targets == null) {
            return;
        }
        Iterator iter = this.targets.iterator();
        int offset = 0;
        int i = 1;
        while (iter.hasNext()) {
            ProgressModel pmodel = (ProgressModel)iter.next();
            this.drawTarget(pmodel, (Graphics2D)g, offset, i < this.targets.size(), i > 1);
            offset += 19;
            offset += pmodel.subTargets.size() * 19;
            ++i;
        }
    }

    public synchronized Dimension getPreferredSize() {
        return this.getSize();
    }

    public synchronized Dimension getSize() {
        if (this.targets == null) {
            return new Dimension(SizeConstants.PAGE_WIDTH, 95);
        }
        int count = this.targets.size();
        Iterator iter = this.targets.iterator();
        while (iter.hasNext()) {
            ProgressModel pmodel = (ProgressModel)iter.next();
            count += pmodel.subTargets.size();
        }
        return new Dimension(SizeConstants.PAGE_WIDTH, count * 19);
    }

    private void drawTarget(ProgressModel target, Graphics2D g, int yOffset, boolean hasMore, boolean hasPrev) {
        g.setFont(mainFont);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.gray);
        if (hasPrev) {
            g.drawLine(23, yOffset, 23, yOffset + 8);
        }
        if (hasMore || target.subTargets.size() > 0) {
            g.drawLine(23, 9 + yOffset, 23, 19 + yOffset);
        }
        int xOffset = 0;
        g.drawLine(23, 8 + yOffset, 15 + xOffset + 20, 8 + yOffset);
        if (target.state == 0) {
            g.setColor(Color.darkGray);
        }
        if (target.state == 1) {
            g.setColor(progressColor);
        }
        if (target.state == 2) {
            g.setColor(Color.gray);
        }
        g.fillRoundRect(15 + xOffset + 3, yOffset + 4, 11, 9, 7, 7);
        g.setColor(Color.black);
        g.drawString(target.name, 15 + xOffset + 22, 13 + yOffset);
        if (target.subTargets.size() > 0) {
            Iterator iter = target.subTargets.iterator();
            int i = 1;
            while (iter.hasNext()) {
                this.drawSubTarget((ProgressModel)iter.next(), g, yOffset += 19, hasMore | i < target.subTargets.size());
                ++i;
            }
        }
    }

    private void drawSubTarget(ProgressModel target, Graphics2D g, int yOffset, boolean hasMore) {
        g.setFont(subFont);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.gray);
        g.drawLine(23, yOffset, 23, yOffset + 8);
        if (hasMore) {
            g.drawLine(23, 9 + yOffset, 23, 19 + yOffset);
        }
        int xOffset = 15;
        g.drawLine(23, 8 + yOffset, 15 + xOffset + 4, 8 + yOffset);
        if (target.state == 0) {
            g.setColor(Color.darkGray);
        }
        if (target.state == 1) {
            g.setColor(progressColor);
        }
        if (target.state == 2) {
            g.setColor(Color.gray);
        }
        g.fillRoundRect(15 + xOffset + 4, yOffset + 5, 9, 7, 7, 7);
        g.setColor(Color.black);
        g.drawString(target.name, 15 + xOffset + 15, 12 + yOffset);
    }

    public synchronized Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public synchronized int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 19;
    }

    public synchronized int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 57;
    }

    public synchronized boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public synchronized boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public static class ProgressModel {
        int state = 2;
        String name;
        List subTargets = new ArrayList();

        public ProgressModel(String name) {
            this.name = name;
        }

        int getHeight() {
            return 19 + this.subTargets.size() * 19;
        }
    }
}

