/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import org.tp23.antinstaller.input.InputField;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.input.TargetInput;
import org.tp23.antinstaller.renderer.swing.AICheckBox;
import org.tp23.antinstaller.renderer.swing.AILabel;
import org.tp23.antinstaller.renderer.swing.SizeConstants;
import org.tp23.antinstaller.renderer.swing.SwingOutputFieldRenderer;
import org.tp23.gui.GBCF;

public class TargetInputRenderer
extends SwingOutputFieldRenderer {
    protected TargetInput outputField;
    protected AILabel fieldLabel = new AILabel();
    protected AICheckBox targetCheckBox = new AICheckBox();

    public void initComponent(JPanel parent) {
        block2: {
            try {
                this.jbInit();
            }
            catch (Exception e) {
                this.ctx.log(e.getMessage());
                if (!this.ctx.getInstaller().isVerbose()) break block2;
                this.ctx.log(e);
            }
        }
    }

    public void setOutputField(OutputField outputField) {
        this.outputField = (TargetInput)outputField;
    }

    public void updateInputField() {
        String target = this.outputField.getTarget();
        int targetIdx = this.outputField.getIdx();
        boolean selected = this.targetCheckBox.isSelected();
        this.outputField.setInputResult(String.valueOf(selected));
        if (selected && !this.ctx.getCurrentPage().getAllTargets().contains(target)) {
            this.ctx.getCurrentPage().addTarget(targetIdx, target);
        } else if (!selected && this.ctx.getCurrentPage().isTarget(target)) {
            this.ctx.getCurrentPage().removeTarget(targetIdx);
        }
    }

    public void updateDefaultValue() {
        if (!this.outputField.isEditted()) {
            this.targetCheckBox.setSelected(InputField.isTrue(this.outputField.getDefaultValue()));
        }
    }

    private void jbInit() throws Exception {
        this.fieldLabel.setText(this.outputField.getDisplayText());
        this.targetCheckBox.setSelected(InputField.isTrue(this.outputField.getDefaultValue()));
        if (InputField.isTrue(this.outputField.getForce())) {
            this.targetCheckBox.setEnabled(false);
        }
        this.targetCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TargetInputRenderer.this.updateInputField();
                TargetInputRenderer.this.outputField.setEditted(true);
            }
        });
    }

    public int addSelf(JPanel content, GBCF cf, int row, boolean overflow) {
        content.add((Component)this.fieldLabel, cf.getCell(row, 0));
        content.add((Component)this.targetCheckBox, cf.getCell(row, 1));
        if (overflow) {
            this.targetCheckBox.setOverflow(SizeConstants.OVERFLOW_FIELD_SIZE);
        }
        return ++row;
    }

    public void renderError() {
    }
}

