/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.input.ValidatedTextInput;
import org.tp23.antinstaller.renderer.MessageRenderer;
import org.tp23.antinstaller.renderer.swing.AILabel;
import org.tp23.antinstaller.renderer.swing.AITextfield;
import org.tp23.antinstaller.renderer.swing.SizeConstants;
import org.tp23.antinstaller.renderer.swing.SwingOutputFieldRenderer;
import org.tp23.gui.GBCF;

public class ValidatedTextInputRenderer
extends SwingOutputFieldRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.Res");
    protected ValidatedTextInput inputField;
    protected AILabel fieldLabel = new AILabel();
    protected JTextField jTextField = new AITextfield();
    protected Color origFore = this.jTextField.getForeground();

    public void initComponent(JPanel parent) {
        block2: {
            try {
                this.jbInit();
            }
            catch (Exception e) {
                this.ctx.log(e.getMessage());
                if (!this.ctx.getInstaller().isVerbose()) break block2;
                this.ctx.log(e);
            }
        }
    }

    public void setOutputField(OutputField inputField) {
        this.inputField = (ValidatedTextInput)inputField;
        this.inputField.setValue(this.inputField.getDefaultValue());
    }

    public void updateInputField() {
        this.inputField.setValue(this.jTextField.getText());
    }

    public void updateDefaultValue() {
        if (!this.inputField.isEditted()) {
            this.jTextField.setText(this.inputField.getDefaultValue());
        }
    }

    private void jbInit() throws Exception {
        this.fieldLabel.setText(this.inputField.getDisplayText());
        this.jTextField.setText(this.inputField.getDefaultValue());
        this.jTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                ValidatedTextInputRenderer.this.jTextField.setForeground(ValidatedTextInputRenderer.this.origFore);
            }
        });
        this.jTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() != '\t') {
                    ValidatedTextInputRenderer.this.inputField.setEditted(true);
                }
            }
        });
    }

    public int addSelf(JPanel content, GBCF cf, int row, boolean overflow) {
        content.add((Component)this.fieldLabel, cf.getCell(row, 0));
        content.add((Component)this.jTextField, cf.getCell(row, 1));
        if (overflow) {
            ((AITextfield)this.jTextField).setOverflow(SizeConstants.OVERFLOW_FIELD_SIZE);
        }
        return ++row;
    }

    public void renderError() {
        MessageRenderer mr = this.ctx.getMessageRenderer();
        mr.printMessage(res.getString("notCorrectFormat") + "\n\n e.g. " + this.inputField.getDefaultValue());
        this.jTextField.requestFocus();
        this.jTextField.setForeground(Color.red);
    }
}

