/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.page.SimpleInputPage;
import org.tp23.antinstaller.renderer.RendererFactory;
import org.tp23.antinstaller.renderer.text.AbstractTextPageRenderer;
import org.tp23.antinstaller.renderer.text.TextOutputFieldRenderer;

public class SimpleInputPageRenderer
extends AbstractTextPageRenderer {
    public boolean renderPage(Page page) throws InstallException {
        if (page instanceof SimpleInputPage) {
            try {
                return this.renderSimpleInputPage((SimpleInputPage)page);
            }
            catch (ClassNotFoundException ex) {
                throw new InstallException("Cant find acceptable TextField renderer in SimpleInputPageRenderer.renderPage:" + ex.getMessage(), ex);
            }
        }
        throw new InstallException("Wrong Renderer in SimpleInputPageRenderer.renderPage");
    }

    private boolean renderSimpleInputPage(SimpleInputPage page) throws InstallException, ClassNotFoundException, ValidationException {
        try {
            this.printHeader(page);
            OutputField[] fields = page.getOutputField();
            return SimpleInputPageRenderer.renderFields(this.getContext(), fields, this.reader, this.out);
        }
        catch (IOException ex) {
            throw new InstallException("IOException", ex);
        }
    }

    public static boolean renderFields(InstallerContext context, OutputField[] fields, BufferedReader reader, PrintStream out) throws ClassNotFoundException, IOException, ValidationException, InstallException {
        for (int f = 0; f < fields.length; ++f) {
            String text = fields[f].getExplanatoryText();
            if (text != null) {
                out.println(text);
                out.println();
            }
            TextOutputFieldRenderer frenderer = RendererFactory.getTextRenderer(fields[f]);
            frenderer.setContext(context);
            frenderer.renderOutput(fields[f], reader, out);
            if (frenderer.isAbort()) {
                return false;
            }
            while (!fields[f].validate(context)) {
                frenderer.renderError(fields[f], reader, out);
            }
        }
        return true;
    }
}

