/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime.exe;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.Installer;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.AppRootInput;
import org.tp23.antinstaller.input.CheckboxInput;
import org.tp23.antinstaller.input.CommentOutput;
import org.tp23.antinstaller.input.ConditionalField;
import org.tp23.antinstaller.input.ConfirmPasswordTextInput;
import org.tp23.antinstaller.input.DateInput;
import org.tp23.antinstaller.input.DirectoryInput;
import org.tp23.antinstaller.input.ExtValidatedTextInput;
import org.tp23.antinstaller.input.FileInput;
import org.tp23.antinstaller.input.HiddenPropertyInput;
import org.tp23.antinstaller.input.InputField;
import org.tp23.antinstaller.input.LargeSelectInput;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.input.PasswordTextInput;
import org.tp23.antinstaller.input.SelectInput;
import org.tp23.antinstaller.input.TargetInput;
import org.tp23.antinstaller.input.TargetSelectInput;
import org.tp23.antinstaller.input.UnvalidatedTextInput;
import org.tp23.antinstaller.input.ValidatedTextInput;
import org.tp23.antinstaller.page.LicensePage;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.page.ProgressPage;
import org.tp23.antinstaller.page.SimpleInputPage;
import org.tp23.antinstaller.page.SplashPage;
import org.tp23.antinstaller.page.TextPage;
import org.tp23.antinstaller.runtime.ConfigurationException;
import org.tp23.antinstaller.runtime.exe.ExecuteFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class LoadConfigFilter
implements ExecuteFilter {
    public static final String INSTALLER_CONFIG_FILE = "antinstall-config.xml";
    protected Installer installer = new Installer();
    protected InstallerContext ctx;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;

    public void exec(InstallerContext ctx) throws InstallException {
        this.ctx = ctx;
        try {
            this.installer = this.readConfig(ctx.getFileRoot(), ctx.getInstallerConfigFile());
            ctx.setInstaller(this.installer);
            ctx.log("Config loaded");
        }
        catch (IOException e) {
            throw new InstallException("Not able to load and read the AntInstaller config", e);
        }
        catch (ConfigurationException e) {
            throw new InstallException("Not able to load and read the AntInstaller config", e);
        }
    }

    public Installer readConfig(File fileRoot, String fileName) throws IOException, ConfigurationException {
        this.installer.getResultContainer().setInstallRoot(fileRoot);
        File config = new File(fileRoot, fileName);
        if (!config.exists()) {
            throw new IOException();
        }
        InputSource xmlInp = new InputSource(new FileInputStream(config));
        this.readConfig(xmlInp);
        return this.installer;
    }

    protected Installer readConfig(File fileRoot, InputStream configSource) throws IOException, ConfigurationException {
        this.installer.getResultContainer().setInstallRoot(fileRoot);
        InputSource xmlInp = new InputSource(configSource);
        this.readConfig(xmlInp);
        return this.installer;
    }

    protected Installer readConfig(InputSource xmlInp) throws IOException, ConfigurationException {
        Document doc = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = docBuilderFactory.newDocumentBuilder();
            String entityResolverClass = System.getProperty("antinstaller.EntityResolverClass");
            EntityResolver er = null;
            if (entityResolverClass != null) {
                try {
                    er = (EntityResolver)Class.forName(entityResolverClass).newInstance();
                }
                catch (Exception e) {
                    er = new CustomEntityResolver();
                }
            } else {
                er = new CustomEntityResolver();
            }
            parser.setEntityResolver(er);
            doc = parser.parse(xmlInp);
            Element root = doc.getDocumentElement();
            root.normalize();
            this.setProperties(this.installer, root.getAttributes());
            NodeList allPages = root.getElementsByTagName("page");
            this.getPages(this.installer, allPages);
        }
        catch (Exception e) {
            throw new IOException("DomFactory error: caused by:" + e.getClass() + ":" + e.getMessage());
        }
        return this.installer;
    }

    private void getPages(Installer installerConfig, NodeList allPages) throws ConfigurationException {
        ArrayList<Page> pages = new ArrayList<Page>();
        for (int i = 0; i < allPages.getLength(); ++i) {
            Element pageElem = (Element)allPages.item(i);
            Page page = this.getPageType(pageElem.getAttribute("type"));
            this.setProperties(page, pageElem.getAttributes());
            pages.add(page);
            this.getOutputFields(page, pageElem);
        }
        Page[] pageArr = new Page[pages.size()];
        pages.toArray(pageArr);
        installerConfig.setPages(pageArr);
    }

    private void getOutputFields(Page page, Element pageElem) throws ConfigurationException {
        page.setOutputField(this.getInnerOutputFields(pageElem));
    }

    private OutputField[] getInnerOutputFields(Element elem) throws ConfigurationException {
        NodeList allFields = elem.getChildNodes();
        ArrayList<OutputField> fields = new ArrayList<OutputField>();
        for (int i = 0; i < allFields.getLength(); ++i) {
            Element fieldElem;
            OutputField field;
            if (!(allFields.item(i) instanceof Element) || (field = this.getOutputFieldType((fieldElem = (Element)allFields.item(i)).getNodeName(), fieldElem)) == null) continue;
            this.setProperties(field, fieldElem.getAttributes());
            fields.add(field);
            field.setResultContainer(this.installer.getResultContainer());
        }
        OutputField[] fieldArr = new OutputField[fields.size()];
        return fields.toArray(fieldArr);
    }

    private Page getPageType(String type) throws ConfigurationException {
        if (type.equalsIgnoreCase("license")) {
            return new LicensePage();
        }
        if (type.equalsIgnoreCase("input")) {
            return new SimpleInputPage();
        }
        if (type.equalsIgnoreCase("progress")) {
            return new ProgressPage();
        }
        if (type.equalsIgnoreCase("splash")) {
            return new SplashPage();
        }
        if (type.equalsIgnoreCase("text")) {
            return new TextPage();
        }
        throw new ConfigurationException("Unknown Page type:" + type);
    }

    private OutputField getOutputFieldType(String type, Element field) throws ConfigurationException {
        if (type.equalsIgnoreCase("text")) {
            return new UnvalidatedTextInput();
        }
        if (type.equalsIgnoreCase("directory")) {
            return new DirectoryInput();
        }
        if (type.equalsIgnoreCase("target")) {
            return new TargetInput();
        }
        if (type.equalsIgnoreCase("file")) {
            return new FileInput();
        }
        if (type.equalsIgnoreCase("comment")) {
            return new CommentOutput();
        }
        if (type.equalsIgnoreCase("checkbox")) {
            return new CheckboxInput();
        }
        if (type.equalsIgnoreCase("validated")) {
            return new ValidatedTextInput();
        }
        if (type.equalsIgnoreCase("ext-validated")) {
            return new ExtValidatedTextInput();
        }
        if (type.equalsIgnoreCase("password")) {
            return new PasswordTextInput();
        }
        if (type.equalsIgnoreCase("password-confirm")) {
            return new ConfirmPasswordTextInput();
        }
        if (type.equalsIgnoreCase("hidden")) {
            return new HiddenPropertyInput();
        }
        if (type.equalsIgnoreCase("date")) {
            return new DateInput();
        }
        if (type.equalsIgnoreCase("app-root")) {
            return new AppRootInput();
        }
        if (type.equalsIgnoreCase("conditional")) {
            ConditionalField conditionalField = new ConditionalField();
            OutputField[] outFields = this.getInnerOutputFields(field);
            InputField[] inFields = new InputField[outFields.length];
            for (int i = 0; i < outFields.length; ++i) {
                inFields[i] = (InputField)outFields[i];
            }
            conditionalField.setFields(inFields);
            return conditionalField;
        }
        if (type.equalsIgnoreCase("select")) {
            SelectInput sInput = new SelectInput();
            NodeList allOptions = field.getElementsByTagName("option");
            ArrayList<SelectInput.Option> options = new ArrayList<SelectInput.Option>();
            for (int i = 0; i < allOptions.getLength(); ++i) {
                Element optionElem = (Element)allOptions.item(i);
                SelectInput.Option option = sInput.getNewOption();
                option.setText(optionElem.getAttribute("text"));
                option.value = optionElem.getAttribute("value");
                options.add(option);
            }
            SelectInput.Option[] optionArr = new SelectInput.Option[options.size()];
            options.toArray(optionArr);
            sInput.setOptions(optionArr);
            return sInput;
        }
        if (type.equalsIgnoreCase("target-select")) {
            TargetSelectInput sInput = new TargetSelectInput();
            NodeList allOptions = field.getElementsByTagName("option");
            ArrayList<SelectInput.Option> options = new ArrayList<SelectInput.Option>();
            for (int i = 0; i < allOptions.getLength(); ++i) {
                Element optionElem = (Element)allOptions.item(i);
                SelectInput.Option option = sInput.getNewOption();
                option.setText(optionElem.getAttribute("text"));
                option.value = optionElem.getAttribute("value");
                options.add(option);
            }
            SelectInput.Option[] optionArr = new SelectInput.Option[options.size()];
            options.toArray(optionArr);
            sInput.setOptions(optionArr);
            return sInput;
        }
        if (type.equalsIgnoreCase("large-select")) {
            LargeSelectInput sInput = new LargeSelectInput();
            NodeList allOptions = field.getElementsByTagName("option");
            ArrayList<LargeSelectInput.Option> options = new ArrayList<LargeSelectInput.Option>();
            for (int i = 0; i < allOptions.getLength(); ++i) {
                Element optionElem = (Element)allOptions.item(i);
                LargeSelectInput.Option option = sInput.getNewOption();
                option.setText(optionElem.getAttribute("text"));
                option.value = optionElem.getAttribute("value");
                options.add(option);
            }
            LargeSelectInput.Option[] optionArr = new LargeSelectInput.Option[options.size()];
            options.toArray(optionArr);
            sInput.setOptions(optionArr);
            return sInput;
        }
        System.out.println("Unrecognised Input Element:" + type);
        return null;
    }

    private void setProperties(Object bean, NamedNodeMap map) {
        int numAtts = map.getLength();
        for (int a = 0; a < numAtts; ++a) {
            Node attribute = map.item(a);
            String name = attribute.getNodeName();
            String value = attribute.getNodeValue();
            String methodName = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            Method[] allMethods = bean.getClass().getMethods();
            for (int m = 0; m < allMethods.length; ++m) {
                if (!allMethods[m].getName().equals(methodName)) continue;
                try {
                    Object[] paramValues;
                    Class<?>[] parameters = allMethods[m].getParameterTypes();
                    if (parameters[0].equals(class$java$lang$Boolean == null ? LoadConfigFilter.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                        paramValues = new Boolean[1];
                        paramValues[0] = OutputField.isTrue(value) ? Boolean.TRUE : Boolean.FALSE;
                    } else {
                        paramValues = parameters[0].equals(class$java$lang$Integer == null ? LoadConfigFilter.class$("java.lang.Integer") : class$java$lang$Integer) ? new Integer[]{new Integer(value)} : new String[]{value};
                    }
                    allMethods[m].invoke(bean, paramValues);
                    continue;
                }
                catch (IndexOutOfBoundsException ex) {
                    continue;
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                catch (IllegalAccessException e) {
                    continue;
                }
                catch (InvocationTargetException e) {
                    // empty catch block
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CustomEntityResolver
    implements EntityResolver {
        private CustomEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            if (publicId.equals("-//tp23 //DTD Ant Installer Config//EN") && systemId.equals("http://antinstaller.sf.net/dtd/antinstall-config-0.2.dtd")) {
                InputSource localSrc = new InputSource(this.getClass().getResourceAsStream("/org/tp23/antinstaller/antinstall-config-0.2.dtd"));
                return localSrc;
            }
            if (publicId.equals("-//tp23 //DTD Ant Installer Config//EN") && systemId.equals("http://antinstaller.sf.net/dtd/antinstall-config-0.3.dtd")) {
                InputSource localSrc = new InputSource(this.getClass().getResourceAsStream("/org/tp23/antinstaller/antinstall-config-0.3.dtd"));
                return localSrc;
            }
            if (publicId.equals("-//tp23 //DTD Ant Installer Config//EN") && systemId.equals("http://antinstaller.sf.net/dtd/antinstall-config-0.4.dtd")) {
                InputSource localSrc = new InputSource(this.getClass().getResourceAsStream("/org/tp23/antinstaller/antinstall-config-0.4.dtd"));
                return localSrc;
            }
            if (publicId.equals("-//tp23 //DTD Ant Installer Config//EN") && systemId.equals("http://antinstaller.sf.net/dtd/antinstall-config-0.5.dtd")) {
                InputSource localSrc = new InputSource(this.getClass().getResourceAsStream("/org/tp23/antinstaller/antinstall-config-0.5.dtd"));
                return localSrc;
            }
            if (publicId.equals("-//tp23 //DTD Ant Installer Config//EN") && systemId.equals("http://antinstaller.sf.net/dtd/antinstall-config-0.6.dtd")) {
                InputSource localSrc = new InputSource(this.getClass().getResourceAsStream("/org/tp23/antinstaller/antinstall-config-0.6.dtd"));
                return localSrc;
            }
            if (publicId.equals("-//tp23 //DTD Ant Installer Config//EN") && systemId.equals("http://antinstaller.sf.net/dtd/antinstall-config-0.7.dtd")) {
                InputSource localSrc = new InputSource(this.getClass().getResourceAsStream("/org/tp23/antinstaller/antinstall-config-0.7.dtd"));
                return localSrc;
            }
            if (publicId.equals("-//tp23 //DTD Ant Installer Config//EN") && systemId.equals("http://antinstaller.sf.net/dtd/antinstall-config-0.8.dtd")) {
                InputSource localSrc = new InputSource(this.getClass().getResourceAsStream("/org/tp23/antinstaller/antinstall-config-0.8.dtd"));
                return localSrc;
            }
            return null;
        }
    }
}

