/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.xml.namespace.QName;
import org.apache.pluto.container.om.portlet.ContainerRuntimeOption;
import org.apache.pluto.container.om.portlet.EventDefinitionReference;
import org.apache.pluto.container.om.portlet.InitParam;
import org.apache.pluto.container.om.portlet.PortletDefinition;

public abstract class AbstractPortletConfigImpl
implements PortletConfig {
    protected PortletContext portletContext;
    protected PortletDefinition portlet;
    protected Map<String, String[]> containerRuntimeOptions;
    protected Set<String> supportedContainerRuntimeOptions;

    public AbstractPortletConfigImpl(PortletContext portletContext, PortletDefinition portlet) {
        this.portletContext = portletContext;
        this.portlet = portlet;
        this.supportedContainerRuntimeOptions = new HashSet<String>();
        Enumeration e = portletContext.getContainerRuntimeOptions();
        while (e.hasMoreElements()) {
            this.supportedContainerRuntimeOptions.add((String)e.nextElement());
        }
    }

    public abstract ResourceBundle getResourceBundle(Locale var1);

    public String getPortletName() {
        return this.portlet.getPortletName();
    }

    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    public String getInitParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name == null");
        }
        for (InitParam param : this.portlet.getInitParams()) {
            if (!param.getParamName().equals(name)) continue;
            return param.getParamValue();
        }
        return null;
    }

    public Enumeration<String> getInitParameterNames() {
        return new Enumeration<String>(){
            private Iterator<InitParam> iterator;
            {
                this.iterator = new ArrayList(AbstractPortletConfigImpl.this.portlet.getInitParams()).iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            @Override
            public String nextElement() {
                if (this.iterator.hasNext()) {
                    return this.iterator.next().getParamName();
                }
                return null;
            }
        };
    }

    public PortletDefinition getPortletDefinition() {
        return this.portlet;
    }

    public Enumeration<String> getPublicRenderParameterNames() {
        if (this.portlet.getSupportedPublicRenderParameters() != null) {
            return Collections.enumeration(this.portlet.getSupportedPublicRenderParameters());
        }
        return Collections.enumeration(new ArrayList());
    }

    public String getDefaultNamespace() {
        if (this.portlet.getApplication().getDefaultNamespace() == null) {
            return "";
        }
        return this.portlet.getApplication().getDefaultNamespace();
    }

    public Enumeration<QName> getProcessingEventQNames() {
        ArrayList<QName> qnameList = new ArrayList<QName>();
        for (EventDefinitionReference ref : this.portlet.getSupportedProcessingEvents()) {
            QName name = ref.getQualifiedName();
            if (name == null) continue;
            qnameList.add(name);
        }
        return Collections.enumeration(qnameList);
    }

    public Enumeration<QName> getPublishingEventQNames() {
        ArrayList<QName> qnameList = new ArrayList<QName>();
        for (EventDefinitionReference ref : this.portlet.getSupportedPublishingEvents()) {
            QName name = ref.getQualifiedName();
            if (name == null) continue;
            qnameList.add(name);
        }
        return Collections.enumeration(qnameList);
    }

    public Enumeration<Locale> getSupportedLocales() {
        ArrayList<Locale> locals = new ArrayList<Locale>();
        List languageIds = this.portlet.getSupportedLocales();
        if (languageIds != null) {
            for (String languageId : languageIds) {
                locals.add(this.getLocale(languageId));
            }
        }
        return Collections.enumeration(locals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String[]> getContainerRuntimeOptions() {
        AbstractPortletConfigImpl abstractPortletConfigImpl = this;
        synchronized (abstractPortletConfigImpl) {
            if (this.containerRuntimeOptions == null) {
                int i;
                String[] tempValues;
                List values;
                this.containerRuntimeOptions = new HashMap<String, String[]>();
                for (ContainerRuntimeOption containerRuntimeOption : this.portlet.getApplication().getContainerRuntimeOptions()) {
                    values = containerRuntimeOption.getValues();
                    tempValues = new String[values.size()];
                    for (i = 0; i < values.size(); ++i) {
                        tempValues[i] = (String)values.get(i);
                    }
                    this.containerRuntimeOptions.put(containerRuntimeOption.getName(), tempValues);
                }
                for (ContainerRuntimeOption containerRuntimeOption : this.portlet.getContainerRuntimeOptions()) {
                    values = containerRuntimeOption.getValues();
                    tempValues = new String[values.size()];
                    for (i = 0; i < values.size(); ++i) {
                        tempValues[i] = (String)values.get(i);
                    }
                    this.containerRuntimeOptions.put(containerRuntimeOption.getName(), tempValues);
                }
                Iterator<String> iter = this.containerRuntimeOptions.keySet().iterator();
                while (iter.hasNext()) {
                    String string = iter.next();
                    if (this.supportedContainerRuntimeOptions.contains(string)) continue;
                    iter.remove();
                }
            }
        }
        if (!this.containerRuntimeOptions.isEmpty()) {
            HashMap result = new HashMap(this.containerRuntimeOptions.size());
            for (Map.Entry entry : this.containerRuntimeOptions.entrySet()) {
                if (entry.getValue() == null) continue;
                result.put(entry.getKey(), ((String[])entry.getValue()).clone());
            }
            return Collections.unmodifiableMap(result);
        }
        return Collections.emptyMap();
    }

    private Locale getLocale(String languageId) {
        Locale locale;
        int pos = languageId.indexOf("_");
        if (pos == -1) {
            locale = Locale.forLanguageTag(languageId);
        } else {
            String[] languageIdParts = languageId.split("_");
            String languageCode = languageIdParts[0];
            String countryCode = languageIdParts[1];
            String variant = null;
            if (languageIdParts.length > 2) {
                variant = languageIdParts[2];
            }
            locale = variant != null && variant.trim().length() > 0 ? new Locale(languageCode, countryCode, variant) : new Locale(languageCode, countryCode);
        }
        return locale;
    }
}

