/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.metadata.cache;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.interceptor.InterceptorBinding;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotation;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.MetadataLogger;
import org.jboss.weld.logging.ReflectionLogger;
import org.jboss.weld.metadata.cache.AbstractBindingModel;
import org.jboss.weld.security.SetAccessibleAction;
import org.jboss.weld.util.collections.Arrays2;
import org.jboss.weld.util.reflection.Reflections;

public class InterceptorBindingModel<T extends Annotation>
extends AbstractBindingModel<T> {
    private static final Set<Class<? extends Annotation>> META_ANNOTATIONS = Collections.singleton(InterceptorBinding.class);
    private Set<Annotation> inheritedInterceptionBindingTypes;
    private Set<Annotation> metaAnnotations;

    public InterceptorBindingModel(EnhancedAnnotation<T> enhancedAnnotatedAnnotation) {
        super(enhancedAnnotatedAnnotation);
    }

    @Override
    protected void init(EnhancedAnnotation<T> annotatedAnnotation) {
        super.init(annotatedAnnotation);
        if (this.isValid()) {
            this.initInterceptionBindingTypes(annotatedAnnotation);
            this.checkArrayAndAnnotationValuedMembers(annotatedAnnotation);
            this.checkMetaAnnotations(annotatedAnnotation);
            this.metaAnnotations = annotatedAnnotation.getAnnotations();
        }
    }

    @Override
    protected Set<Class<? extends Annotation>> getMetaAnnotationTypes() {
        return META_ANNOTATIONS;
    }

    public Set<Annotation> getMetaAnnotations() {
        return this.metaAnnotations;
    }

    protected void initInterceptionBindingTypes(EnhancedAnnotation<T> annotatedAnnotation) {
        this.inheritedInterceptionBindingTypes = annotatedAnnotation.getMetaAnnotations(InterceptorBinding.class);
    }

    @Override
    protected void check(EnhancedAnnotation<T> annotatedAnnotation) {
        super.check(annotatedAnnotation);
        if (this.isValid()) {
            if (!annotatedAnnotation.isAnnotationPresent(Target.class)) {
                ReflectionLogger.LOG.missingTarget(annotatedAnnotation);
            }
            if (!InterceptorBindingModel.isValidTargetType(annotatedAnnotation)) {
                ReflectionLogger.LOG.missingTargetTypeMethodOrTargetType(annotatedAnnotation);
            }
        }
    }

    private static boolean isValidTargetType(EnhancedAnnotation<?> annotation) {
        Target target = annotation.getAnnotation(Target.class);
        return target != null && (Arrays2.unorderedEquals((Object[])target.value(), new Object[]{ElementType.TYPE, ElementType.METHOD}) || Arrays2.unorderedEquals((Object[])target.value(), new Object[]{ElementType.TYPE}));
    }

    private void checkMetaAnnotations(EnhancedAnnotation<T> annotatedAnnotation) {
        ElementType[] elementTypes = this.getTargetElementTypes(annotatedAnnotation.getAnnotation(Target.class));
        for (Annotation inheritedBinding : this.getInheritedInterceptionBindingTypes()) {
            ElementType[] metaAnnotationElementTypes = this.getTargetElementTypes(inheritedBinding.annotationType().getAnnotation(Target.class));
            if (Arrays2.containsAll((Object[])metaAnnotationElementTypes, (Object[])elementTypes)) continue;
            ReflectionLogger.LOG.invalidInterceptorBindingTargetDeclaration(inheritedBinding.annotationType().getName(), Arrays.toString((Object[])metaAnnotationElementTypes), annotatedAnnotation.getJavaClass().getName(), Arrays.toString((Object[])elementTypes));
        }
    }

    private ElementType[] getTargetElementTypes(Target target) {
        if (target == null) {
            return ElementType.values();
        }
        return target.value();
    }

    private void checkArrayAndAnnotationValuedMembers(EnhancedAnnotation<T> annotatedAnnotation) {
        for (EnhancedAnnotatedMethod<?, ?> annotatedMethod : annotatedAnnotation.getMembers()) {
            if (!Reflections.isArrayType(annotatedMethod.getJavaClass()) && !Annotation.class.isAssignableFrom(annotatedMethod.getJavaClass()) || this.getNonBindingMembers().contains(annotatedMethod.slim())) continue;
            throw MetadataLogger.LOG.nonBindingMemberTypeException(annotatedMethod);
        }
    }

    public Set<Annotation> getInheritedInterceptionBindingTypes() {
        return this.inheritedInterceptionBindingTypes;
    }

    public boolean isEqual(Annotation instance, Annotation other) {
        return this.isEqual(instance, other, false);
    }

    public boolean isEqual(Annotation instance, Annotation other, boolean includeNonBindingTypes) {
        if (instance.annotationType().equals(this.getRawType()) && other.annotationType().equals(this.getRawType())) {
            for (AnnotatedMethod annotatedMethod : this.getAnnotatedAnnotation().getMethods()) {
                if (!includeNonBindingTypes && this.getNonBindingMembers().contains(annotatedMethod)) continue;
                try {
                    Object thatValue;
                    AccessController.doPrivileged(SetAccessibleAction.of(annotatedMethod.getJavaMember()));
                    Object thisValue = annotatedMethod.getJavaMember().invoke((Object)instance, new Object[0]);
                    if (thisValue.equals(thatValue = annotatedMethod.getJavaMember().invoke((Object)other, new Object[0]))) continue;
                    return false;
                }
                catch (IllegalArgumentException e) {
                    throw new WeldException(e);
                }
                catch (IllegalAccessException e) {
                    throw new WeldException(e);
                }
                catch (InvocationTargetException e) {
                    throw new WeldException(e);
                }
            }
            return true;
        }
        return false;
    }
}

