/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.bean.mvc;

import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.inject.Inject;
import javax.mvc.Controller;
import javax.portlet.annotations.ActionMethod;
import javax.portlet.annotations.RenderMethod;
import javax.portlet.annotations.ServeResourceMethod;
import javax.validation.executable.ExecutableType;
import javax.validation.executable.ValidateOnExecution;
import javax.ws.rs.BeanParam;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.pluto.container.bean.mvc.BeanValidationInterceptorBinding;
import org.apache.pluto.container.bean.mvc.ControllerInterceptorBinding;
import org.apache.pluto.container.bean.mvc.CsrfValidationInterceptorBinding;
import org.apache.pluto.container.bean.mvc.ModifiedAnnotatedType;
import org.apache.pluto.container.bean.mvc.ModifiedField;
import org.apache.pluto.container.bean.mvc.ModifiedMethod;
import org.apache.pluto.container.bean.mvc.PortletParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Vetoed
public class MvcExtension
implements Extension {
    private static final Logger LOG = LoggerFactory.getLogger(MvcExtension.class);
    private static final Annotation BEAN_VALIDATION_INTERCEPTOR_BINDING = new BeanValidationInterceptorBinding(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return BeanValidationInterceptorBinding.class;
        }
    };
    private static final Annotation CONTROLLER_INTERCEPTOR_BINDING = new ControllerInterceptorBinding(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return ControllerInterceptorBinding.class;
        }
    };
    private static final Annotation CSRF_VALIDATION_INTERCEPTOR_BINDING = new CsrfValidationInterceptorBinding(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return CsrfValidationInterceptorBinding.class;
        }
    };
    private static final Annotation INJECT = new Inject(){

        public Class<? extends Annotation> annotationType() {
            return Inject.class;
        }
    };
    private static final Annotation PORTLET_PARAM = new PortletParam(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return PortletParam.class;
        }
    };
    private static final Class<? extends Annotation>[] UNSUPPORTED_ANNOTATION_CLASSES = new Class[]{MatrixParam.class, PathParam.class};

    public static <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> processAnnotatedType) {
        AnnotatedType annotatedType = processAnnotatedType.getAnnotatedType();
        boolean modifiedMethods = false;
        LinkedHashSet annotatedMethods = new LinkedHashSet();
        boolean typeLevelController = annotatedType.isAnnotationPresent(Controller.class);
        for (ModifiedMethod annotatedMethod : annotatedType.getMethods()) {
            ActionMethod actionMethod = (ActionMethod)annotatedMethod.getAnnotation(ActionMethod.class);
            RenderMethod renderMethod = (RenderMethod)annotatedMethod.getAnnotation(RenderMethod.class);
            ServeResourceMethod serveResourceMethod = (ServeResourceMethod)annotatedMethod.getAnnotation(ServeResourceMethod.class);
            if ((actionMethod != null || renderMethod != null || serveResourceMethod != null) && (typeLevelController || annotatedMethod.isAnnotationPresent(Controller.class))) {
                LinkedHashSet methodAnnotations = new LinkedHashSet(annotatedMethod.getAnnotations());
                methodAnnotations.add(CONTROLLER_INTERCEPTOR_BINDING);
                modifiedMethods = true;
                if (actionMethod != null || serveResourceMethod != null) {
                    methodAnnotations.add(CSRF_VALIDATION_INTERCEPTOR_BINDING);
                }
                ValidateOnExecution validateOnExecution = (ValidateOnExecution)annotatedMethod.getAnnotation(ValidateOnExecution.class);
                boolean addBeanValidationInterceptor = true;
                if (validateOnExecution != null) {
                    ExecutableType[] executableTypes;
                    for (ExecutableType executableType : executableTypes = validateOnExecution.type()) {
                        if (executableType != ExecutableType.NONE) continue;
                        addBeanValidationInterceptor = false;
                        break;
                    }
                }
                if (addBeanValidationInterceptor) {
                    methodAnnotations.add(BEAN_VALIDATION_INTERCEPTOR_BINDING);
                }
                annotatedMethod = new ModifiedMethod(annotatedMethod, methodAnnotations);
            }
            annotatedMethods.add(annotatedMethod);
        }
        boolean modifiedFieldAnnotations = false;
        LinkedHashSet annotatedFields = new LinkedHashSet();
        for (ModifiedField annotatedField : annotatedType.getFields()) {
            LinkedHashSet<Annotation> fieldAnnotations = new LinkedHashSet<Annotation>(annotatedField.getAnnotations());
            for (Class<? extends Annotation> unsupportedAnnotationClass : UNSUPPORTED_ANNOTATION_CLASSES) {
                Annotation unsupportedAnnotation = annotatedField.getAnnotation(unsupportedAnnotationClass);
                if (unsupportedAnnotation == null) continue;
                fieldAnnotations.remove(unsupportedAnnotation);
                modifiedFieldAnnotations = true;
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("Removed unsupported @" + unsupportedAnnotationClass.getSimpleName() + " annotation from " + annotatedField);
            }
            BeanParam beanParam = (BeanParam)annotatedField.getAnnotation(BeanParam.class);
            CookieParam cookieParam = (CookieParam)annotatedField.getAnnotation(CookieParam.class);
            FormParam formParam = (FormParam)annotatedField.getAnnotation(FormParam.class);
            HeaderParam headerParam = (HeaderParam)annotatedField.getAnnotation(HeaderParam.class);
            QueryParam queryParam = (QueryParam)annotatedField.getAnnotation(QueryParam.class);
            if (beanParam != null || cookieParam != null || formParam != null || headerParam != null || queryParam != null) {
                if (!annotatedField.isAnnotationPresent(Inject.class)) {
                    fieldAnnotations.add(INJECT);
                    modifiedFieldAnnotations = true;
                }
                if (beanParam == null) {
                    fieldAnnotations.add(PORTLET_PARAM);
                    modifiedFieldAnnotations = true;
                }
            }
            if (modifiedFieldAnnotations) {
                annotatedField = new ModifiedField(annotatedField, fieldAnnotations);
            }
            annotatedFields.add(annotatedField);
        }
        if (modifiedMethods || modifiedFieldAnnotations) {
            processAnnotatedType.setAnnotatedType(new ModifiedAnnotatedType(annotatedType, annotatedFields, annotatedMethods));
        }
    }
}

