/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.concurrent.FastThreadLocal;
import java.io.IOException;
import java.util.Objects;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.MessageIdAdv;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.ChunkMessageIdImpl;
import org.apache.pulsar.client.impl.MessageIdAdvUtils;
import org.apache.pulsar.client.impl.TopicMessageIdImpl;
import org.apache.pulsar.common.api.proto.MessageIdData;
import org.apache.pulsar.common.naming.TopicName;

public class MessageIdImpl
implements MessageIdAdv {
    protected final long ledgerId;
    protected final long entryId;
    protected final int partitionIndex;
    private static final FastThreadLocal<MessageIdData> LOCAL_MESSAGE_ID = new FastThreadLocal<MessageIdData>(){

        protected MessageIdData initialValue() throws Exception {
            return new MessageIdData();
        }
    };

    private MessageIdImpl() {
        this(-1L, -1L, -1);
    }

    public MessageIdImpl(long ledgerId, long entryId, int partitionIndex) {
        this.ledgerId = ledgerId;
        this.entryId = entryId;
        this.partitionIndex = partitionIndex;
    }

    public long getLedgerId() {
        return this.ledgerId;
    }

    public long getEntryId() {
        return this.entryId;
    }

    public int getPartitionIndex() {
        return this.partitionIndex;
    }

    public int hashCode() {
        return MessageIdAdvUtils.hashCode(this);
    }

    public boolean equals(Object o) {
        return MessageIdAdvUtils.equals(this, o);
    }

    public String toString() {
        return this.ledgerId + ":" + this.entryId + ":" + this.partitionIndex;
    }

    public static MessageId fromByteArray(byte[] data) throws IOException {
        MessageIdImpl messageId;
        Objects.requireNonNull(data);
        MessageIdData idData = (MessageIdData)LOCAL_MESSAGE_ID.get();
        try {
            idData.parseFrom(Unpooled.wrappedBuffer((byte[])data, (int)0, (int)data.length), data.length);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        if (idData.hasBatchIndex()) {
            messageId = idData.hasBatchSize() ? new BatchMessageIdImpl(idData.getLedgerId(), idData.getEntryId(), idData.getPartition(), idData.getBatchIndex(), idData.getBatchSize(), BatchMessageIdImpl.newAckSet(idData.getBatchSize())) : new BatchMessageIdImpl(idData.getLedgerId(), idData.getEntryId(), idData.getPartition(), idData.getBatchIndex());
        } else if (idData.hasFirstChunkMessageId()) {
            MessageIdData firstChunkIdData = idData.getFirstChunkMessageId();
            messageId = new ChunkMessageIdImpl(new MessageIdImpl(firstChunkIdData.getLedgerId(), firstChunkIdData.getEntryId(), firstChunkIdData.getPartition()), new MessageIdImpl(idData.getLedgerId(), idData.getEntryId(), idData.getPartition()));
        } else {
            messageId = new MessageIdImpl(idData.getLedgerId(), idData.getEntryId(), idData.getPartition());
        }
        return messageId;
    }

    public static MessageId fromByteArrayWithTopic(byte[] data, String topicName) throws IOException {
        return MessageIdImpl.fromByteArrayWithTopic(data, TopicName.get((String)topicName));
    }

    public static MessageId fromByteArrayWithTopic(byte[] data, TopicName topicName) throws IOException {
        Objects.requireNonNull(data);
        MessageIdData idData = (MessageIdData)LOCAL_MESSAGE_ID.get();
        try {
            idData.parseFrom(Unpooled.wrappedBuffer((byte[])data, (int)0, (int)data.length), data.length);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        Object messageId = idData.hasBatchIndex() ? (idData.hasBatchSize() ? new BatchMessageIdImpl(idData.getLedgerId(), idData.getEntryId(), idData.getPartition(), idData.getBatchIndex(), idData.getBatchSize(), BatchMessageIdImpl.newAckSet(idData.getBatchSize())) : new BatchMessageIdImpl(idData.getLedgerId(), idData.getEntryId(), idData.getPartition(), idData.getBatchIndex(), 0, null)) : new MessageIdImpl(idData.getLedgerId(), idData.getEntryId(), idData.getPartition());
        if (idData.getPartition() > -1 && topicName != null) {
            messageId = new TopicMessageIdImpl(topicName.getPartition(idData.getPartition()).toString(), (MessageIdAdv)messageId);
        }
        return messageId;
    }

    protected MessageIdData writeMessageIdData(MessageIdData msgId, int batchIndex, int batchSize) {
        if (msgId == null) {
            msgId = ((MessageIdData)LOCAL_MESSAGE_ID.get()).clear();
        }
        msgId.setLedgerId(this.ledgerId).setEntryId(this.entryId);
        if (this.partitionIndex >= 0) {
            msgId.setPartition(this.partitionIndex);
        }
        if (batchIndex != -1) {
            msgId.setBatchIndex(batchIndex);
        }
        if (batchSize > -1) {
            msgId.setBatchSize(batchSize);
        }
        return msgId;
    }

    protected byte[] toByteArray(int batchIndex, int batchSize) {
        MessageIdData msgId = this.writeMessageIdData(null, batchIndex, batchSize);
        int size = msgId.getSerializedSize();
        ByteBuf serialized = Unpooled.buffer((int)size, (int)size);
        msgId.writeTo(serialized);
        return serialized.array();
    }

    public byte[] toByteArray() {
        return this.toByteArray(-1, 0);
    }
}

