/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.SocketConnectionPrincipal;
import org.apache.qpid.server.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationResultCacher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationResultCacher.class);
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private final Cache<String, AuthenticationResult> _authenticationCache;
    private final int _iterationCount;

    public AuthenticationResultCacher(int cacheSize, long expirationTime, int iterationCount) {
        if (cacheSize <= 0 || expirationTime <= 0L || iterationCount < 0) {
            LOGGER.debug("disabling authentication result caching");
            this._iterationCount = 0;
            this._authenticationCache = null;
        } else {
            this._iterationCount = iterationCount;
            this._authenticationCache = Caffeine.newBuilder().maximumSize((long)cacheSize).expireAfterWrite(expirationTime, TimeUnit.SECONDS).build();
        }
    }

    public AuthenticationResult getOrLoad(String[] credentials, Callable<AuthenticationResult> loader) {
        try {
            if (this._authenticationCache == null) {
                return loader.call();
            }
            String credentialDigest = this.digestCredentials(credentials);
            return (AuthenticationResult)this._authenticationCache.get((Object)credentialDigest, key -> {
                try {
                    return (AuthenticationResult)loader.call();
                }
                catch (Exception e) {
                    throw new RuntimeException("Unexpected checked Exception while authenticating", e);
                }
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Unexpected checked Exception while authenticating", e.getCause());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected checked Exception while authenticating", e);
        }
    }

    private String digestCredentials(String ... content) {
        try {
            SocketConnectionPrincipal connectionPrincipal;
            SocketAddress remoteAddress;
            String address;
            Object connectionPrincipals;
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            Subject subject = Subject.getSubject(AccessController.getContext());
            if (subject != null && !(connectionPrincipals = subject.getPrincipals(SocketConnectionPrincipal.class)).isEmpty() && (address = (remoteAddress = (connectionPrincipal = (SocketConnectionPrincipal)connectionPrincipals.iterator().next()).getRemoteAddress()) instanceof InetSocketAddress ? ((InetSocketAddress)remoteAddress).getHostString() : remoteAddress.toString()) != null) {
                md.update(address.getBytes(UTF8));
            }
            for (String part : content) {
                md.update(part.getBytes(UTF8));
            }
            byte[] credentialDigest = md.digest();
            for (int i = 0; i < this._iterationCount; ++i) {
                md = MessageDigest.getInstance("SHA-256");
                credentialDigest = md.digest(credentialDigest);
            }
            return StringUtil.toHex(credentialDigest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("JVM is non compliant. Seems to not support SHA-256.");
        }
    }
}

