/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.user.connection.limits.config;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import org.apache.qpid.server.user.connection.limits.config.BlockingRule;
import org.apache.qpid.server.user.connection.limits.config.ConnectionLimits;
import org.apache.qpid.server.user.connection.limits.config.NonBlockingRule;
import org.apache.qpid.server.user.connection.limits.config.RulePredicates;
import org.apache.qpid.server.user.connection.limits.plugins.ConnectionLimitRule;

public interface Rule
extends ConnectionLimits {
    public String getPort();

    public String getIdentity();

    @Override
    public Integer getCountLimit();

    public Integer getFrequencyLimit();

    public Duration getFrequencyPeriod();

    @Override
    default public Map<Duration, Integer> getFrequencyLimits() {
        if (this.getFrequencyLimit() != null) {
            return Collections.singletonMap(this.getFrequencyPeriod(), this.getFrequencyLimit());
        }
        return Collections.emptyMap();
    }

    public void updateWithDefaultFrequencyPeriod(Duration var1);

    public static Rule newInstance(ConnectionLimitRule rule) {
        if (Boolean.TRUE.equals(rule.getBlocked())) {
            return new BlockingRule(rule);
        }
        return new NonBlockingRule(rule);
    }

    public static Rule newInstance(String identity, RulePredicates predicates) {
        if (predicates.isUserBlocked()) {
            return Rule.newBlockingRule(predicates.getPort(), identity);
        }
        return Rule.newNonBlockingRule(predicates.getPort(), identity, predicates.getConnectionCountLimit(), predicates.getConnectionFrequencyLimit(), predicates.getConnectionFrequencyPeriod());
    }

    public static NonBlockingRule newNonBlockingRule(String port, String identity, Integer count, Integer frequency, Duration frequencyPeriod) {
        return new NonBlockingRule(port, identity, count, frequency, frequencyPeriod);
    }

    public static BlockingRule newBlockingRule(String port, String identity) {
        return new BlockingRule(port, identity);
    }
}

