/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.ArrayList;
import java.util.List;
import org.apache.qpid.server.filter.MessageFilter;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.virtualhost.QueueManagingVirtualHost;

abstract class QueueEntryTransaction
implements QueueManagingVirtualHost.TransactionalOperation {
    private final Queue _sourceQueue;
    private final List<Long> _messageIds;
    private final MessageFilter _filter;
    private final List<Long> _modifiedMessageIds = new ArrayList<Long>();
    private int _limit;

    QueueEntryTransaction(Queue sourceQueue, List<Long> messageIds, MessageFilter filter, int limit) {
        this._sourceQueue = sourceQueue;
        this._messageIds = messageIds == null ? null : new ArrayList<Long>(messageIds);
        this._filter = filter;
        this._limit = limit;
    }

    @Override
    public final void withinTransaction(QueueManagingVirtualHost.Transaction txn) {
        if (this._limit != 0) {
            this._sourceQueue.visit(entry -> {
                ServerMessage message = entry.getMessage();
                boolean stop = false;
                if (message != null) {
                    long messageId = message.getMessageNumber();
                    if ((this._messageIds == null || this._messageIds.remove(messageId)) && (this._filter == null || this._filter.matches(entry.asFilterable()))) {
                        stop = this.updateEntry(entry, txn);
                        this._modifiedMessageIds.add(messageId);
                        if (this._limit > 0) {
                            --this._limit;
                        }
                    }
                }
                return stop || this._limit == 0 || this._messageIds != null && this._messageIds.isEmpty();
            });
        }
    }

    protected abstract boolean updateEntry(QueueEntry var1, QueueManagingVirtualHost.Transaction var2);

    @Override
    public final List<Long> getModifiedMessageIds() {
        return this._modifiedMessageIds;
    }
}

