/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhostnode;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.messages.ConfigStoreMessages;
import org.apache.qpid.server.logging.subjects.MessageStoreLogSubject;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectTypeRegistry;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.IntegrityViolationException;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.SystemConfig;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.plugin.ConfiguredObjectRegistration;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.ConfiguredObjectRecordConverter;
import org.apache.qpid.server.store.ConfiguredObjectRecordImpl;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.preferences.PreferenceStore;
import org.apache.qpid.server.store.preferences.PreferenceStoreAttributes;
import org.apache.qpid.server.store.preferences.PreferenceStoreFactoryService;
import org.apache.qpid.server.util.urlstreamhandler.data.Handler;
import org.apache.qpid.server.virtualhost.NonStandardVirtualHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVirtualHostNode<X extends AbstractVirtualHostNode<X>>
extends AbstractConfiguredObject<X>
implements VirtualHostNode<X> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractVirtualHostNode.class);
    private final Broker<?> _broker;
    private final EventLogger _eventLogger;
    private DurableConfigurationStore _durableConfigurationStore;
    private MessageStoreLogSubject _configurationStoreLogSubject;
    private volatile TaskExecutor _virtualHostExecutor;
    @ManagedAttributeField
    private boolean _defaultVirtualHostNode;
    @ManagedAttributeField
    private String _virtualHostInitialConfiguration;
    @ManagedAttributeField
    private PreferenceStoreAttributes _preferenceStoreAttributes;

    public AbstractVirtualHostNode(Broker<?> parent, Map<String, Object> attributes) {
        super(parent, attributes);
        this._broker = parent;
        SystemConfig systemConfig = this.getAncestor(SystemConfig.class);
        this._eventLogger = systemConfig.getEventLogger();
    }

    @Override
    public void onOpen() {
        super.onOpen();
        this._virtualHostExecutor = this.getTaskExecutor().getFactory().newInstance("VirtualHostNode-" + this.getName() + "-Config", () -> {
            VirtualHost<?> virtualHost = this.getVirtualHost();
            if (virtualHost != null) {
                return virtualHost.getPrincipal();
            }
            return null;
        });
        this._virtualHostExecutor.start();
        this._durableConfigurationStore = this.createConfigurationStore();
    }

    @Override
    public TaskExecutor getChildExecutor() {
        return this._virtualHostExecutor;
    }

    @Override
    public LifetimePolicy getLifetimePolicy() {
        return LifetimePolicy.PERMANENT;
    }

    @Override
    protected void onCreate() {
        super.onCreate();
    }

    @StateTransition(currentState={State.UNINITIALIZED}, desiredState=State.QUIESCED)
    protected CompletableFuture<Void> startQuiesced() {
        this.setState(State.QUIESCED);
        return CompletableFuture.completedFuture(null);
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.STOPPED, State.ERRORED}, desiredState=State.ACTIVE)
    protected CompletableFuture<Void> doActivate() {
        CompletableFuture<Void> returnVal = new CompletableFuture<Void>();
        try {
            this.activate().whenCompleteAsync((result, throwable) -> {
                if (throwable != null) {
                    this.onActivationFailure(returnVal, (Throwable)throwable);
                } else {
                    try {
                        this.setState(State.ACTIVE);
                    }
                    finally {
                        returnVal.complete(null);
                    }
                }
            }, (Executor)this.getTaskExecutor());
        }
        catch (RuntimeException e) {
            this.onActivationFailure(returnVal, e);
        }
        return returnVal;
    }

    private void onActivationFailure(CompletableFuture<Void> returnVal, Throwable e) {
        this.stopAndSetStateTo(State.ERRORED).whenComplete((throwable, error) -> {
            if (this._broker.isManagementMode()) {
                LOGGER.warn("Failed to make " + String.valueOf(this) + " active.", e);
                returnVal.complete(null);
            } else {
                returnVal.completeExceptionally(e);
            }
        });
    }

    @Override
    public VirtualHost<?> getVirtualHost() {
        ArrayList<VirtualHost> children = new ArrayList<VirtualHost>(this.getChildren(VirtualHost.class));
        if (children.size() == 0) {
            return null;
        }
        if (children.size() == 1) {
            return (VirtualHost)children.iterator().next();
        }
        throw new IllegalStateException(String.valueOf(this) + " has an unexpected number of virtualhost children, size " + children.size());
    }

    @Override
    protected void validateOnCreate() {
        VirtualHostNode existingDefault;
        super.validateOnCreate();
        if (this.isDefaultVirtualHostNode() && (existingDefault = this._broker.findDefautVirtualHostNode()) != null) {
            throw new IllegalConfigurationException("The existing virtual host node '" + existingDefault.getName() + "' is already the default for the Broker.");
        }
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        VirtualHostNode existingDefault;
        super.validateChange(proxyForValidation, changedAttributes);
        VirtualHostNode updated = (VirtualHostNode)proxyForValidation;
        if (changedAttributes.contains("defaultVirtualHostNode") && updated.isDefaultVirtualHostNode() && (existingDefault = this._broker.findDefautVirtualHostNode()) != null && existingDefault != this) {
            throw new IntegrityViolationException("Cannot make '" + this.getName() + "' the default virtual host node for the Broker as virtual host node '" + existingDefault.getName() + "' is already the default.");
        }
    }

    @Override
    public DurableConfigurationStore getConfigurationStore() {
        return this._durableConfigurationStore;
    }

    protected Broker<?> getBroker() {
        return this._broker;
    }

    @Override
    public EventLogger getEventLogger() {
        return this._eventLogger;
    }

    protected MessageStoreLogSubject getConfigurationStoreLogSubject() {
        return this._configurationStoreLogSubject;
    }

    @Override
    protected CompletableFuture<Void> onDelete() {
        throw new UnsupportedOperationException("Sub-classes must override");
    }

    protected CompletableFuture<Void> closeVirtualHostIfExists() {
        VirtualHost<?> virtualHost = this.getVirtualHost();
        if (virtualHost != null) {
            return virtualHost.closeAsync();
        }
        return CompletableFuture.completedFuture(null);
    }

    @StateTransition(currentState={State.ACTIVE, State.ERRORED, State.UNINITIALIZED}, desiredState=State.STOPPED)
    protected CompletableFuture<Void> doStop() {
        return this.stopAndSetStateTo(State.STOPPED);
    }

    protected CompletableFuture<Void> stopAndSetStateTo(State stoppedState) {
        CompletableFuture<Void> childCloseFuture = this.closeChildren();
        return childCloseFuture.whenComplete((result, throwable) -> {
            this.closeConfigurationStoreSafely();
            this.setState(stoppedState);
        });
    }

    @Override
    protected void onExceptionInOpen(RuntimeException e) {
        super.onExceptionInOpen(e);
        this.closeConfigurationStoreSafely();
    }

    @Override
    protected void postResolve() {
        super.postResolve();
        DurableConfigurationStore store = this.getConfigurationStore();
        if (store == null) {
            store = this.createConfigurationStore();
        }
        this._configurationStoreLogSubject = new MessageStoreLogSubject(this.getName(), store.getClass().getSimpleName());
    }

    @Override
    protected CompletableFuture<Void> onClose() {
        this.closeConfigurationStore();
        this.onCloseOrDelete();
        return CompletableFuture.completedFuture(null);
    }

    protected void onCloseOrDelete() {
        this._virtualHostExecutor.stop();
    }

    private void closeConfigurationStore() {
        DurableConfigurationStore configurationStore = this.getConfigurationStore();
        if (configurationStore != null) {
            configurationStore.closeConfigurationStore();
            this.getEventLogger().message(this.getConfigurationStoreLogSubject(), ConfigStoreMessages.CLOSE());
        }
    }

    private void closeConfigurationStoreSafely() {
        try {
            this.closeConfigurationStore();
        }
        catch (Exception e) {
            LOGGER.warn("Unexpected exception on close of configuration store", (Throwable)e);
        }
    }

    @Override
    public String getVirtualHostInitialConfiguration() {
        return this._virtualHostInitialConfiguration;
    }

    @Override
    public boolean isDefaultVirtualHostNode() {
        return this._defaultVirtualHostNode;
    }

    @Override
    public PreferenceStoreAttributes getPreferenceStoreAttributes() {
        return this._preferenceStoreAttributes;
    }

    @Override
    public PreferenceStore createPreferenceStore() {
        Map<String, Object> attributes;
        String preferenceStoreType;
        Map<String, PreferenceStoreFactoryService> preferenceStoreFactories = new QpidServiceLoader().getInstancesByType(PreferenceStoreFactoryService.class);
        PreferenceStoreAttributes preferenceStoreAttributes = this.getPreferenceStoreAttributes();
        if (preferenceStoreAttributes == null) {
            preferenceStoreType = "Noop";
            attributes = Map.of();
        } else {
            preferenceStoreType = preferenceStoreAttributes.getType();
            attributes = preferenceStoreAttributes.getAttributes();
        }
        PreferenceStoreFactoryService preferenceStoreFactory = preferenceStoreFactories.get(preferenceStoreType);
        return preferenceStoreFactory.createInstance(this, attributes);
    }

    protected abstract DurableConfigurationStore createConfigurationStore();

    protected abstract CompletableFuture<Void> activate();

    protected abstract ConfiguredObjectRecord enrichInitialVirtualHostRootRecord(ConfiguredObjectRecord var1);

    protected final ConfiguredObjectRecord[] getInitialRecords() throws IOException {
        ArrayList<ConfiguredObjectRecord> records;
        ConfiguredObjectRecordConverter converter = new ConfiguredObjectRecordConverter(this.getModel());
        try (Reader initialConfigReader = this.getInitialConfigReader();){
            records = new ArrayList<ConfiguredObjectRecord>(converter.readFromJson(VirtualHost.class, this, initialConfigReader));
        }
        if (!records.isEmpty()) {
            ConfiguredObjectRecord vhostRecord = null;
            for (ConfiguredObjectRecord record : records) {
                if (!record.getType().equals(VirtualHost.class.getSimpleName())) continue;
                vhostRecord = record;
                break;
            }
            if (vhostRecord == null) {
                throw new IllegalConfigurationException("Somehow the initial configuration has records but not a VirtualHost. This must be a coding error in Qpid");
            }
            records.remove(vhostRecord);
            vhostRecord = this.enrichInitialVirtualHostRootRecord(vhostRecord);
            records.add(vhostRecord);
            this.addStandardExchangesIfNecessary(records, vhostRecord);
            this.enrichWithAuditInformation(records);
        }
        return records.toArray(new ConfiguredObjectRecord[records.size()]);
    }

    private void enrichWithAuditInformation(Collection<ConfiguredObjectRecord> records) {
        ArrayList<ConfiguredObjectRecordImpl> replacements = new ArrayList<ConfiguredObjectRecordImpl>(records.size());
        for (ConfiguredObjectRecord record : records) {
            replacements.add(new ConfiguredObjectRecordImpl(record.getId(), record.getType(), this.enrichAttributesWithAuditInformation(record.getAttributes()), record.getParents()));
        }
        records.clear();
        records.addAll(replacements);
    }

    private Map<String, Object> enrichAttributesWithAuditInformation(Map<String, Object> attributes) {
        LinkedHashMap<String, Object> enriched = new LinkedHashMap<String, Object>(attributes);
        AuthenticatedPrincipal currentUser = AuthenticatedPrincipal.getCurrentUser();
        if (currentUser != null) {
            enriched.put("lastUpdatedBy", currentUser.getName());
            enriched.put("createdBy", currentUser.getName());
        }
        long currentTime = System.currentTimeMillis();
        enriched.put("lastUpdatedTime", currentTime);
        enriched.put("createdTime", currentTime);
        return enriched;
    }

    private void addStandardExchangesIfNecessary(Collection<ConfiguredObjectRecord> records, ConfiguredObjectRecord vhostRecord) {
        this.addExchangeIfNecessary("fanout", "amq.fanout", records, vhostRecord);
        this.addExchangeIfNecessary("headers", "amq.match", records, vhostRecord);
        this.addExchangeIfNecessary("topic", "amq.topic", records, vhostRecord);
        this.addExchangeIfNecessary("direct", "amq.direct", records, vhostRecord);
    }

    private void addExchangeIfNecessary(String exchangeClass, String exchangeName, Collection<ConfiguredObjectRecord> records, ConfiguredObjectRecord vhostRecord) {
        boolean found = false;
        for (ConfiguredObjectRecord record : records) {
            if (!Exchange.class.getSimpleName().equals(record.getType()) || !exchangeName.equals(record.getAttributes().get("name"))) continue;
            found = true;
            break;
        }
        if (!found) {
            HashMap<String, Object> exchangeAttributes = new HashMap<String, Object>();
            exchangeAttributes.put("name", exchangeName);
            exchangeAttributes.put("type", exchangeClass);
            records.add(new ConfiguredObjectRecordImpl(UUID.randomUUID(), Exchange.class.getSimpleName(), exchangeAttributes, Collections.singletonMap(VirtualHost.class.getSimpleName(), vhostRecord.getId())));
        }
    }

    protected final Reader getInitialConfigReader() throws IOException {
        Reader initialConfigReader;
        if (this.getVirtualHostInitialConfiguration() != null) {
            String initialContextString = this.getVirtualHostInitialConfiguration();
            try {
                URL url = new URL(initialContextString);
                initialConfigReader = new InputStreamReader(url.openStream());
            }
            catch (MalformedURLException e) {
                initialConfigReader = new StringReader(initialContextString);
            }
        } else {
            LOGGER.warn("No initial configuration found for the virtual host");
            initialConfigReader = new StringReader("{}");
        }
        return initialConfigReader;
    }

    protected static Collection<String> getSupportedVirtualHostTypes(boolean includeProvided) {
        Iterable<ConfiguredObjectRegistration> registrations = new QpidServiceLoader().instancesOf(ConfiguredObjectRegistration.class);
        HashSet<String> supportedTypes = new HashSet<String>();
        for (ConfiguredObjectRegistration registration : registrations) {
            for (Class<? extends ConfiguredObject> typeClass : registration.getConfiguredObjectClasses()) {
                ManagedObject annotation;
                if (!VirtualHost.class.isAssignableFrom(typeClass) || !(annotation = typeClass.getAnnotation(ManagedObject.class)).creatable() || !annotation.defaultType().equals("") || NonStandardVirtualHost.class.isAssignableFrom(typeClass)) continue;
                supportedTypes.add(ConfiguredObjectTypeRegistry.getType(typeClass));
            }
        }
        if (includeProvided) {
            supportedTypes.add("ProvidedStore");
        }
        return Collections.unmodifiableCollection(supportedTypes);
    }

    static {
        Handler.register();
    }
}

