/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.compression;

import java.util.EnumMap;
import org.apache.rocketmq.common.compression.CompressionType;
import org.apache.rocketmq.common.compression.Compressor;
import org.apache.rocketmq.common.compression.Lz4Compressor;
import org.apache.rocketmq.common.compression.ZlibCompressor;
import org.apache.rocketmq.common.compression.ZstdCompressor;

public class CompressorFactory {
    private static final EnumMap<CompressionType, Compressor> COMPRESSORS = new EnumMap(CompressionType.class);

    public static Compressor getCompressor(CompressionType type) {
        return COMPRESSORS.get((Object)type);
    }

    static {
        COMPRESSORS.put(CompressionType.LZ4, new Lz4Compressor());
        COMPRESSORS.put(CompressionType.ZSTD, new ZstdCompressor());
        COMPRESSORS.put(CompressionType.ZLIB, new ZlibCompressor());
    }
}

