/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.rocketmq.producer;

import io.openmessaging.BytesMessage;
import io.openmessaging.KeyValue;
import io.openmessaging.Message;
import io.openmessaging.MessageFactory;
import io.openmessaging.ServiceLifecycle;
import io.openmessaging.exception.OMSMessageFormatException;
import io.openmessaging.exception.OMSNotSupportedException;
import io.openmessaging.exception.OMSRuntimeException;
import io.openmessaging.exception.OMSTimeOutException;
import io.openmessaging.rocketmq.config.ClientConfig;
import io.openmessaging.rocketmq.domain.BytesMessageImpl;
import io.openmessaging.rocketmq.utils.BeanUtils;
import io.openmessaging.rocketmq.utils.OMSUtil;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.log.ClientLogger;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.remoting.exception.RemotingConnectException;
import org.apache.rocketmq.remoting.exception.RemotingTimeoutException;
import org.apache.rocketmq.remoting.protocol.LanguageCode;

abstract class AbstractOMSProducer
implements ServiceLifecycle,
MessageFactory {
    static final InternalLogger log = ClientLogger.getLog();
    final KeyValue properties;
    final DefaultMQProducer rocketmqProducer;
    private boolean started = false;
    private final ClientConfig clientConfig;

    AbstractOMSProducer(KeyValue properties) {
        this.properties = properties;
        this.rocketmqProducer = new DefaultMQProducer();
        this.clientConfig = (ClientConfig)((Object)BeanUtils.populate(properties, ClientConfig.class));
        if ("true".equalsIgnoreCase(System.getenv("OMS_RMQ_DIRECT_NAME_SRV"))) {
            String accessPoints = this.clientConfig.getAccessPoints();
            if (accessPoints == null || accessPoints.isEmpty()) {
                throw new OMSRuntimeException("-1", "OMS AccessPoints is null or empty.");
            }
            this.rocketmqProducer.setNamesrvAddr(accessPoints.replace(',', ';'));
        }
        this.rocketmqProducer.setProducerGroup(this.clientConfig.getRmqProducerGroup());
        String producerId = OMSUtil.buildInstanceName();
        this.rocketmqProducer.setSendMsgTimeout(this.clientConfig.getOperationTimeout());
        this.rocketmqProducer.setInstanceName(producerId);
        this.rocketmqProducer.setMaxMessageSize(0x400000);
        this.rocketmqProducer.setLanguage(LanguageCode.OMS);
        properties.put("PRODUCER_ID", producerId);
    }

    public synchronized void startup() {
        if (!this.started) {
            try {
                this.rocketmqProducer.start();
            }
            catch (MQClientException e) {
                throw new OMSRuntimeException("-1", (Throwable)e);
            }
        }
        this.started = true;
    }

    public synchronized void shutdown() {
        if (this.started) {
            this.rocketmqProducer.shutdown();
        }
        this.started = false;
    }

    OMSRuntimeException checkProducerException(String topic, String msgId, Throwable e) {
        if (e instanceof MQClientException) {
            if (e.getCause() != null) {
                if (e.getCause() instanceof RemotingTimeoutException) {
                    return new OMSTimeOutException("-1", String.format("Send message to broker timeout, %dms, Topic=%s, msgId=%s", this.rocketmqProducer.getSendMsgTimeout(), topic, msgId), e);
                }
                if (e.getCause() instanceof MQBrokerException || e.getCause() instanceof RemotingConnectException) {
                    if (e.getCause() instanceof MQBrokerException) {
                        MQBrokerException brokerException = (MQBrokerException)e.getCause();
                        return new OMSRuntimeException("-1", String.format("Received a broker exception, Topic=%s, msgId=%s, %s", topic, msgId, brokerException.getErrorMessage()), e);
                    }
                    if (e.getCause() instanceof RemotingConnectException) {
                        RemotingConnectException connectException = (RemotingConnectException)e.getCause();
                        return new OMSRuntimeException("-1", String.format("Network connection experiences failures. Topic=%s, msgId=%s, %s", topic, msgId, connectException.getMessage()), e);
                    }
                }
            } else {
                MQClientException clientException = (MQClientException)e;
                if (-1 == clientException.getResponseCode()) {
                    return new OMSRuntimeException("-1", String.format("Topic does not exist, Topic=%s, msgId=%s", topic, msgId), e);
                }
                if (13 == clientException.getResponseCode()) {
                    return new OMSMessageFormatException("-1", String.format("A illegal message for RocketMQ, Topic=%s, msgId=%s", topic, msgId), e);
                }
            }
        }
        return new OMSRuntimeException("-1", "Send message to RocketMQ broker failed.", e);
    }

    protected void checkMessageType(Message message) {
        if (!(message instanceof BytesMessage)) {
            throw new OMSNotSupportedException("-1", "Only BytesMessage is supported.");
        }
    }

    public BytesMessage createBytesMessage(String queue, byte[] body) {
        BytesMessageImpl message = new BytesMessageImpl();
        message.setBody(body);
        message.sysHeaders().put("DESTINATION", queue);
        return message;
    }
}

