/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger.store.file;

import io.openmessaging.storage.dledger.DLedgerConfig;
import io.openmessaging.storage.dledger.MemberState;
import io.openmessaging.storage.dledger.ShutdownAbleThread;
import io.openmessaging.storage.dledger.entry.DLedgerEntry;
import io.openmessaging.storage.dledger.entry.DLedgerEntryCoder;
import io.openmessaging.storage.dledger.protocol.DLedgerResponseCode;
import io.openmessaging.storage.dledger.store.DLedgerStore;
import io.openmessaging.storage.dledger.store.file.MmapFile;
import io.openmessaging.storage.dledger.store.file.MmapFileList;
import io.openmessaging.storage.dledger.store.file.MultiPathMmapFileList;
import io.openmessaging.storage.dledger.store.file.SelectMmapBufferResult;
import io.openmessaging.storage.dledger.utils.DLedgerUtils;
import io.openmessaging.storage.dledger.utils.IOUtils;
import io.openmessaging.storage.dledger.utils.Pair;
import io.openmessaging.storage.dledger.utils.PreConditions;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLedgerMmapFileStore
extends DLedgerStore {
    public static final String CHECK_POINT_FILE = "checkpoint";
    public static final String END_INDEX_KEY = "endIndex";
    public static final String COMMITTED_INDEX_KEY = "committedIndex";
    public static final int MAGIC_1 = 1;
    public static final int CURRENT_MAGIC = 1;
    public static final int INDEX_UNIT_SIZE = 32;
    private static Logger logger = LoggerFactory.getLogger(DLedgerMmapFileStore.class);
    public List<AppendHook> appendHooks = new ArrayList<AppendHook>();
    private long ledgerBeginIndex = -1L;
    private long ledgerEndIndex = -1L;
    private long committedIndex = -1L;
    private long committedPos = -1L;
    private long ledgerEndTerm;
    private DLedgerConfig dLedgerConfig;
    private MemberState memberState;
    private MmapFileList dataFileList;
    private MmapFileList indexFileList;
    private ThreadLocal<ByteBuffer> localEntryBuffer;
    private ThreadLocal<ByteBuffer> localIndexBuffer;
    private FlushDataService flushDataService;
    private CleanSpaceService cleanSpaceService;
    private volatile boolean isDiskFull = false;
    private long lastCheckPointTimeMs = System.currentTimeMillis();
    private AtomicBoolean hasLoaded = new AtomicBoolean(false);
    private AtomicBoolean hasRecovered = new AtomicBoolean(false);
    private volatile Set<String> fullStorePaths = Collections.emptySet();
    private boolean enableCleanSpaceService = true;

    public DLedgerMmapFileStore(DLedgerConfig dLedgerConfig, MemberState memberState) {
        this.dLedgerConfig = dLedgerConfig;
        this.memberState = memberState;
        this.dataFileList = dLedgerConfig.getDataStorePath().contains(DLedgerConfig.MULTI_PATH_SPLITTER) ? new MultiPathMmapFileList(dLedgerConfig, dLedgerConfig.getMappedFileSizeForEntryData(), this::getFullStorePaths) : new MmapFileList(dLedgerConfig.getDataStorePath(), dLedgerConfig.getMappedFileSizeForEntryData());
        this.indexFileList = new MmapFileList(dLedgerConfig.getIndexStorePath(), dLedgerConfig.getMappedFileSizeForEntryIndex());
        this.localEntryBuffer = ThreadLocal.withInitial(() -> ByteBuffer.allocate(0x400000));
        this.localIndexBuffer = ThreadLocal.withInitial(() -> ByteBuffer.allocate(64));
        this.flushDataService = new FlushDataService("DLedgerFlushDataService", logger);
        this.cleanSpaceService = new CleanSpaceService("DLedgerCleanSpaceService", logger);
    }

    @Override
    public void startup() {
        this.load();
        this.recover();
        this.flushDataService.start();
        if (this.enableCleanSpaceService) {
            this.cleanSpaceService.start();
        }
    }

    @Override
    public void shutdown() {
        this.dataFileList.flush(0);
        this.indexFileList.flush(0);
        this.persistCheckPoint();
        if (this.enableCleanSpaceService) {
            this.cleanSpaceService.shutdown();
        }
        this.flushDataService.shutdown();
    }

    public long getWritePos() {
        return this.dataFileList.getMaxWrotePosition();
    }

    public long getFlushPos() {
        return this.dataFileList.getFlushedWhere();
    }

    @Override
    public void flush() {
        this.dataFileList.flush(0);
        this.indexFileList.flush(0);
    }

    public void load() {
        if (!this.hasLoaded.compareAndSet(false, true)) {
            return;
        }
        if (!this.dataFileList.load() || !this.indexFileList.load()) {
            logger.error("Load file failed, this usually indicates fatal error, you should check it manually");
            System.exit(-1);
        }
    }

    public void recover() {
        if (!this.hasRecovered.compareAndSet(false, true)) {
            return;
        }
        PreConditions.check(this.dataFileList.checkSelf(), DLedgerResponseCode.DISK_ERROR, "check data file order failed before recovery");
        PreConditions.check(this.indexFileList.checkSelf(), DLedgerResponseCode.DISK_ERROR, "check index file order failed before recovery");
        List<MmapFile> mappedFiles = this.dataFileList.getMappedFiles();
        if (mappedFiles.isEmpty()) {
            this.indexFileList.updateWherePosition(0L);
            this.indexFileList.truncateOffset(0L);
            return;
        }
        MmapFile lastMappedFile = this.dataFileList.getLastMappedFile();
        int index = mappedFiles.size() - 3;
        if (index < 0) {
            index = 0;
        }
        long firstEntryIndex = -1L;
        int i = index;
        while (i >= 0) {
            index = i--;
            MmapFile mappedFile = mappedFiles.get(index);
            ByteBuffer byteBuffer = mappedFile.sliceByteBuffer();
            try {
                long startPos = mappedFile.getFileFromOffset();
                int magic = byteBuffer.getInt();
                int size = byteBuffer.getInt();
                long entryIndex = byteBuffer.getLong();
                long entryTerm = byteBuffer.getLong();
                long pos = byteBuffer.getLong();
                byteBuffer.getInt();
                byteBuffer.getInt();
                byteBuffer.getInt();
                int bodySize = byteBuffer.getInt();
                PreConditions.check(magic != -1 && magic >= 1, DLedgerResponseCode.DISK_ERROR, "unknown magic=%d", magic);
                PreConditions.check(size > 44, DLedgerResponseCode.DISK_ERROR, "Size %d should > %d", size, 44);
                PreConditions.check(pos == startPos, DLedgerResponseCode.DISK_ERROR, "pos %d != %d", pos, startPos);
                PreConditions.check(bodySize + 48 == size, DLedgerResponseCode.DISK_ERROR, "size %d != %d + %d", size, bodySize, 48);
                SelectMmapBufferResult indexSbr = this.indexFileList.getData(entryIndex * 32L);
                PreConditions.check(indexSbr != null, DLedgerResponseCode.DISK_ERROR, "index=%d pos=%d", entryIndex, entryIndex * 32L);
                indexSbr.release();
                ByteBuffer indexByteBuffer = indexSbr.getByteBuffer();
                int magicFromIndex = indexByteBuffer.getInt();
                long posFromIndex = indexByteBuffer.getLong();
                int sizeFromIndex = indexByteBuffer.getInt();
                long indexFromIndex = indexByteBuffer.getLong();
                long termFromIndex = indexByteBuffer.getLong();
                PreConditions.check(magic == magicFromIndex, DLedgerResponseCode.DISK_ERROR, "magic %d != %d", magic, magicFromIndex);
                PreConditions.check(size == sizeFromIndex, DLedgerResponseCode.DISK_ERROR, "size %d != %d", size, sizeFromIndex);
                PreConditions.check(entryIndex == indexFromIndex, DLedgerResponseCode.DISK_ERROR, "index %d != %d", entryIndex, indexFromIndex);
                PreConditions.check(entryTerm == termFromIndex, DLedgerResponseCode.DISK_ERROR, "term %d != %d", entryTerm, termFromIndex);
                PreConditions.check(posFromIndex == mappedFile.getFileFromOffset(), DLedgerResponseCode.DISK_ERROR, "pos %d != %d", mappedFile.getFileFromOffset(), posFromIndex);
                firstEntryIndex = entryIndex;
                break;
            }
            catch (Throwable t) {
                logger.warn("Pre check data and index failed {}", (Object)mappedFile.getFileName(), (Object)t);
            }
        }
        MmapFile mappedFile = mappedFiles.get(index);
        ByteBuffer byteBuffer = mappedFile.sliceByteBuffer();
        logger.info("Begin to recover data from entryIndex={} fileIndex={} fileSize={} fileName={} ", new Object[]{firstEntryIndex, index, mappedFiles.size(), mappedFile.getFileName()});
        long lastEntryIndex = -1L;
        long lastEntryTerm = -1L;
        long processOffset = mappedFile.getFileFromOffset();
        boolean needWriteIndex = false;
        try {
            while (true) {
                int relativePos = byteBuffer.position();
                long absolutePos = mappedFile.getFileFromOffset() + (long)relativePos;
                int magic = byteBuffer.getInt();
                if (magic == -1) {
                    processOffset = mappedFile.getFileFromOffset() + (long)mappedFile.getFileSize();
                    if (++index >= mappedFiles.size()) {
                        logger.info("Recover data file over, the last file {}", (Object)mappedFile.getFileName());
                        break;
                    }
                    mappedFile = mappedFiles.get(index);
                    byteBuffer = mappedFile.sliceByteBuffer();
                    processOffset = mappedFile.getFileFromOffset();
                    logger.info("Trying to recover data file {}", (Object)mappedFile.getFileName());
                    continue;
                }
                int size = byteBuffer.getInt();
                if (size == 0) {
                    logger.info("Recover data file to the end of {} ", (Object)mappedFile.getFileName());
                    break;
                }
                long entryIndex = byteBuffer.getLong();
                long entryTerm = byteBuffer.getLong();
                long pos = byteBuffer.getLong();
                byteBuffer.getInt();
                byteBuffer.getInt();
                byteBuffer.getInt();
                int bodySize = byteBuffer.getInt();
                PreConditions.check(pos == absolutePos, DLedgerResponseCode.DISK_ERROR, "pos %d != %d", pos, absolutePos);
                PreConditions.check(bodySize + 48 == size, DLedgerResponseCode.DISK_ERROR, "size %d != %d + %d", size, bodySize, 48);
                byteBuffer.position(relativePos + size);
                PreConditions.check(magic <= 1 && magic >= 1, DLedgerResponseCode.DISK_ERROR, "pos=%d size=%d magic=%d index=%d term=%d currMagic=%d", absolutePos, size, magic, entryIndex, entryTerm, 1);
                if (lastEntryIndex != -1L) {
                    PreConditions.check(entryIndex == lastEntryIndex + 1L, DLedgerResponseCode.DISK_ERROR, "pos=%d size=%d magic=%d index=%d term=%d lastEntryIndex=%d", absolutePos, size, magic, entryIndex, entryTerm, lastEntryIndex);
                }
                PreConditions.check(entryTerm >= lastEntryTerm, DLedgerResponseCode.DISK_ERROR, "pos=%d size=%d magic=%d index=%d term=%d lastEntryTerm=%d ", absolutePos, size, magic, entryIndex, entryTerm, lastEntryTerm);
                PreConditions.check(size > 44, DLedgerResponseCode.DISK_ERROR, "size %d should > %d", size, 44);
                if (!needWriteIndex) {
                    try {
                        SelectMmapBufferResult indexSbr = this.indexFileList.getData(entryIndex * 32L);
                        PreConditions.check(indexSbr != null, DLedgerResponseCode.DISK_ERROR, "index=%d pos=%d", entryIndex, entryIndex * 32L);
                        indexSbr.release();
                        ByteBuffer indexByteBuffer = indexSbr.getByteBuffer();
                        int magicFromIndex = indexByteBuffer.getInt();
                        long posFromIndex = indexByteBuffer.getLong();
                        int sizeFromIndex = indexByteBuffer.getInt();
                        long indexFromIndex = indexByteBuffer.getLong();
                        long termFromIndex = indexByteBuffer.getLong();
                        PreConditions.check(magic == magicFromIndex, DLedgerResponseCode.DISK_ERROR, "magic %d != %d", magic, magicFromIndex);
                        PreConditions.check(size == sizeFromIndex, DLedgerResponseCode.DISK_ERROR, "size %d != %d", size, sizeFromIndex);
                        PreConditions.check(entryIndex == indexFromIndex, DLedgerResponseCode.DISK_ERROR, "index %d != %d", entryIndex, indexFromIndex);
                        PreConditions.check(entryTerm == termFromIndex, DLedgerResponseCode.DISK_ERROR, "term %d != %d", entryTerm, termFromIndex);
                        PreConditions.check(absolutePos == posFromIndex, DLedgerResponseCode.DISK_ERROR, "pos %d != %d", mappedFile.getFileFromOffset(), posFromIndex);
                    }
                    catch (Throwable t) {
                        logger.warn("Compare data to index failed {}", (Object)mappedFile.getFileName(), (Object)t);
                        this.indexFileList.truncateOffset(entryIndex * 32L);
                        if (this.indexFileList.getMaxWrotePosition() != entryIndex * 32L) {
                            long truncateIndexOffset = entryIndex * 32L;
                            logger.warn("[Recovery] rebuild for index wrotePos={} not equal to truncatePos={}", (Object)this.indexFileList.getMaxWrotePosition(), (Object)truncateIndexOffset);
                            PreConditions.check(this.indexFileList.rebuildWithPos(truncateIndexOffset), DLedgerResponseCode.DISK_ERROR, "rebuild index truncatePos=%d", truncateIndexOffset);
                        }
                        needWriteIndex = true;
                    }
                }
                if (needWriteIndex) {
                    ByteBuffer indexBuffer = this.localIndexBuffer.get();
                    DLedgerEntryCoder.encodeIndex(absolutePos, size, magic, entryIndex, entryTerm, indexBuffer);
                    long indexPos = this.indexFileList.append(indexBuffer.array(), 0, indexBuffer.remaining(), false);
                    PreConditions.check(indexPos == entryIndex * 32L, DLedgerResponseCode.DISK_ERROR, "Write index failed index=%d", entryIndex);
                }
                lastEntryIndex = entryIndex;
                lastEntryTerm = entryTerm;
                processOffset += (long)size;
            }
        }
        catch (Throwable t) {
            logger.info("Recover data file to the end of {} ", (Object)mappedFile.getFileName(), (Object)t);
        }
        logger.info("Recover data to the end entryIndex={} processOffset={} lastFileOffset={} cha={}", new Object[]{lastEntryIndex, processOffset, lastMappedFile.getFileFromOffset(), processOffset - lastMappedFile.getFileFromOffset()});
        if (lastMappedFile.getFileFromOffset() - processOffset > (long)lastMappedFile.getFileSize()) {
            logger.error("[MONITOR]The processOffset is too small, you should check it manually before truncating the data from {}", (Object)processOffset);
            System.exit(-1);
        }
        this.ledgerEndIndex = lastEntryIndex;
        this.ledgerEndTerm = lastEntryTerm;
        if (lastEntryIndex != -1L) {
            DLedgerEntry entry = this.get(lastEntryIndex);
            PreConditions.check(entry != null, DLedgerResponseCode.DISK_ERROR, "recheck get null entry");
            PreConditions.check(entry.getIndex() == lastEntryIndex, DLedgerResponseCode.DISK_ERROR, "recheck index %d != %d", entry.getIndex(), lastEntryIndex);
            this.reviseLedgerBeginIndex();
        }
        this.dataFileList.updateWherePosition(processOffset);
        this.dataFileList.truncateOffset(processOffset);
        long indexProcessOffset = (lastEntryIndex + 1L) * 32L;
        this.indexFileList.updateWherePosition(indexProcessOffset);
        this.indexFileList.truncateOffset(indexProcessOffset);
        this.updateLedgerEndIndexAndTerm();
        PreConditions.check(this.dataFileList.checkSelf(), DLedgerResponseCode.DISK_ERROR, "check data file order failed after recovery");
        PreConditions.check(this.indexFileList.checkSelf(), DLedgerResponseCode.DISK_ERROR, "check index file order failed after recovery");
        Properties properties = this.loadCheckPoint();
        if (properties == null || !properties.containsKey(COMMITTED_INDEX_KEY)) {
            return;
        }
        String committedIndexStr = String.valueOf(properties.get(COMMITTED_INDEX_KEY)).trim();
        if (committedIndexStr.length() <= 0) {
            return;
        }
        logger.info("Recover to get committed index={} from checkpoint", (Object)committedIndexStr);
        this.updateCommittedIndex(this.memberState.currTerm(), Long.valueOf(committedIndexStr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reviseLedgerBeginIndex() {
        MmapFile firstFile = this.dataFileList.getFirstMappedFile();
        SelectMmapBufferResult sbr = firstFile.selectMappedBuffer(0);
        try {
            ByteBuffer tmpBuffer = sbr.getByteBuffer();
            tmpBuffer.position(firstFile.getStartPosition());
            tmpBuffer.getInt();
            tmpBuffer.getInt();
            this.ledgerBeginIndex = tmpBuffer.getLong();
            this.indexFileList.resetOffset(this.ledgerBeginIndex * 32L);
        }
        finally {
            SelectMmapBufferResult.release(sbr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DLedgerEntry appendAsLeader(DLedgerEntry entry) {
        PreConditions.check(this.memberState.isLeader(), DLedgerResponseCode.NOT_LEADER);
        PreConditions.check(!this.isDiskFull, DLedgerResponseCode.DISK_FULL);
        ByteBuffer dataBuffer = this.localEntryBuffer.get();
        ByteBuffer indexBuffer = this.localIndexBuffer.get();
        DLedgerEntryCoder.encode(entry, dataBuffer);
        int entrySize = dataBuffer.remaining();
        MemberState memberState = this.memberState;
        synchronized (memberState) {
            PreConditions.check(this.memberState.isLeader(), DLedgerResponseCode.NOT_LEADER, null);
            PreConditions.check(this.memberState.getTransferee() == null, DLedgerResponseCode.LEADER_TRANSFERRING, null);
            long nextIndex = this.ledgerEndIndex + 1L;
            entry.setIndex(nextIndex);
            entry.setTerm(this.memberState.currTerm());
            entry.setMagic(1);
            DLedgerEntryCoder.setIndexTerm(dataBuffer, nextIndex, this.memberState.currTerm(), 1);
            long prePos = this.dataFileList.preAppend(dataBuffer.remaining());
            entry.setPos(prePos);
            PreConditions.check(prePos != -1L, DLedgerResponseCode.DISK_ERROR, null);
            DLedgerEntryCoder.setPos(dataBuffer, prePos);
            for (AppendHook writeHook : this.appendHooks) {
                writeHook.doHook(entry, dataBuffer.slice(), 48);
            }
            long dataPos = this.dataFileList.append(dataBuffer.array(), 0, dataBuffer.remaining());
            PreConditions.check(dataPos != -1L, DLedgerResponseCode.DISK_ERROR, null);
            PreConditions.check(dataPos == prePos, DLedgerResponseCode.DISK_ERROR, null);
            DLedgerEntryCoder.encodeIndex(dataPos, entrySize, 1, nextIndex, this.memberState.currTerm(), indexBuffer);
            long indexPos = this.indexFileList.append(indexBuffer.array(), 0, indexBuffer.remaining(), false);
            PreConditions.check(indexPos == entry.getIndex() * 32L, DLedgerResponseCode.DISK_ERROR, null);
            if (logger.isDebugEnabled()) {
                logger.info("[{}] Append as Leader {} {}", new Object[]{this.memberState.getSelfId(), entry.getIndex(), entry.getBody().length});
            }
            ++this.ledgerEndIndex;
            this.ledgerEndTerm = this.memberState.currTerm();
            if (this.ledgerBeginIndex == -1L) {
                this.ledgerBeginIndex = this.ledgerEndIndex;
            }
            this.updateLedgerEndIndexAndTerm();
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long truncate(DLedgerEntry entry, long leaderTerm, String leaderId) {
        PreConditions.check(this.memberState.isFollower(), DLedgerResponseCode.NOT_FOLLOWER, null);
        ByteBuffer dataBuffer = this.localEntryBuffer.get();
        ByteBuffer indexBuffer = this.localIndexBuffer.get();
        DLedgerEntryCoder.encode(entry, dataBuffer);
        int entrySize = dataBuffer.remaining();
        MemberState memberState = this.memberState;
        synchronized (memberState) {
            long truncatePos;
            boolean existedEntry;
            PreConditions.check(this.memberState.isFollower(), DLedgerResponseCode.NOT_FOLLOWER, "role=%s", new Object[]{this.memberState.getRole()});
            PreConditions.check(leaderTerm == this.memberState.currTerm(), DLedgerResponseCode.INCONSISTENT_TERM, "term %d != %d", leaderTerm, this.memberState.currTerm());
            PreConditions.check(leaderId.equals(this.memberState.getLeaderId()), DLedgerResponseCode.INCONSISTENT_LEADER, "leaderId %s != %s", leaderId, this.memberState.getLeaderId());
            try {
                DLedgerEntry tmp = this.get(entry.getIndex());
                existedEntry = entry.equals(tmp);
            }
            catch (Throwable ignored) {
                existedEntry = false;
            }
            long l = truncatePos = existedEntry ? entry.getPos() + (long)entry.getSize() : entry.getPos();
            if (truncatePos != this.dataFileList.getMaxWrotePosition()) {
                logger.warn("[TRUNCATE]leaderId={} index={} truncatePos={} != maxPos={}, this is usually happened on the old leader", new Object[]{leaderId, entry.getIndex(), truncatePos, this.dataFileList.getMaxWrotePosition()});
            }
            this.dataFileList.truncateOffset(truncatePos);
            if (this.dataFileList.getMaxWrotePosition() != truncatePos) {
                logger.warn("[TRUNCATE] rebuild for data wrotePos: {} != truncatePos: {}", (Object)this.dataFileList.getMaxWrotePosition(), (Object)truncatePos);
                PreConditions.check(this.dataFileList.rebuildWithPos(truncatePos), DLedgerResponseCode.DISK_ERROR, "rebuild data truncatePos=%d", truncatePos);
            }
            this.reviseDataFileListFlushedWhere(truncatePos);
            if (!existedEntry) {
                long dataPos = this.dataFileList.append(dataBuffer.array(), 0, dataBuffer.remaining());
                PreConditions.check(dataPos == entry.getPos(), DLedgerResponseCode.DISK_ERROR, " %d != %d", dataPos, entry.getPos());
            }
            long truncateIndexOffset = entry.getIndex() * 32L;
            this.indexFileList.truncateOffset(truncateIndexOffset);
            if (this.indexFileList.getMaxWrotePosition() != truncateIndexOffset) {
                logger.warn("[TRUNCATE] rebuild for index wrotePos: {} != truncatePos: {}", (Object)this.indexFileList.getMaxWrotePosition(), (Object)truncateIndexOffset);
                PreConditions.check(this.indexFileList.rebuildWithPos(truncateIndexOffset), DLedgerResponseCode.DISK_ERROR, "rebuild index truncatePos=%d", truncateIndexOffset);
            }
            this.reviseIndexFileListFlushedWhere(truncateIndexOffset);
            DLedgerEntryCoder.encodeIndex(entry.getPos(), entrySize, entry.getMagic(), entry.getIndex(), entry.getTerm(), indexBuffer);
            long indexPos = this.indexFileList.append(indexBuffer.array(), 0, indexBuffer.remaining(), false);
            PreConditions.check(indexPos == entry.getIndex() * 32L, DLedgerResponseCode.DISK_ERROR, null);
            this.ledgerEndTerm = entry.getTerm();
            this.ledgerEndIndex = entry.getIndex();
            this.reviseLedgerBeginIndex();
            this.updateLedgerEndIndexAndTerm();
            return entry.getIndex();
        }
    }

    private void reviseDataFileListFlushedWhere(long truncatePos) {
        long offset = this.calculateWherePosition(this.dataFileList, truncatePos);
        logger.info("Revise dataFileList flushedWhere from {} to {}", (Object)this.dataFileList.getFlushedWhere(), (Object)offset);
        this.dataFileList.updateWherePosition(offset);
    }

    private void reviseIndexFileListFlushedWhere(long truncateIndexOffset) {
        long offset = this.calculateWherePosition(this.indexFileList, truncateIndexOffset);
        logger.info("Revise indexFileList flushedWhere from {} to {}", (Object)this.indexFileList.getFlushedWhere(), (Object)offset);
        this.indexFileList.updateWherePosition(offset);
    }

    private long calculateWherePosition(MmapFileList mappedFileList, long continuedBeginOffset) {
        if (mappedFileList.getFlushedWhere() == 0L) {
            return 0L;
        }
        if (mappedFileList.getMappedFiles().isEmpty()) {
            return continuedBeginOffset;
        }
        if (mappedFileList.getFlushedWhere() < mappedFileList.getFirstMappedFile().getFileFromOffset()) {
            return mappedFileList.getFirstMappedFile().getFileFromOffset();
        }
        if (mappedFileList.getFlushedWhere() > continuedBeginOffset) {
            return continuedBeginOffset;
        }
        return mappedFileList.getFlushedWhere();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DLedgerEntry appendAsFollower(DLedgerEntry entry, long leaderTerm, String leaderId) {
        PreConditions.check(this.memberState.isFollower(), DLedgerResponseCode.NOT_FOLLOWER, "role=%s", new Object[]{this.memberState.getRole()});
        PreConditions.check(!this.isDiskFull, DLedgerResponseCode.DISK_FULL);
        ByteBuffer dataBuffer = this.localEntryBuffer.get();
        ByteBuffer indexBuffer = this.localIndexBuffer.get();
        DLedgerEntryCoder.encode(entry, dataBuffer);
        int entrySize = dataBuffer.remaining();
        MemberState memberState = this.memberState;
        synchronized (memberState) {
            PreConditions.check(this.memberState.isFollower(), DLedgerResponseCode.NOT_FOLLOWER, "role=%s", new Object[]{this.memberState.getRole()});
            long nextIndex = this.ledgerEndIndex + 1L;
            PreConditions.check(nextIndex == entry.getIndex(), DLedgerResponseCode.INCONSISTENT_INDEX, null);
            PreConditions.check(leaderTerm == this.memberState.currTerm(), DLedgerResponseCode.INCONSISTENT_TERM, null);
            PreConditions.check(leaderId.equals(this.memberState.getLeaderId()), DLedgerResponseCode.INCONSISTENT_LEADER, null);
            long dataPos = this.dataFileList.append(dataBuffer.array(), 0, dataBuffer.remaining());
            PreConditions.check(dataPos == entry.getPos(), DLedgerResponseCode.DISK_ERROR, "%d != %d", dataPos, entry.getPos());
            DLedgerEntryCoder.encodeIndex(dataPos, entrySize, entry.getMagic(), entry.getIndex(), entry.getTerm(), indexBuffer);
            long indexPos = this.indexFileList.append(indexBuffer.array(), 0, indexBuffer.remaining(), false);
            PreConditions.check(indexPos == entry.getIndex() * 32L, DLedgerResponseCode.DISK_ERROR, null);
            this.ledgerEndTerm = entry.getTerm();
            this.ledgerEndIndex = entry.getIndex();
            if (this.ledgerBeginIndex == -1L) {
                this.ledgerBeginIndex = this.ledgerEndIndex;
            }
            this.updateLedgerEndIndexAndTerm();
            return entry;
        }
    }

    void persistCheckPoint() {
        try {
            Properties properties = new Properties();
            properties.put(END_INDEX_KEY, (Object)this.getLedgerEndIndex());
            properties.put(COMMITTED_INDEX_KEY, (Object)this.getCommittedIndex());
            String data = IOUtils.properties2String(properties);
            IOUtils.string2File(data, this.dLedgerConfig.getDefaultPath() + File.separator + CHECK_POINT_FILE);
        }
        catch (Throwable t) {
            logger.error("Persist checkpoint failed", t);
        }
    }

    Properties loadCheckPoint() {
        try {
            String data = IOUtils.file2String(this.dLedgerConfig.getDefaultPath() + File.separator + CHECK_POINT_FILE);
            Properties properties = IOUtils.string2Properties(data);
            return properties;
        }
        catch (Throwable t) {
            logger.error("Load checkpoint failed", t);
            return null;
        }
    }

    @Override
    public long getLedgerEndIndex() {
        return this.ledgerEndIndex;
    }

    @Override
    public long getLedgerBeginIndex() {
        return this.ledgerBeginIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DLedgerEntry get(Long index) {
        DLedgerEntry dLedgerEntry;
        this.indexCheck(index);
        SelectMmapBufferResult indexSbr = null;
        SelectMmapBufferResult dataSbr = null;
        try {
            indexSbr = this.indexFileList.getData(index * 32L, 32);
            PreConditions.check(indexSbr != null && indexSbr.getByteBuffer() != null, DLedgerResponseCode.DISK_ERROR, "Get null index for %d", index);
            indexSbr.getByteBuffer().getInt();
            long pos = indexSbr.getByteBuffer().getLong();
            int size = indexSbr.getByteBuffer().getInt();
            dataSbr = this.dataFileList.getData(pos, size);
            PreConditions.check(dataSbr != null && dataSbr.getByteBuffer() != null, DLedgerResponseCode.DISK_ERROR, "Get null data for %d", index);
            DLedgerEntry dLedgerEntry2 = DLedgerEntryCoder.decode(dataSbr.getByteBuffer());
            PreConditions.check(pos == dLedgerEntry2.getPos(), DLedgerResponseCode.DISK_ERROR, "%d != %d", pos, dLedgerEntry2.getPos());
            dLedgerEntry = dLedgerEntry2;
        }
        catch (Throwable throwable) {
            SelectMmapBufferResult.release(indexSbr);
            SelectMmapBufferResult.release(dataSbr);
            throw throwable;
        }
        SelectMmapBufferResult.release(indexSbr);
        SelectMmapBufferResult.release(dataSbr);
        return dLedgerEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Long, Integer> getEntryPosAndSize(Long index) {
        Pair<Long, Integer> pair;
        this.indexCheck(index);
        SelectMmapBufferResult indexSbr = null;
        try {
            indexSbr = this.indexFileList.getData(index * 32L, 32);
            PreConditions.check(indexSbr != null && indexSbr.getByteBuffer() != null, DLedgerResponseCode.DISK_ERROR, "Get null index for %d", index);
            indexSbr.getByteBuffer().getInt();
            long pos = indexSbr.getByteBuffer().getLong();
            int size = indexSbr.getByteBuffer().getInt();
            pair = new Pair<Long, Integer>(pos, size);
        }
        catch (Throwable throwable) {
            SelectMmapBufferResult.release(indexSbr);
            throw throwable;
        }
        SelectMmapBufferResult.release(indexSbr);
        return pair;
    }

    public void indexCheck(Long index) {
        PreConditions.check(index >= 0L, DLedgerResponseCode.INDEX_OUT_OF_RANGE, "%d should gt 0", index);
        PreConditions.check(index >= this.ledgerBeginIndex, DLedgerResponseCode.INDEX_LESS_THAN_LOCAL_BEGIN, "%d should be gt %d, ledgerBeginIndex may be revised", index, this.ledgerBeginIndex);
        PreConditions.check(index <= this.ledgerEndIndex, DLedgerResponseCode.INDEX_OUT_OF_RANGE, "%d should between %d-%d", index, this.ledgerBeginIndex, this.ledgerEndIndex);
    }

    @Override
    public long getCommittedIndex() {
        return this.committedIndex;
    }

    @Override
    public void updateCommittedIndex(long term, long newCommittedIndex) {
        Pair<Long, Integer> posAndSize;
        if (newCommittedIndex == -1L || this.ledgerEndIndex == -1L || term < this.memberState.currTerm() || newCommittedIndex == this.committedIndex) {
            return;
        }
        if (newCommittedIndex < this.committedIndex || newCommittedIndex < this.ledgerBeginIndex) {
            logger.warn("[MONITOR]Skip update committed index for new={} < old={} or new={} < beginIndex={}", new Object[]{newCommittedIndex, this.committedIndex, newCommittedIndex, this.ledgerBeginIndex});
            return;
        }
        long endIndex = this.ledgerEndIndex;
        if (newCommittedIndex > endIndex) {
            newCommittedIndex = endIndex;
        }
        PreConditions.check((posAndSize = this.getEntryPosAndSize(newCommittedIndex)) != null, DLedgerResponseCode.DISK_ERROR);
        this.committedIndex = newCommittedIndex;
        this.committedPos = posAndSize.getKey() + (long)posAndSize.getValue().intValue();
    }

    @Override
    public long getLedgerEndTerm() {
        return this.ledgerEndTerm;
    }

    public long getCommittedPos() {
        return this.committedPos;
    }

    public void addAppendHook(AppendHook writeHook) {
        if (!this.appendHooks.contains(writeHook)) {
            this.appendHooks.add(writeHook);
        }
    }

    @Override
    public MemberState getMemberState() {
        return this.memberState;
    }

    public MmapFileList getDataFileList() {
        return this.dataFileList;
    }

    public MmapFileList getIndexFileList() {
        return this.indexFileList;
    }

    public Set<String> getFullStorePaths() {
        return this.fullStorePaths;
    }

    public void setFullStorePaths(Set<String> fullStorePaths) {
        this.fullStorePaths = fullStorePaths;
    }

    public void shutdownFlushService() {
        this.flushDataService.shutdown();
    }

    public void setEnableCleanSpaceService(boolean enableCleanSpaceService) {
        this.enableCleanSpaceService = enableCleanSpaceService;
    }

    class CleanSpaceService
    extends ShutdownAbleThread {
        double storeBaseRatio;
        double dataRatio;

        public CleanSpaceService(String name, Logger logger) {
            super(name, logger);
            this.storeBaseRatio = DLedgerUtils.getDiskPartitionSpaceUsedPercent(DLedgerMmapFileStore.this.dLedgerConfig.getStoreBaseDir());
            this.dataRatio = this.calcDataStorePathPhysicRatio();
        }

        @Override
        public void doWork() {
            try {
                this.storeBaseRatio = DLedgerUtils.getDiskPartitionSpaceUsedPercent(DLedgerMmapFileStore.this.dLedgerConfig.getStoreBaseDir());
                this.dataRatio = this.calcDataStorePathPhysicRatio();
                long hourOfMs = 3600000L;
                long fileReservedTimeMs = (long)DLedgerMmapFileStore.this.dLedgerConfig.getFileReservedHours() * hourOfMs;
                if (fileReservedTimeMs < hourOfMs) {
                    this.logger.warn("The fileReservedTimeMs={} is smaller than hourOfMs={}", (Object)fileReservedTimeMs, (Object)hourOfMs);
                    fileReservedTimeMs = hourOfMs;
                }
                DLedgerMmapFileStore.this.isDiskFull = this.isNeedForbiddenWrite();
                boolean timeUp = this.isTimeToDelete();
                boolean checkExpired = this.isNeedCheckExpired();
                boolean forceClean = this.isNeedForceClean();
                boolean enableForceClean = DLedgerMmapFileStore.this.dLedgerConfig.isEnableDiskForceClean();
                int intervalForcibly = 120000;
                if (timeUp || checkExpired) {
                    int count = DLedgerMmapFileStore.this.getDataFileList().deleteExpiredFileByTime(fileReservedTimeMs, 100, intervalForcibly, forceClean && enableForceClean);
                    if (count > 0 || forceClean && enableForceClean || DLedgerMmapFileStore.this.isDiskFull) {
                        this.logger.info("Clean space count={} timeUp={} checkExpired={} forceClean={} enableForceClean={} diskFull={} storeBaseRatio={} dataRatio={}", new Object[]{count, timeUp, checkExpired, forceClean, enableForceClean, DLedgerMmapFileStore.this.isDiskFull, this.storeBaseRatio, this.dataRatio});
                    }
                    if (count > 0) {
                        DLedgerMmapFileStore.this.reviseLedgerBeginIndex();
                    }
                }
                DLedgerMmapFileStore.this.getDataFileList().retryDeleteFirstFile(intervalForcibly);
                this.waitForRunning(100L);
            }
            catch (Throwable t) {
                this.logger.info("Error in {}", (Object)this.getName(), (Object)t);
                DLedgerUtils.sleep(200L);
            }
        }

        private boolean isTimeToDelete() {
            String when = DLedgerMmapFileStore.this.dLedgerConfig.getDeleteWhen();
            return DLedgerUtils.isItTimeToDo(when);
        }

        private boolean isNeedCheckExpired() {
            return this.storeBaseRatio > (double)DLedgerMmapFileStore.this.dLedgerConfig.getDiskSpaceRatioToCheckExpired() || this.dataRatio > (double)DLedgerMmapFileStore.this.dLedgerConfig.getDiskSpaceRatioToCheckExpired();
        }

        private boolean isNeedForceClean() {
            return this.storeBaseRatio > (double)DLedgerMmapFileStore.this.dLedgerConfig.getDiskSpaceRatioToForceClean() || this.dataRatio > (double)DLedgerMmapFileStore.this.dLedgerConfig.getDiskSpaceRatioToForceClean();
        }

        private boolean isNeedForbiddenWrite() {
            return this.storeBaseRatio > (double)DLedgerMmapFileStore.this.dLedgerConfig.getDiskFullRatio() || this.dataRatio > (double)DLedgerMmapFileStore.this.dLedgerConfig.getDiskFullRatio();
        }

        public double calcDataStorePathPhysicRatio() {
            HashSet<String> fullStorePath = new HashSet<String>();
            String storePath = DLedgerMmapFileStore.this.dLedgerConfig.getDataStorePath();
            String[] paths = storePath.trim().split(DLedgerConfig.MULTI_PATH_SPLITTER);
            double minPhysicRatio = 100.0;
            for (String path : paths) {
                double physicRatio = DLedgerUtils.isPathExists(path) ? DLedgerUtils.getDiskPartitionSpaceUsedPercent(path) : -1.0;
                minPhysicRatio = Math.min(minPhysicRatio, physicRatio);
                if (!(physicRatio > (double)DLedgerMmapFileStore.this.dLedgerConfig.getDiskSpaceRatioToForceClean())) continue;
                fullStorePath.add(path);
            }
            DLedgerMmapFileStore.this.setFullStorePaths(fullStorePath);
            return minPhysicRatio;
        }
    }

    class FlushDataService
    extends ShutdownAbleThread {
        public FlushDataService(String name, Logger logger) {
            super(name, logger);
        }

        @Override
        public void doWork() {
            try {
                long start = System.currentTimeMillis();
                DLedgerMmapFileStore.this.dataFileList.flush(0);
                DLedgerMmapFileStore.this.indexFileList.flush(0);
                long elapsed = DLedgerUtils.elapsed(start);
                if (elapsed > 500L) {
                    this.logger.info("Flush data cost={} ms", (Object)elapsed);
                }
                if (DLedgerUtils.elapsed(DLedgerMmapFileStore.this.lastCheckPointTimeMs) > DLedgerMmapFileStore.this.dLedgerConfig.getCheckPointInterval()) {
                    DLedgerMmapFileStore.this.persistCheckPoint();
                    DLedgerMmapFileStore.this.lastCheckPointTimeMs = System.currentTimeMillis();
                }
                this.waitForRunning(DLedgerMmapFileStore.this.dLedgerConfig.getFlushFileInterval());
            }
            catch (Throwable t) {
                this.logger.info("Error in {}", (Object)this.getName(), (Object)t);
                DLedgerUtils.sleep(200L);
            }
        }
    }

    public static interface AppendHook {
        public void doHook(DLedgerEntry var1, ByteBuffer var2, int var3);
    }
}

