/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.statictopic;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.rocketmq.common.statictopic.LogicQueueMappingItem;
import org.apache.rocketmq.common.statictopic.TopicQueueMappingInfo;

public class TopicQueueMappingDetail
extends TopicQueueMappingInfo {
    private ConcurrentMap<Integer, List<LogicQueueMappingItem>> hostedQueues = new ConcurrentHashMap<Integer, List<LogicQueueMappingItem>>();

    public TopicQueueMappingDetail() {
    }

    public TopicQueueMappingDetail(String topic, int totalQueues, String bname, long epoch) {
        super(topic, totalQueues, bname, epoch);
    }

    public static boolean putMappingInfo(TopicQueueMappingDetail mappingDetail, Integer globalId, List<LogicQueueMappingItem> mappingInfo) {
        if (mappingInfo.isEmpty()) {
            return true;
        }
        mappingDetail.hostedQueues.put(globalId, mappingInfo);
        return true;
    }

    public static List<LogicQueueMappingItem> getMappingInfo(TopicQueueMappingDetail mappingDetail, Integer globalId) {
        return (List)mappingDetail.hostedQueues.get(globalId);
    }

    public static ConcurrentMap<Integer, Integer> buildIdMap(TopicQueueMappingDetail mappingDetail, int level) {
        assert (level == 0);
        if (mappingDetail.hostedQueues == null || mappingDetail.hostedQueues.isEmpty()) {
            return new ConcurrentHashMap<Integer, Integer>();
        }
        ConcurrentHashMap<Integer, Integer> tmpIdMap = new ConcurrentHashMap<Integer, Integer>();
        for (Map.Entry entry : mappingDetail.hostedQueues.entrySet()) {
            LogicQueueMappingItem curr;
            Integer globalId = (Integer)entry.getKey();
            List items = (List)entry.getValue();
            if (level != 0 || items.size() < 1 || !mappingDetail.bname.equals((curr = (LogicQueueMappingItem)((Object)items.get(items.size() - 1))).getBname())) continue;
            tmpIdMap.put(globalId, curr.getQueueId());
        }
        return tmpIdMap;
    }

    public static long computeMaxOffsetFromMapping(TopicQueueMappingDetail mappingDetail, Integer globalId) {
        List<LogicQueueMappingItem> mappingItems = TopicQueueMappingDetail.getMappingInfo(mappingDetail, globalId);
        if (mappingItems == null || mappingItems.isEmpty()) {
            return -1L;
        }
        LogicQueueMappingItem item = mappingItems.get(mappingItems.size() - 1);
        return item.computeMaxStaticQueueOffset();
    }

    public static TopicQueueMappingInfo cloneAsMappingInfo(TopicQueueMappingDetail mappingDetail) {
        TopicQueueMappingInfo topicQueueMappingInfo = new TopicQueueMappingInfo(mappingDetail.topic, mappingDetail.totalQueues, mappingDetail.bname, mappingDetail.epoch);
        topicQueueMappingInfo.currIdMap = TopicQueueMappingDetail.buildIdMap(mappingDetail, 0);
        return topicQueueMappingInfo;
    }

    public static boolean checkIfAsPhysical(TopicQueueMappingDetail mappingDetail, Integer globalId) {
        List<LogicQueueMappingItem> mappingItems = TopicQueueMappingDetail.getMappingInfo(mappingDetail, globalId);
        return mappingItems == null || mappingItems.size() == 1 && mappingItems.get(0).getLogicOffset() == 0L;
    }

    public ConcurrentMap<Integer, List<LogicQueueMappingItem>> getHostedQueues() {
        return this.hostedQueues;
    }

    public void setHostedQueues(ConcurrentMap<Integer, List<LogicQueueMappingItem>> hostedQueues) {
        this.hostedQueues = hostedQueues;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TopicQueueMappingDetail)) {
            return false;
        }
        TopicQueueMappingDetail that = (TopicQueueMappingDetail)((Object)o);
        return new EqualsBuilder().append(this.hostedQueues, that.hostedQueues).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.hostedQueues).toHashCode();
    }

    @Override
    public String toString() {
        return "TopicQueueMappingDetail{hostedQueues=" + this.hostedQueues + ", topic='" + this.topic + '\'' + ", totalQueues=" + this.totalQueues + ", bname='" + this.bname + '\'' + ", epoch=" + this.epoch + ", dirty=" + this.dirty + ", currIdMap=" + this.currIdMap + '}';
    }
}

