/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.processor;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.client.ConsumerGroupInfo;
import org.apache.rocketmq.broker.filter.ConsumerFilterData;
import org.apache.rocketmq.broker.filter.ConsumerFilterManager;
import org.apache.rocketmq.broker.filter.ExpressionForRetryMessageFilter;
import org.apache.rocketmq.broker.filter.ExpressionMessageFilter;
import org.apache.rocketmq.broker.mqtrace.AbortProcessException;
import org.apache.rocketmq.broker.mqtrace.ConsumeMessageContext;
import org.apache.rocketmq.broker.mqtrace.ConsumeMessageHook;
import org.apache.rocketmq.broker.plugin.PullMessageResultHandler;
import org.apache.rocketmq.broker.processor.DefaultPullMessageResultHandler;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.constant.PermName;
import org.apache.rocketmq.common.filter.ExpressionType;
import org.apache.rocketmq.common.filter.FilterAPI;
import org.apache.rocketmq.common.help.FAQUrl;
import org.apache.rocketmq.common.protocol.NamespaceUtil;
import org.apache.rocketmq.common.protocol.header.PullMessageRequestHeader;
import org.apache.rocketmq.common.protocol.header.PullMessageResponseHeader;
import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.apache.rocketmq.common.protocol.heartbeat.SubscriptionData;
import org.apache.rocketmq.common.rpc.RpcClientUtils;
import org.apache.rocketmq.common.rpc.RpcRequest;
import org.apache.rocketmq.common.rpc.RpcRequestHeader;
import org.apache.rocketmq.common.rpc.RpcResponse;
import org.apache.rocketmq.common.rpc.TopicRequestHeader;
import org.apache.rocketmq.common.statictopic.LogicQueueMappingItem;
import org.apache.rocketmq.common.statictopic.TopicQueueMappingContext;
import org.apache.rocketmq.common.statictopic.TopicQueueMappingDetail;
import org.apache.rocketmq.common.statictopic.TopicQueueMappingUtils;
import org.apache.rocketmq.common.subscription.SubscriptionGroupConfig;
import org.apache.rocketmq.common.sysflag.PullSysFlag;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.netty.RequestTask;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.store.GetMessageResult;
import org.apache.rocketmq.store.GetMessageStatus;
import org.apache.rocketmq.store.MessageFilter;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.stats.BrokerStatsManager;

public class PullMessageProcessor
implements NettyRequestProcessor {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger((String)"RocketmqBroker");
    private List<ConsumeMessageHook> consumeMessageHookList;
    private PullMessageResultHandler pullMessageResultHandler;
    private final BrokerController brokerController;

    public PullMessageProcessor(BrokerController brokerController) {
        this.brokerController = brokerController;
        this.pullMessageResultHandler = new DefaultPullMessageResultHandler(brokerController);
    }

    private RemotingCommand rewriteRequestForStaticTopic(PullMessageRequestHeader requestHeader, TopicQueueMappingContext mappingContext) {
        try {
            if (mappingContext.getMappingDetail() == null) {
                return null;
            }
            TopicQueueMappingDetail mappingDetail = mappingContext.getMappingDetail();
            String topic = mappingContext.getTopic();
            Integer globalId = mappingContext.getGlobalId();
            if (!mappingContext.isLeader()) {
                return RemotingCommand.buildErrorResponse((int)501, (String)String.format("%s-%d cannot find mapping item in request process of current broker %s", topic, globalId, mappingDetail.getBname()));
            }
            Long globalOffset = requestHeader.getQueueOffset();
            LogicQueueMappingItem mappingItem = TopicQueueMappingUtils.findLogicQueueMappingItem((List)mappingContext.getMappingItemList(), (long)globalOffset, (boolean)true);
            mappingContext.setCurrentItem(mappingItem);
            if (globalOffset < mappingItem.getLogicOffset()) {
                // empty if block
            }
            String bname = mappingItem.getBname();
            Integer phyQueueId = mappingItem.getQueueId();
            Long phyQueueOffset = mappingItem.computePhysicalQueueOffset(globalOffset.longValue());
            requestHeader.setQueueId(phyQueueId);
            requestHeader.setQueueOffset(phyQueueOffset);
            if (mappingItem.checkIfEndOffsetDecided() && requestHeader.getMaxMsgNums() != null) {
                requestHeader.setMaxMsgNums(Integer.valueOf((int)Math.min(mappingItem.getEndOffset() - mappingItem.getStartOffset(), (long)requestHeader.getMaxMsgNums().intValue())));
            }
            if (mappingDetail.getBname().equals(bname)) {
                return null;
            }
            int sysFlag = requestHeader.getSysFlag();
            requestHeader.setLo(Boolean.valueOf(false));
            requestHeader.setBname(bname);
            sysFlag = PullSysFlag.clearSuspendFlag((int)sysFlag);
            sysFlag = PullSysFlag.clearCommitOffsetFlag((int)sysFlag);
            requestHeader.setSysFlag(Integer.valueOf(sysFlag));
            RpcRequest rpcRequest = new RpcRequest(11, (RpcRequestHeader)requestHeader, null);
            RpcResponse rpcResponse = (RpcResponse)this.brokerController.getBrokerOuterAPI().getRpcClient().invoke(rpcRequest, this.brokerController.getBrokerConfig().getForwardTimeout()).get();
            if (rpcResponse.getException() != null) {
                throw rpcResponse.getException();
            }
            PullMessageResponseHeader responseHeader = (PullMessageResponseHeader)rpcResponse.getHeader();
            RemotingCommand rewriteResult = this.rewriteResponseForStaticTopic(requestHeader, responseHeader, mappingContext, rpcResponse.getCode());
            if (rewriteResult != null) {
                return rewriteResult;
            }
            return RpcClientUtils.createCommandForRpcResponse((RpcResponse)rpcResponse);
        }
        catch (Throwable t) {
            return RemotingCommand.buildErrorResponse((int)1, (String)t.getMessage());
        }
    }

    private RemotingCommand rewriteResponseForStaticTopic(PullMessageRequestHeader requestHeader, PullMessageResponseHeader responseHeader, TopicQueueMappingContext mappingContext, int code) {
        try {
            if (mappingContext.getMappingDetail() == null) {
                return null;
            }
            TopicQueueMappingDetail mappingDetail = mappingContext.getMappingDetail();
            LogicQueueMappingItem leaderItem = mappingContext.getLeaderItem();
            LogicQueueMappingItem currentItem = mappingContext.getCurrentItem();
            LogicQueueMappingItem earlistItem = TopicQueueMappingUtils.findLogicQueueMappingItem((List)mappingContext.getMappingItemList(), (long)0L, (boolean)true);
            assert (currentItem.getLogicOffset() >= 0L);
            long requestOffset = requestHeader.getQueueOffset();
            long nextBeginOffset = responseHeader.getNextBeginOffset();
            long minOffset = responseHeader.getMinOffset();
            long maxOffset = responseHeader.getMaxOffset();
            int responseCode = code;
            if (code != 0) {
                LogicQueueMappingItem nextItem;
                boolean isRevised = false;
                if (leaderItem.getGen() == currentItem.getGen()) {
                    if (requestOffset > maxOffset) {
                        if (code == 21) {
                            responseCode = 21;
                            nextBeginOffset = maxOffset;
                        } else {
                            responseCode = code;
                        }
                    } else if (requestOffset < minOffset) {
                        nextBeginOffset = minOffset;
                        responseCode = 20;
                    } else {
                        responseCode = code;
                    }
                }
                if (earlistItem.getGen() == currentItem.getGen()) {
                    if (requestOffset < minOffset) {
                        if (code == 21) {
                            responseCode = 21;
                            nextBeginOffset = minOffset;
                        } else {
                            responseCode = 21;
                            nextBeginOffset = minOffset;
                        }
                    } else if (requestOffset >= maxOffset) {
                        nextItem = TopicQueueMappingUtils.findNext((List)mappingContext.getMappingItemList(), (LogicQueueMappingItem)currentItem, (boolean)true);
                        if (nextItem != null) {
                            isRevised = true;
                            currentItem = nextItem;
                            nextBeginOffset = currentItem.getStartOffset();
                            maxOffset = minOffset = currentItem.getStartOffset();
                            responseCode = 20;
                        } else {
                            responseCode = 19;
                        }
                    } else {
                        responseCode = code;
                    }
                }
                if (!isRevised && leaderItem.getGen() != currentItem.getGen() && earlistItem.getGen() != currentItem.getGen()) {
                    if (requestOffset < minOffset) {
                        nextBeginOffset = minOffset;
                        responseCode = 20;
                    } else if (requestOffset >= maxOffset) {
                        nextItem = TopicQueueMappingUtils.findNext((List)mappingContext.getMappingItemList(), (LogicQueueMappingItem)currentItem, (boolean)true);
                        if (nextItem != null) {
                            currentItem = nextItem;
                            nextBeginOffset = currentItem.getStartOffset();
                            maxOffset = minOffset = currentItem.getStartOffset();
                            responseCode = 20;
                        } else {
                            responseCode = 19;
                        }
                    } else {
                        responseCode = code;
                    }
                }
            }
            if (currentItem.checkIfEndOffsetDecided() && nextBeginOffset >= currentItem.getEndOffset()) {
                nextBeginOffset = currentItem.getEndOffset();
            }
            responseHeader.setNextBeginOffset(Long.valueOf(currentItem.computeStaticQueueOffsetStrictly(nextBeginOffset)));
            responseHeader.setMinOffset(Long.valueOf(currentItem.computeStaticQueueOffsetStrictly(Math.max(currentItem.getStartOffset(), minOffset))));
            responseHeader.setMaxOffset(Long.valueOf(Math.max(currentItem.computeStaticQueueOffsetStrictly(maxOffset), TopicQueueMappingDetail.computeMaxOffsetFromMapping((TopicQueueMappingDetail)mappingDetail, (Integer)mappingContext.getGlobalId()))));
            responseHeader.setOffsetDelta(Long.valueOf(currentItem.computeOffsetDelta()));
            if (code != 0) {
                return RemotingCommand.createResponseCommandWithHeader((int)responseCode, (CommandCustomHeader)responseHeader);
            }
            return null;
        }
        catch (Throwable t) {
            return RemotingCommand.buildErrorResponse((int)1, (String)t.getMessage());
        }
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        return this.processRequest(ctx.channel(), request, true);
    }

    public boolean rejectRequest() {
        return !this.brokerController.getBrokerConfig().isSlaveReadEnable() && this.brokerController.getMessageStoreConfig().getBrokerRole() == BrokerRole.SLAVE;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RemotingCommand processRequest(Channel channel, RemotingCommand request, boolean brokerAllowSuspend) throws RemotingCommandException {
        void var14_18;
        ConsumerFilterData consumerFilterData;
        SubscriptionData subscriptionData;
        TopicQueueMappingContext mappingContext;
        TopicConfig topicConfig;
        boolean hasCommitOffsetFlag;
        SubscriptionGroupConfig subscriptionGroupConfig;
        PullMessageRequestHeader requestHeader;
        PullMessageResponseHeader responseHeader;
        RemotingCommand response;
        block55: {
            response = RemotingCommand.createResponseCommand(PullMessageResponseHeader.class);
            responseHeader = (PullMessageResponseHeader)response.readCustomHeader();
            requestHeader = (PullMessageRequestHeader)request.decodeCommandCustomHeader(PullMessageRequestHeader.class);
            response.setOpaque(request.getOpaque());
            LOGGER.debug("receive PullMessage request command, {}", (Object)request);
            if (!PermName.isReadable((int)this.brokerController.getBrokerConfig().getBrokerPermission())) {
                response.setCode(16);
                response.setRemark(String.format("the broker[%s] pulling message is forbidden", this.brokerController.getBrokerConfig().getBrokerIP1()));
                return response;
            }
            if (request.getCode() == 361 && !this.brokerController.getBrokerConfig().isLitePullMessageEnable()) {
                response.setCode(16);
                response.setRemark("the broker[" + this.brokerController.getBrokerConfig().getBrokerIP1() + "] for lite pull consumer is forbidden");
                return response;
            }
            subscriptionGroupConfig = this.brokerController.getSubscriptionGroupManager().findSubscriptionGroupConfig(requestHeader.getConsumerGroup());
            if (null == subscriptionGroupConfig) {
                response.setCode(26);
                response.setRemark(String.format("subscription group [%s] does not exist, %s", requestHeader.getConsumerGroup(), FAQUrl.suggestTodo((String)"http://rocketmq.apache.org/docs/faq/")));
                return response;
            }
            if (!subscriptionGroupConfig.isConsumeEnable()) {
                response.setCode(16);
                responseHeader.setForbiddenType(Integer.valueOf(2));
                response.setRemark("subscription group no permission, " + requestHeader.getConsumerGroup());
                return response;
            }
            hasCommitOffsetFlag = PullSysFlag.hasCommitOffsetFlag((int)requestHeader.getSysFlag());
            boolean hasSubscriptionFlag = PullSysFlag.hasSubscriptionFlag((int)requestHeader.getSysFlag());
            topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(requestHeader.getTopic());
            if (null == topicConfig) {
                LOGGER.error("the topic {} not exist, consumer: {}", (Object)requestHeader.getTopic(), (Object)RemotingHelper.parseChannelRemoteAddr((Channel)channel));
                response.setCode(17);
                response.setRemark(String.format("topic[%s] not exist, apply first please! %s", requestHeader.getTopic(), FAQUrl.suggestTodo((String)"http://rocketmq.apache.org/docs/faq/")));
                return response;
            }
            if (!PermName.isReadable((int)topicConfig.getPerm())) {
                response.setCode(16);
                responseHeader.setForbiddenType(Integer.valueOf(3));
                response.setRemark("the topic[" + requestHeader.getTopic() + "] pulling message is forbidden");
                return response;
            }
            mappingContext = this.brokerController.getTopicQueueMappingManager().buildTopicQueueMappingContext((TopicRequestHeader)requestHeader, false);
            RemotingCommand rewriteResult = this.rewriteRequestForStaticTopic(requestHeader, mappingContext);
            if (rewriteResult != null) {
                return rewriteResult;
            }
            if (requestHeader.getQueueId() < 0 || requestHeader.getQueueId() >= topicConfig.getReadQueueNums()) {
                String errorInfo = String.format("queueId[%d] is illegal, topic:[%s] topicConfig.readQueueNums:[%d] consumer:[%s]", requestHeader.getQueueId(), requestHeader.getTopic(), topicConfig.getReadQueueNums(), channel.remoteAddress());
                LOGGER.warn(errorInfo);
                response.setCode(1);
                response.setRemark(errorInfo);
                return response;
            }
            subscriptionData = null;
            consumerFilterData = null;
            if (hasSubscriptionFlag) {
                try {
                    subscriptionData = FilterAPI.build((String)requestHeader.getTopic(), (String)requestHeader.getSubscription(), (String)requestHeader.getExpressionType());
                    if (!ExpressionType.isTagType((String)subscriptionData.getExpressionType())) {
                        consumerFilterData = ConsumerFilterManager.build(requestHeader.getTopic(), requestHeader.getConsumerGroup(), requestHeader.getSubscription(), requestHeader.getExpressionType(), requestHeader.getSubVersion());
                        assert (consumerFilterData != null);
                    }
                    break block55;
                }
                catch (Exception exception) {
                    LOGGER.warn("Parse the consumer's subscription[{}] failed, group: {}", (Object)requestHeader.getSubscription(), (Object)requestHeader.getConsumerGroup());
                    response.setCode(23);
                    response.setRemark("parse the consumer's subscription failed");
                    return response;
                }
            }
            ConsumerGroupInfo consumerGroupInfo = this.brokerController.getConsumerManager().getConsumerGroupInfo(requestHeader.getConsumerGroup());
            if (null == consumerGroupInfo) {
                LOGGER.warn("the consumer's group info not exist, group: {}", (Object)requestHeader.getConsumerGroup());
                response.setCode(24);
                response.setRemark("the consumer's group info not exist" + FAQUrl.suggestTodo((String)"http://rocketmq.apache.org/docs/faq/"));
                return response;
            }
            if (!subscriptionGroupConfig.isConsumeBroadcastEnable() && consumerGroupInfo.getMessageModel() == MessageModel.BROADCASTING) {
                response.setCode(16);
                responseHeader.setForbiddenType(Integer.valueOf(4));
                response.setRemark("the consumer group[" + requestHeader.getConsumerGroup() + "] can not consume by broadcast way");
                return response;
            }
            boolean readForbidden = this.brokerController.getSubscriptionGroupManager().getForbidden(subscriptionGroupConfig.getGroupName(), requestHeader.getTopic(), 2);
            if (readForbidden) {
                response.setCode(16);
                responseHeader.setForbiddenType(Integer.valueOf(5));
                response.setRemark("the consumer group[" + requestHeader.getConsumerGroup() + "] is forbidden for topic[" + requestHeader.getTopic() + "]");
                return response;
            }
            subscriptionData = consumerGroupInfo.findSubscriptionData(requestHeader.getTopic());
            if (null == subscriptionData) {
                LOGGER.warn("the consumer's subscription not exist, group: {}, topic:{}", (Object)requestHeader.getConsumerGroup(), (Object)requestHeader.getTopic());
                response.setCode(24);
                response.setRemark("the consumer's subscription not exist" + FAQUrl.suggestTodo((String)"http://rocketmq.apache.org/docs/faq/"));
                return response;
            }
            if (subscriptionData.getSubVersion() < requestHeader.getSubVersion()) {
                LOGGER.warn("The broker's subscription is not latest, group: {} {}", (Object)requestHeader.getConsumerGroup(), (Object)subscriptionData.getSubString());
                response.setCode(25);
                response.setRemark("the consumer's subscription not latest");
                return response;
            }
            if (!ExpressionType.isTagType((String)subscriptionData.getExpressionType())) {
                consumerFilterData = this.brokerController.getConsumerFilterManager().get(requestHeader.getTopic(), requestHeader.getConsumerGroup());
                if (consumerFilterData == null) {
                    response.setCode(27);
                    response.setRemark("The broker's consumer filter data is not exist!Your expression may be wrong!");
                    return response;
                }
                if (consumerFilterData.getClientVersion() < requestHeader.getSubVersion()) {
                    LOGGER.warn("The broker's consumer filter data is not latest, group: {}, topic: {}, serverV: {}, clientV: {}", new Object[]{requestHeader.getConsumerGroup(), requestHeader.getTopic(), consumerFilterData.getClientVersion(), requestHeader.getSubVersion()});
                    response.setCode(28);
                    response.setRemark("the consumer's consumer filter data not latest");
                    return response;
                }
            }
        }
        if (!ExpressionType.isTagType((String)subscriptionData.getExpressionType()) && !this.brokerController.getBrokerConfig().isEnablePropertyFilter()) {
            response.setCode(1);
            response.setRemark("The broker does not support consumer to filter message by " + subscriptionData.getExpressionType());
            return response;
        }
        if (this.brokerController.getBrokerConfig().isFilterSupportRetry()) {
            ExpressionForRetryMessageFilter expressionForRetryMessageFilter = new ExpressionForRetryMessageFilter(subscriptionData, consumerFilterData, this.brokerController.getConsumerFilterManager());
        } else {
            ExpressionMessageFilter expressionMessageFilter = new ExpressionMessageFilter(subscriptionData, consumerFilterData, this.brokerController.getConsumerFilterManager());
        }
        GetMessageResult getMessageResult = this.brokerController.getMessageStore().getMessage(requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueId().intValue(), requestHeader.getQueueOffset().longValue(), requestHeader.getMaxMsgNums().intValue(), (MessageFilter)var14_18);
        if (getMessageResult != null) {
            RemotingCommand rewriteResult;
            response.setRemark(getMessageResult.getStatus().name());
            responseHeader.setNextBeginOffset(Long.valueOf(getMessageResult.getNextBeginOffset()));
            responseHeader.setMinOffset(Long.valueOf(getMessageResult.getMinOffset()));
            responseHeader.setMaxOffset(Long.valueOf(getMessageResult.getMaxOffset()));
            responseHeader.setTopicSysFlag(Integer.valueOf(topicConfig.getTopicSysFlag()));
            responseHeader.setGroupSysFlag(Integer.valueOf(subscriptionGroupConfig.getGroupSysFlag()));
            switch (getMessageResult.getStatus()) {
                case FOUND: {
                    response.setCode(0);
                    break;
                }
                case MESSAGE_WAS_REMOVING: {
                    response.setCode(20);
                    break;
                }
                case NO_MATCHED_LOGIC_QUEUE: 
                case NO_MESSAGE_IN_QUEUE: {
                    if (0L != requestHeader.getQueueOffset()) {
                        response.setCode(21);
                        LOGGER.info("the broker stores no queue data, fix the request offset {} to {}, Topic: {} QueueId: {} Consumer Group: {}", new Object[]{requestHeader.getQueueOffset(), getMessageResult.getNextBeginOffset(), requestHeader.getTopic(), requestHeader.getQueueId(), requestHeader.getConsumerGroup()});
                        break;
                    }
                    response.setCode(19);
                    break;
                }
                case NO_MATCHED_MESSAGE: {
                    response.setCode(20);
                    break;
                }
                case OFFSET_FOUND_NULL: {
                    response.setCode(19);
                    break;
                }
                case OFFSET_OVERFLOW_BADLY: {
                    response.setCode(21);
                    LOGGER.info("the request offset: {} over flow badly, fix to {}, broker max offset: {}, consumer: {}", new Object[]{requestHeader.getQueueOffset(), getMessageResult.getNextBeginOffset(), getMessageResult.getMaxOffset(), channel.remoteAddress()});
                    break;
                }
                case OFFSET_OVERFLOW_ONE: {
                    response.setCode(19);
                    break;
                }
                case OFFSET_TOO_SMALL: {
                    response.setCode(21);
                    LOGGER.info("the request offset too small. group={}, topic={}, requestOffset={}, brokerMinOffset={}, clientIp={}", new Object[]{requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueOffset(), getMessageResult.getMinOffset(), channel.remoteAddress()});
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (this.brokerController.getBrokerConfig().isSlaveReadEnable() && !this.brokerController.getBrokerConfig().isInBrokerContainer()) {
                if (getMessageResult.isSuggestPullingFromSlave()) {
                    responseHeader.setSuggestWhichBrokerId(Long.valueOf(subscriptionGroupConfig.getWhichBrokerWhenConsumeSlowly()));
                } else {
                    responseHeader.setSuggestWhichBrokerId(Long.valueOf(subscriptionGroupConfig.getBrokerId()));
                }
            } else {
                responseHeader.setSuggestWhichBrokerId(Long.valueOf(0L));
            }
            if (this.brokerController.getBrokerConfig().getBrokerId() != 0L && !getMessageResult.isSuggestPullingFromSlave() && this.brokerController.getMinBrokerIdInGroup() == 0L) {
                LOGGER.debug("slave redirect pullRequest to master, topic: {}, queueId: {}, consumer group: {}, next: {}, min: {}, max: {}", new Object[]{requestHeader.getTopic(), requestHeader.getQueueId(), requestHeader.getConsumerGroup(), responseHeader.getNextBeginOffset(), responseHeader.getMinOffset(), responseHeader.getMaxOffset()});
                responseHeader.setSuggestWhichBrokerId(Long.valueOf(0L));
                if (!getMessageResult.getStatus().equals((Object)GetMessageStatus.FOUND)) {
                    response.setCode(20);
                }
            }
            if (this.hasConsumeMessageHook()) {
                String owner = (String)request.getExtFields().get("Owner");
                String authType = (String)request.getExtFields().get("AUTH_TYPE");
                String ownerParent = (String)request.getExtFields().get("OWNER_PARENT");
                String ownerSelf = (String)request.getExtFields().get("OWNER_SELF");
                ConsumeMessageContext context = new ConsumeMessageContext();
                context.setConsumerGroup(requestHeader.getConsumerGroup());
                context.setTopic(requestHeader.getTopic());
                context.setQueueId(requestHeader.getQueueId());
                context.setAccountAuthType(authType);
                context.setAccountOwnerParent(ownerParent);
                context.setAccountOwnerSelf(ownerSelf);
                context.setNamespace(NamespaceUtil.getNamespaceFromResource((String)requestHeader.getTopic()));
                switch (response.getCode()) {
                    case 0: {
                        int commercialBaseCount = this.brokerController.getBrokerConfig().getCommercialBaseCount();
                        int incValue = getMessageResult.getMsgCount4Commercial() * commercialBaseCount;
                        context.setCommercialRcvStats(BrokerStatsManager.StatsType.RCV_SUCCESS);
                        context.setCommercialRcvTimes(incValue);
                        context.setCommercialRcvSize(getMessageResult.getBufferTotalSize());
                        context.setCommercialOwner(owner);
                        context.setRcvStat(BrokerStatsManager.StatsType.RCV_SUCCESS);
                        context.setRcvMsgNum(getMessageResult.getMessageCount());
                        context.setRcvMsgSize(getMessageResult.getBufferTotalSize());
                        context.setCommercialRcvMsgNum(getMessageResult.getMsgCount4Commercial());
                        break;
                    }
                    case 19: {
                        if (brokerAllowSuspend) break;
                        context.setCommercialRcvStats(BrokerStatsManager.StatsType.RCV_EPOLLS);
                        context.setCommercialRcvTimes(1);
                        context.setCommercialOwner(owner);
                        context.setRcvStat(BrokerStatsManager.StatsType.RCV_EPOLLS);
                        context.setRcvMsgNum(0);
                        context.setRcvMsgSize(0);
                        context.setCommercialRcvMsgNum(0);
                        break;
                    }
                    case 20: 
                    case 21: {
                        context.setCommercialRcvStats(BrokerStatsManager.StatsType.RCV_EPOLLS);
                        context.setCommercialRcvTimes(1);
                        context.setCommercialOwner(owner);
                        context.setRcvStat(BrokerStatsManager.StatsType.RCV_EPOLLS);
                        context.setRcvMsgNum(0);
                        context.setRcvMsgSize(0);
                        context.setCommercialRcvMsgNum(0);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                try {
                    this.executeConsumeMessageHookBefore(context);
                }
                catch (AbortProcessException e) {
                    response.setCode(e.getResponseCode());
                    response.setRemark(e.getErrorMessage());
                    return response;
                }
            }
            if ((rewriteResult = this.rewriteResponseForStaticTopic(requestHeader, responseHeader, mappingContext, response.getCode())) != null) {
                response = rewriteResult;
            }
            response = this.pullMessageResultHandler.handle(getMessageResult, request, requestHeader, channel, subscriptionData, subscriptionGroupConfig, brokerAllowSuspend, (MessageFilter)var14_18, response);
        } else {
            response.setCode(1);
            response.setRemark("store getMessage return null");
        }
        boolean storeOffsetEnable = brokerAllowSuspend;
        boolean bl = storeOffsetEnable = storeOffsetEnable && hasCommitOffsetFlag;
        if (storeOffsetEnable) {
            this.brokerController.getConsumerOffsetManager().commitOffset(RemotingHelper.parseChannelRemoteAddr((Channel)channel), requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueId(), requestHeader.getCommitOffset());
        }
        return response;
    }

    public boolean hasConsumeMessageHook() {
        return this.consumeMessageHookList != null && !this.consumeMessageHookList.isEmpty();
    }

    public void executeConsumeMessageHookBefore(ConsumeMessageContext context) {
        if (this.hasConsumeMessageHook()) {
            for (ConsumeMessageHook hook : this.consumeMessageHookList) {
                try {
                    hook.consumeMessageBefore(context);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void executeRequestWhenWakeup(final Channel channel, final RemotingCommand request) throws RemotingCommandException {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    final RemotingCommand response = PullMessageProcessor.this.processRequest(channel, request, false);
                    if (response != null) {
                        response.setOpaque(request.getOpaque());
                        response.markResponseType();
                        try {
                            channel.writeAndFlush((Object)response).addListener((GenericFutureListener)new ChannelFutureListener(){

                                public void operationComplete(ChannelFuture future) throws Exception {
                                    if (!future.isSuccess()) {
                                        LOGGER.error("processRequestWrapper response to {} failed", (Object)future.channel().remoteAddress(), (Object)future.cause());
                                        LOGGER.error(request.toString());
                                        LOGGER.error(response.toString());
                                    }
                                }
                            });
                        }
                        catch (Throwable e) {
                            LOGGER.error("processRequestWrapper process request over, but response failed", e);
                            LOGGER.error(request.toString());
                            LOGGER.error(response.toString());
                        }
                    }
                }
                catch (RemotingCommandException e1) {
                    LOGGER.error("excuteRequestWhenWakeup run", (Throwable)e1);
                }
            }
        };
        this.brokerController.getPullMessageExecutor().submit((Runnable)new RequestTask(run, channel, request));
    }

    public void registerConsumeMessageHook(List<ConsumeMessageHook> consumeMessageHookList) {
        this.consumeMessageHookList = consumeMessageHookList;
    }

    public void setPullMessageResultHandler(PullMessageResultHandler pullMessageResultHandler) {
        this.pullMessageResultHandler = pullMessageResultHandler;
    }
}

