/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.pop;

import com.alibaba.fastjson.annotation.JSONField;
import java.util.ArrayList;
import java.util.List;

public class PopCheckPoint {
    @JSONField(name="so")
    private long startOffset;
    @JSONField(name="pt")
    private long popTime;
    @JSONField(name="it")
    private long invisibleTime;
    @JSONField(name="bm")
    private int bitMap;
    @JSONField(name="n")
    private byte num;
    @JSONField(name="q")
    private byte queueId;
    @JSONField(name="t")
    private String topic;
    @JSONField(name="c")
    private String cid;
    @JSONField(name="ro")
    private long reviveOffset;
    @JSONField(name="d")
    private List<Integer> queueOffsetDiff;
    @JSONField(name="bn")
    String brokerName;

    public long getReviveOffset() {
        return this.reviveOffset;
    }

    public void setReviveOffset(long reviveOffset) {
        this.reviveOffset = reviveOffset;
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(long startOffset) {
        this.startOffset = startOffset;
    }

    public void getStartOffset(long startOffset) {
        this.startOffset = startOffset;
    }

    public void setPopTime(long popTime) {
        this.popTime = popTime;
    }

    public void setInvisibleTime(long invisibleTime) {
        this.invisibleTime = invisibleTime;
    }

    public long getPopTime() {
        return this.popTime;
    }

    public long getInvisibleTime() {
        return this.invisibleTime;
    }

    public long getReviveTime() {
        return this.popTime + this.invisibleTime;
    }

    public int getBitMap() {
        return this.bitMap;
    }

    public void setBitMap(int bitMap) {
        this.bitMap = bitMap;
    }

    public byte getNum() {
        return this.num;
    }

    public void setNum(byte num) {
        this.num = num;
    }

    public byte getQueueId() {
        return this.queueId;
    }

    public void setQueueId(byte queueId) {
        this.queueId = queueId;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getCId() {
        return this.cid;
    }

    public void setCId(String cid) {
        this.cid = cid;
    }

    public List<Integer> getQueueOffsetDiff() {
        return this.queueOffsetDiff;
    }

    public void setQueueOffsetDiff(List<Integer> queueOffsetDiff) {
        this.queueOffsetDiff = queueOffsetDiff;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public void addDiff(int diff) {
        if (this.queueOffsetDiff == null) {
            this.queueOffsetDiff = new ArrayList<Integer>(8);
        }
        this.queueOffsetDiff.add(diff);
    }

    public int indexOfAck(long ackOffset) {
        if (ackOffset < this.startOffset) {
            return -1;
        }
        if (this.queueOffsetDiff == null || this.queueOffsetDiff.isEmpty()) {
            if (ackOffset - this.startOffset < (long)this.num) {
                return (int)(ackOffset - this.startOffset);
            }
            return -1;
        }
        return this.queueOffsetDiff.indexOf((int)(ackOffset - this.startOffset));
    }

    public long ackOffsetByIndex(byte index) {
        if (this.queueOffsetDiff == null || this.queueOffsetDiff.isEmpty()) {
            return this.startOffset + (long)index;
        }
        return this.startOffset + (long)this.queueOffsetDiff.get(index).intValue();
    }

    public String toString() {
        return "PopCheckPoint [topic=" + this.topic + ", cid=" + this.cid + ", queueId=" + this.queueId + ", startOffset=" + this.startOffset + ", bitMap=" + this.bitMap + ", num=" + this.num + ", reviveTime=" + this.getReviveTime() + ", reviveOffset=" + this.reviveOffset + ", diff=" + this.queueOffsetDiff + ", brokerName=" + this.brokerName + "]";
    }
}

