/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller.impl.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.ControllerConfig;
import org.apache.rocketmq.controller.elect.ElectPolicy;
import org.apache.rocketmq.controller.impl.event.AlterSyncStateSetEvent;
import org.apache.rocketmq.controller.impl.event.ApplyBrokerIdEvent;
import org.apache.rocketmq.controller.impl.event.CleanBrokerDataEvent;
import org.apache.rocketmq.controller.impl.event.ControllerResult;
import org.apache.rocketmq.controller.impl.event.ElectMasterEvent;
import org.apache.rocketmq.controller.impl.event.EventMessage;
import org.apache.rocketmq.controller.impl.event.EventType;
import org.apache.rocketmq.controller.impl.manager.BrokerInfo;
import org.apache.rocketmq.controller.impl.manager.SyncStateInfo;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.body.BrokerMemberGroup;
import org.apache.rocketmq.remoting.protocol.body.BrokerReplicasInfo;
import org.apache.rocketmq.remoting.protocol.body.SyncStateSet;
import org.apache.rocketmq.remoting.protocol.header.controller.AlterSyncStateSetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.AlterSyncStateSetResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.CleanControllerBrokerDataRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.ElectMasterRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.ElectMasterResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.GetReplicaInfoRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.GetReplicaInfoResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.RegisterBrokerToControllerRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.RegisterBrokerToControllerResponseHeader;

public class ReplicasInfoManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqController");
    private final ControllerConfig controllerConfig;
    private final Map<String, BrokerInfo> replicaInfoTable;
    private final Map<String, SyncStateInfo> syncStateSetInfoTable;

    public ReplicasInfoManager(ControllerConfig config) {
        this.controllerConfig = config;
        this.replicaInfoTable = new HashMap<String, BrokerInfo>();
        this.syncStateSetInfoTable = new HashMap<String, SyncStateInfo>();
    }

    public ControllerResult<AlterSyncStateSetResponseHeader> alterSyncStateSet(AlterSyncStateSetRequestHeader request, SyncStateSet syncStateSet, BiPredicate<String, String> brokerAlivePredicate) {
        String brokerName = request.getBrokerName();
        ControllerResult<AlterSyncStateSetResponseHeader> result = new ControllerResult<AlterSyncStateSetResponseHeader>(new AlterSyncStateSetResponseHeader());
        AlterSyncStateSetResponseHeader response = result.getResponse();
        if (this.isContainsBroker(brokerName)) {
            Set newSyncStateSet = syncStateSet.getSyncStateSet();
            SyncStateInfo syncStateInfo = this.syncStateSetInfoTable.get(brokerName);
            BrokerInfo brokerInfo = this.replicaInfoTable.get(brokerName);
            Set<String> oldSyncStateSet = syncStateInfo.getSyncStateSet();
            if (oldSyncStateSet.size() == newSyncStateSet.size() && oldSyncStateSet.containsAll(newSyncStateSet)) {
                String err = "The newSyncStateSet is equal with oldSyncStateSet, no needed to update syncStateSet";
                LOGGER.warn("{}", (Object)err);
                result.setCodeAndRemark(2010, err);
                return result;
            }
            if (!syncStateInfo.getMasterAddress().equals(request.getMasterAddress())) {
                String err = String.format("Rejecting alter syncStateSet request because the current leader is:{%s}, not {%s}", syncStateInfo.getMasterAddress(), request.getMasterAddress());
                LOGGER.error("{}", (Object)err);
                result.setCodeAndRemark(2002, err);
                return result;
            }
            if (request.getMasterEpoch() != syncStateInfo.getMasterEpoch()) {
                String err = String.format("Rejecting alter syncStateSet request because the current master epoch is:{%d}, not {%d}", syncStateInfo.getMasterEpoch(), request.getMasterEpoch());
                LOGGER.error("{}", (Object)err);
                result.setCodeAndRemark(2000, err);
                return result;
            }
            if (syncStateSet.getSyncStateSetEpoch() != syncStateInfo.getSyncStateSetEpoch()) {
                String err = String.format("Rejecting alter syncStateSet request because the current syncStateSet epoch is:{%d}, not {%d}", syncStateInfo.getSyncStateSetEpoch(), syncStateSet.getSyncStateSetEpoch());
                LOGGER.error("{}", (Object)err);
                result.setCodeAndRemark(2001, err);
                return result;
            }
            for (String replicas : newSyncStateSet) {
                if (!brokerInfo.isBrokerExist(replicas)) {
                    String err = String.format("Rejecting alter syncStateSet request because the replicas {%s} don't exist", replicas);
                    LOGGER.error("{}", (Object)err);
                    result.setCodeAndRemark(2003, err);
                    return result;
                }
                if (brokerAlivePredicate.test(brokerInfo.getClusterName(), replicas)) continue;
                String err = String.format("Rejecting alter syncStateSet request because the replicas {%s} don't alive", replicas);
                LOGGER.error(err);
                result.setCodeAndRemark(2006, err);
                return result;
            }
            if (!newSyncStateSet.contains(syncStateInfo.getMasterAddress())) {
                String err = String.format("Rejecting alter syncStateSet request because the newSyncStateSet don't contains origin leader {%s}", syncStateInfo.getMasterAddress());
                LOGGER.error(err);
                result.setCodeAndRemark(2010, err);
                return result;
            }
            int epoch = syncStateInfo.getSyncStateSetEpoch() + 1;
            response.setNewSyncStateSetEpoch(epoch);
            result.setBody(new SyncStateSet(newSyncStateSet, epoch).encode());
            AlterSyncStateSetEvent event = new AlterSyncStateSetEvent(brokerName, newSyncStateSet);
            result.addEvent(event);
            return result;
        }
        result.setCodeAndRemark(2010, "Broker metadata is not existed");
        return result;
    }

    public ControllerResult<ElectMasterResponseHeader> electMaster(ElectMasterRequestHeader request, ElectPolicy electPolicy) {
        String brokerName = request.getBrokerName();
        String assignBrokerAddress = request.getBrokerAddress();
        ControllerResult<ElectMasterResponseHeader> result = new ControllerResult<ElectMasterResponseHeader>(new ElectMasterResponseHeader());
        if (this.isContainsBroker(brokerName)) {
            SyncStateInfo syncStateInfo = this.syncStateSetInfoTable.get(brokerName);
            BrokerInfo brokerInfo = this.replicaInfoTable.get(brokerName);
            Set<String> syncStateSet = syncStateInfo.getSyncStateSet();
            String oldMaster = syncStateInfo.getMasterAddress();
            Set<String> allReplicaBrokers = this.controllerConfig.isEnableElectUncleanMaster() ? brokerInfo.getAllBroker() : null;
            String newMaster = electPolicy.elect(brokerInfo.getClusterName(), syncStateSet, allReplicaBrokers, oldMaster, assignBrokerAddress);
            if (StringUtils.isNotEmpty((CharSequence)newMaster) && newMaster.equals(oldMaster)) {
                String err = String.format("The old master %s is still alive, not need to elect new master for broker %s", oldMaster, brokerInfo.getBrokerName());
                LOGGER.warn("{}", (Object)err);
                result.setCodeAndRemark(2011, err);
                return result;
            }
            if (StringUtils.isNotEmpty((CharSequence)newMaster)) {
                int masterEpoch = this.syncStateSetInfoTable.get(brokerName).getMasterEpoch();
                int syncStateSetEpoch = this.syncStateSetInfoTable.get(brokerName).getSyncStateSetEpoch();
                ElectMasterResponseHeader response = result.getResponse();
                response.setNewMasterAddress(newMaster);
                response.setMasterEpoch(masterEpoch + 1);
                response.setSyncStateSetEpoch(syncStateSetEpoch);
                BrokerMemberGroup brokerMemberGroup = this.buildBrokerMemberGroup(brokerName);
                if (null != brokerMemberGroup) {
                    response.setBrokerMemberGroup(brokerMemberGroup);
                    result.setBody(brokerMemberGroup.encode());
                }
                ElectMasterEvent event = new ElectMasterEvent(brokerName, newMaster);
                result.addEvent(event);
                return result;
            }
            ElectMasterEvent event = new ElectMasterEvent(false, brokerName);
            result.addEvent(event);
            result.setCodeAndRemark(2004, "Failed to elect a new broker master");
            return result;
        }
        result.setCodeAndRemark(2011, "Broker metadata is not existed");
        return result;
    }

    private BrokerMemberGroup buildBrokerMemberGroup(String brokerName) {
        if (this.isContainsBroker(brokerName)) {
            BrokerInfo brokerInfo = this.replicaInfoTable.get(brokerName);
            BrokerMemberGroup group = new BrokerMemberGroup(brokerInfo.getClusterName(), brokerName);
            HashMap<String, Long> brokerIdTable = brokerInfo.getBrokerIdTable();
            HashMap memberGroup = new HashMap();
            brokerIdTable.forEach((addr, id) -> memberGroup.put(id, addr));
            group.setBrokerAddrs(memberGroup);
            return group;
        }
        return null;
    }

    public ControllerResult<RegisterBrokerToControllerResponseHeader> registerBroker(RegisterBrokerToControllerRequestHeader request, BiPredicate<String, String> brokerAlivePredicate) {
        boolean canBeElectedAsMaster;
        String brokerAddress = request.getBrokerAddress();
        String brokerName = request.getBrokerName();
        String clusterName = request.getClusterName();
        ControllerResult<RegisterBrokerToControllerResponseHeader> result = new ControllerResult<RegisterBrokerToControllerResponseHeader>(new RegisterBrokerToControllerResponseHeader());
        RegisterBrokerToControllerResponseHeader response = result.getResponse();
        if (this.isContainsBroker(brokerName)) {
            long brokerId;
            SyncStateInfo syncStateInfo = this.syncStateSetInfoTable.get(brokerName);
            BrokerInfo brokerInfo = this.replicaInfoTable.get(brokerName);
            if (!brokerInfo.isBrokerExist(brokerAddress)) {
                brokerId = brokerInfo.newBrokerId();
                ApplyBrokerIdEvent applyIdEvent = new ApplyBrokerIdEvent(brokerName, brokerAddress, brokerId);
                result.addEvent(applyIdEvent);
            } else {
                brokerId = brokerInfo.getBrokerId(brokerAddress);
            }
            response.setBrokerId(brokerId);
            response.setMasterEpoch(syncStateInfo.getMasterEpoch());
            response.setSyncStateSetEpoch(syncStateInfo.getSyncStateSetEpoch());
            if (syncStateInfo.isMasterExist() && brokerAlivePredicate.test(clusterName, syncStateInfo.getMasterAddress())) {
                String masterAddress = syncStateInfo.getMasterAddress();
                response.setMasterAddress(masterAddress);
                return result;
            }
            if (syncStateInfo.isMasterExist() && !brokerAlivePredicate.test(clusterName, syncStateInfo.getMasterAddress())) {
                Set aliveSlaveBrokerAddressSet = syncStateInfo.getSyncStateSet().stream().filter(brokerAddr -> brokerAlivePredicate.test(clusterName, (String)brokerAddr) && !StringUtils.equals((CharSequence)brokerAddr, (CharSequence)syncStateInfo.getMasterAddress())).collect(Collectors.toSet());
                if (null != aliveSlaveBrokerAddressSet && aliveSlaveBrokerAddressSet.size() > 0) {
                    if (!aliveSlaveBrokerAddressSet.contains(brokerAddress)) {
                        brokerAddress = (String)aliveSlaveBrokerAddressSet.iterator().next();
                    }
                    canBeElectedAsMaster = true;
                } else {
                    boolean bl = canBeElectedAsMaster = syncStateInfo.getSyncStateSet().contains(brokerAddress) || this.controllerConfig.isEnableElectUncleanMaster();
                }
                if (!canBeElectedAsMaster) {
                    ElectMasterEvent event = new ElectMasterEvent(false, brokerName);
                    result.addEvent(event);
                }
            } else {
                canBeElectedAsMaster = syncStateInfo.getSyncStateSet().contains(brokerAddress) || this.controllerConfig.isEnableElectUncleanMaster();
            }
        } else {
            canBeElectedAsMaster = true;
        }
        if (canBeElectedAsMaster) {
            boolean isBrokerExist = this.isContainsBroker(brokerName);
            int masterEpoch = isBrokerExist ? this.syncStateSetInfoTable.get(brokerName).getMasterEpoch() + 1 : 1;
            int syncStateSetEpoch = isBrokerExist ? this.syncStateSetInfoTable.get(brokerName).getSyncStateSetEpoch() + 1 : 1;
            response.setMasterAddress(brokerAddress);
            response.setMasterEpoch(masterEpoch);
            response.setSyncStateSetEpoch(syncStateSetEpoch);
            response.setBrokerId(0L);
            ElectMasterEvent event = new ElectMasterEvent(true, brokerName, brokerAddress, clusterName);
            result.addEvent(event);
            return result;
        }
        response.setMasterAddress("");
        result.setCodeAndRemark(2012, "The broker has not master, and this new registered broker can't not be elected as master");
        return result;
    }

    public ControllerResult<GetReplicaInfoResponseHeader> getReplicaInfo(GetReplicaInfoRequestHeader request) {
        String brokerName = request.getBrokerName();
        ControllerResult<GetReplicaInfoResponseHeader> result = new ControllerResult<GetReplicaInfoResponseHeader>(new GetReplicaInfoResponseHeader());
        GetReplicaInfoResponseHeader response = result.getResponse();
        if (this.isContainsBroker(brokerName)) {
            SyncStateInfo syncStateInfo = this.syncStateSetInfoTable.get(brokerName);
            BrokerInfo brokerInfo = this.replicaInfoTable.get(brokerName);
            String masterAddress = syncStateInfo.getMasterAddress();
            response.setMasterAddress(masterAddress);
            response.setMasterEpoch(syncStateInfo.getMasterEpoch());
            if (StringUtils.isNotEmpty((CharSequence)request.getBrokerAddress())) {
                response.setBrokerId(brokerInfo.getBrokerId(request.getBrokerAddress()).longValue());
            }
            result.setBody(new SyncStateSet(syncStateInfo.getSyncStateSet(), syncStateInfo.getSyncStateSetEpoch()).encode());
            return result;
        }
        result.setCodeAndRemark(2008, "Broker metadata is not existed");
        return result;
    }

    public ControllerResult<Void> getSyncStateData(List<String> brokerNames) {
        ControllerResult<Void> result = new ControllerResult<Void>();
        BrokerReplicasInfo brokerReplicasInfo = new BrokerReplicasInfo();
        for (String brokerName : brokerNames) {
            if (!this.isContainsBroker(brokerName)) continue;
            SyncStateInfo syncStateInfo = this.syncStateSetInfoTable.get(brokerName);
            BrokerInfo brokerInfo = this.replicaInfoTable.get(brokerName);
            Set<String> syncStateSet = syncStateInfo.getSyncStateSet();
            String master = syncStateInfo.getMasterAddress();
            ArrayList inSyncReplicas = new ArrayList();
            ArrayList notInSyncReplicas = new ArrayList();
            brokerInfo.getBrokerIdTable().forEach((brokerAddress, brokerId) -> {
                if (syncStateSet.contains(brokerAddress)) {
                    long id = StringUtils.equals((CharSequence)master, (CharSequence)brokerAddress) ? 0L : brokerInfo.getBrokerId((String)brokerAddress);
                    inSyncReplicas.add(new BrokerReplicasInfo.ReplicaIdentity(brokerAddress, Long.valueOf(id)));
                } else {
                    notInSyncReplicas.add(new BrokerReplicasInfo.ReplicaIdentity(brokerAddress, brokerId));
                }
            });
            BrokerReplicasInfo.ReplicasInfo inSyncState = new BrokerReplicasInfo.ReplicasInfo(master, syncStateInfo.getMasterEpoch(), syncStateInfo.getSyncStateSetEpoch(), inSyncReplicas, notInSyncReplicas);
            brokerReplicasInfo.addReplicaInfo(brokerName, inSyncState);
        }
        result.setBody(brokerReplicasInfo.encode());
        return result;
    }

    public ControllerResult<Void> cleanBrokerData(CleanControllerBrokerDataRequestHeader requestHeader, BiPredicate<String, String> brokerAlivePredicate) {
        ControllerResult<Void> result = new ControllerResult<Void>();
        String clusterName = requestHeader.getClusterName();
        String brokerName = requestHeader.getBrokerName();
        String brokerAddrs = requestHeader.getBrokerAddress();
        Set brokerAddressSet = null;
        if (!requestHeader.isCleanLivingBroker()) {
            SyncStateInfo syncStateInfo = this.syncStateSetInfoTable.get(brokerName);
            if (StringUtils.isBlank((CharSequence)brokerAddrs) && null != syncStateInfo && StringUtils.isNotEmpty((CharSequence)syncStateInfo.getMasterAddress())) {
                String remark = String.format("Broker %s is still alive, clean up failure", requestHeader.getBrokerName());
                result.setCodeAndRemark(2009, remark);
                return result;
            }
            if (StringUtils.isNotBlank((CharSequence)brokerAddrs)) {
                brokerAddressSet = Stream.of(brokerAddrs.split(";")).collect(Collectors.toSet());
                for (String brokerAddr : brokerAddressSet) {
                    if (!brokerAlivePredicate.test(clusterName, brokerAddr)) continue;
                    String remark = String.format("Broker [%s,  %s] is still alive, clean up failure", requestHeader.getBrokerName(), brokerAddr);
                    result.setCodeAndRemark(2009, remark);
                    return result;
                }
            }
        }
        if (this.isContainsBroker(brokerName)) {
            CleanBrokerDataEvent event = new CleanBrokerDataEvent(brokerName, brokerAddressSet);
            result.addEvent(event);
            return result;
        }
        result.setCodeAndRemark(2009, String.format("Broker %s is not existed,clean broker data failure.", brokerName));
        return result;
    }

    public void applyEvent(EventMessage event) {
        EventType type = event.getEventType();
        switch (type) {
            case ALTER_SYNC_STATE_SET_EVENT: {
                this.handleAlterSyncStateSet((AlterSyncStateSetEvent)event);
                break;
            }
            case APPLY_BROKER_ID_EVENT: {
                this.handleApplyBrokerId((ApplyBrokerIdEvent)event);
                break;
            }
            case ELECT_MASTER_EVENT: {
                this.handleElectMaster((ElectMasterEvent)event);
                break;
            }
            case CLEAN_BROKER_DATA_EVENT: {
                this.handleCleanBrokerDataEvent((CleanBrokerDataEvent)event);
                break;
            }
        }
    }

    private void handleAlterSyncStateSet(AlterSyncStateSetEvent event) {
        String brokerName = event.getBrokerName();
        if (this.isContainsBroker(brokerName)) {
            SyncStateInfo syncStateInfo = this.syncStateSetInfoTable.get(brokerName);
            syncStateInfo.updateSyncStateSetInfo(event.getNewSyncStateSet());
        }
    }

    private void handleApplyBrokerId(ApplyBrokerIdEvent event) {
        BrokerInfo brokerInfo;
        String brokerName = event.getBrokerName();
        if (this.isContainsBroker(brokerName) && !(brokerInfo = this.replicaInfoTable.get(brokerName)).isBrokerExist(event.getBrokerAddress())) {
            brokerInfo.addBroker(event.getBrokerAddress(), event.getNewBrokerId());
        }
    }

    private void handleElectMaster(ElectMasterEvent event) {
        String brokerName = event.getBrokerName();
        String newMaster = event.getNewMasterAddress();
        if (this.isContainsBroker(brokerName)) {
            SyncStateInfo syncStateInfo = this.syncStateSetInfoTable.get(brokerName);
            if (event.getNewMasterElected()) {
                syncStateInfo.updateMasterInfo(newMaster);
                HashSet<String> newSyncStateSet = new HashSet<String>();
                newSyncStateSet.add(newMaster);
                syncStateInfo.updateSyncStateSetInfo(newSyncStateSet);
            } else {
                syncStateInfo.updateMasterInfo("");
            }
        } else {
            String clusterName = event.getClusterName();
            BrokerInfo brokerInfo = new BrokerInfo(clusterName, brokerName);
            brokerInfo.addBroker(newMaster, 1L);
            SyncStateInfo syncStateInfo = new SyncStateInfo(clusterName, brokerName, newMaster);
            this.syncStateSetInfoTable.put(brokerName, syncStateInfo);
            this.replicaInfoTable.put(brokerName, brokerInfo);
        }
    }

    private void handleCleanBrokerDataEvent(CleanBrokerDataEvent event) {
        String brokerName = event.getBrokerName();
        Set<String> brokerAddressSet = event.getBrokerAddressSet();
        if (null == brokerAddressSet || brokerAddressSet.isEmpty()) {
            this.replicaInfoTable.remove(brokerName);
            this.syncStateSetInfoTable.remove(brokerName);
            return;
        }
        if (!this.isContainsBroker(brokerName)) {
            return;
        }
        BrokerInfo brokerInfo = this.replicaInfoTable.get(brokerName);
        SyncStateInfo syncStateInfo = this.syncStateSetInfoTable.get(brokerName);
        for (String brokerAddress : brokerAddressSet) {
            brokerInfo.removeBrokerAddress(brokerAddress);
            syncStateInfo.removeSyncState(brokerAddress);
        }
        if (brokerInfo.getBrokerIdTable().isEmpty()) {
            this.replicaInfoTable.remove(brokerName);
        }
        if (syncStateInfo.getSyncStateSet().isEmpty()) {
            this.syncStateSetInfoTable.remove(brokerName);
        }
    }

    private boolean isContainsBroker(String brokerName) {
        return this.replicaInfoTable.containsKey(brokerName) && this.syncStateSetInfoTable.containsKey(brokerName);
    }
}

