/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.util.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.rocketmq.util.cache.CacheEvictHandler;

public class LocalCache<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1606231700062718297L;
    private static final int DEFAULT_CACHE_SIZE = 1000;
    private int cacheSize = 1000;
    private CacheEvictHandler<K, V> handler;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public LocalCache(int cacheSize, boolean isLru, CacheEvictHandler<K, V> handler) {
        super(16, 0.75f, isLru);
        this.cacheSize = cacheSize;
        this.handler = handler;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        boolean result;
        boolean bl = result = this.size() > this.cacheSize;
        if (result && this.handler != null) {
            this.handler.onEvict(eldest);
        }
        return result;
    }
}

