/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.ha.autoswitch;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.utils.ConcurrentHashMapUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.EpochEntry;
import org.apache.rocketmq.remoting.protocol.body.HARuntimeInfo;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.ha.DefaultHAService;
import org.apache.rocketmq.store.ha.GroupTransferService;
import org.apache.rocketmq.store.ha.HAClient;
import org.apache.rocketmq.store.ha.HAConnection;
import org.apache.rocketmq.store.ha.HAConnectionStateNotificationService;
import org.apache.rocketmq.store.ha.autoswitch.AutoSwitchHAClient;
import org.apache.rocketmq.store.ha.autoswitch.AutoSwitchHAConnection;
import org.apache.rocketmq.store.ha.autoswitch.EpochFileCache;

public class AutoSwitchHAService
extends DefaultHAService {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqStore");
    private final ExecutorService executorService = Executors.newSingleThreadExecutor((ThreadFactory)new ThreadFactoryImpl("AutoSwitchHAService_Executor_"));
    private final List<Consumer<Set<String>>> syncStateSetChangedListeners = new ArrayList<Consumer<Set<String>>>();
    private final CopyOnWriteArraySet<String> syncStateSet = new CopyOnWriteArraySet();
    private final ConcurrentHashMap<String, Long> connectionCaughtUpTimeTable = new ConcurrentHashMap();
    private volatile long confirmOffset = -1L;
    private String localAddress;
    private EpochFileCache epochCache;
    private AutoSwitchHAClient haClient;
    private ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    @Override
    public void init(DefaultMessageStore defaultMessageStore) throws IOException {
        this.epochCache = new EpochFileCache(defaultMessageStore.getMessageStoreConfig().getStorePathEpochFile());
        this.epochCache.initCacheFromFile();
        this.defaultMessageStore = defaultMessageStore;
        this.acceptSocketService = new AutoSwitchAcceptSocketService(defaultMessageStore.getMessageStoreConfig());
        this.groupTransferService = new GroupTransferService(this, defaultMessageStore);
        this.haConnectionStateNotificationService = new HAConnectionStateNotificationService(this, defaultMessageStore);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.haClient != null) {
            this.haClient.shutdown();
        }
        this.executorService.shutdown();
    }

    @Override
    public void removeConnection(HAConnection conn) {
        String slave;
        Set<String> syncStateSet;
        if (!this.defaultMessageStore.isShutdown() && (syncStateSet = this.getSyncStateSet()).contains(slave = ((AutoSwitchHAConnection)conn).getSlaveAddress())) {
            syncStateSet.remove(slave);
            this.notifySyncStateSetChanged(syncStateSet);
        }
        super.removeConnection(conn);
    }

    @Override
    public boolean changeToMaster(int masterEpoch) {
        int lastEpoch = this.epochCache.lastEpoch();
        if (masterEpoch < lastEpoch) {
            LOGGER.warn("newMasterEpoch {} < lastEpoch {}, fail to change to master", (Object)masterEpoch, (Object)lastEpoch);
            return false;
        }
        this.destroyConnections();
        if (this.haClient != null) {
            this.haClient.shutdown();
        }
        long truncateOffset = this.truncateInvalidMsg();
        this.updateConfirmOffset(this.computeConfirmOffset());
        if (truncateOffset >= 0L) {
            this.epochCache.truncateSuffixByOffset(truncateOffset);
        }
        EpochEntry newEpochEntry = new EpochEntry(masterEpoch, this.defaultMessageStore.getMaxPhyOffset());
        if (this.epochCache.lastEpoch() >= masterEpoch) {
            this.epochCache.truncateSuffixByEpoch(masterEpoch);
        }
        this.epochCache.appendEntry(newEpochEntry);
        while (this.defaultMessageStore.dispatchBehindBytes() > 0L) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        if (this.defaultMessageStore.isTransientStorePoolEnable()) {
            this.waitingForAllCommit();
            this.defaultMessageStore.getTransientStorePool().setRealCommit(true);
        }
        LOGGER.info("TruncateOffset is {}, confirmOffset is {}, maxPhyOffset is {}", new Object[]{truncateOffset, this.getConfirmOffset(), this.defaultMessageStore.getMaxPhyOffset()});
        this.defaultMessageStore.recoverTopicQueueTable();
        LOGGER.info("Change ha to master success, newMasterEpoch:{}, startOffset:{}", (Object)masterEpoch, (Object)newEpochEntry.getStartOffset());
        return true;
    }

    @Override
    public boolean changeToSlave(String newMasterAddr, int newMasterEpoch, Long slaveId) {
        int lastEpoch = this.epochCache.lastEpoch();
        if (newMasterEpoch < lastEpoch) {
            LOGGER.warn("newMasterEpoch {} < lastEpoch {}, fail to change to slave", (Object)newMasterEpoch, (Object)lastEpoch);
            return false;
        }
        try {
            this.destroyConnections();
            if (this.haClient == null) {
                this.haClient = new AutoSwitchHAClient(this, this.defaultMessageStore, this.epochCache);
            } else {
                this.haClient.reOpen();
            }
            this.haClient.setLocalAddress(this.localAddress);
            this.haClient.updateSlaveId(slaveId);
            this.haClient.updateMasterAddress(newMasterAddr);
            this.haClient.updateHaMasterAddress(null);
            this.haClient.start();
            if (this.defaultMessageStore.isTransientStorePoolEnable()) {
                this.waitingForAllCommit();
                this.defaultMessageStore.getTransientStorePool().setRealCommit(false);
            }
            LOGGER.info("Change ha to slave success, newMasterAddress:{}, newMasterEpoch:{}", (Object)newMasterAddr, (Object)newMasterEpoch);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Error happen when change ha to slave", (Throwable)e);
            return false;
        }
    }

    public void waitingForAllCommit() {
        while (this.getDefaultMessageStore().remainHowManyDataToCommit() > 0L) {
            this.getDefaultMessageStore().getCommitLog().getFlushManager().wakeUpCommit();
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public HAClient getHAClient() {
        return this.haClient;
    }

    @Override
    public void updateHaMasterAddress(String newAddr) {
        if (this.haClient != null) {
            this.haClient.updateHaMasterAddress(newAddr);
        }
    }

    @Override
    public void updateMasterAddress(String newAddr) {
    }

    public void registerSyncStateSetChangedListener(Consumer<Set<String>> listener) {
        this.syncStateSetChangedListeners.add(listener);
    }

    public void notifySyncStateSetChanged(Set<String> newSyncStateSet) {
        this.executorService.submit(() -> {
            for (Consumer<Set<String>> listener : this.syncStateSetChangedListeners) {
                listener.accept(newSyncStateSet);
            }
        });
    }

    public Set<String> maybeShrinkInSyncStateSet() {
        Set<String> newSyncStateSet = this.getSyncStateSet();
        long haMaxTimeSlaveNotCatchup = this.defaultMessageStore.getMessageStoreConfig().getHaMaxTimeSlaveNotCatchup();
        for (Map.Entry<String, Long> next : this.connectionCaughtUpTimeTable.entrySet()) {
            String slaveAddress = next.getKey();
            if (!newSyncStateSet.contains(slaveAddress)) continue;
            Long lastCaughtUpTimeMs = this.connectionCaughtUpTimeTable.get(slaveAddress);
            if (System.currentTimeMillis() - lastCaughtUpTimeMs <= haMaxTimeSlaveNotCatchup) continue;
            newSyncStateSet.remove(slaveAddress);
        }
        return newSyncStateSet;
    }

    public void maybeExpandInSyncStateSet(String slaveAddress, long slaveMaxOffset) {
        EpochEntry currentLeaderEpoch;
        Set<String> currentSyncStateSet = this.getSyncStateSet();
        if (currentSyncStateSet.contains(slaveAddress)) {
            return;
        }
        long confirmOffset = this.getConfirmOffset();
        if (slaveMaxOffset >= confirmOffset && slaveMaxOffset >= (currentLeaderEpoch = this.epochCache.lastEntry()).getStartOffset()) {
            currentSyncStateSet.add(slaveAddress);
            this.notifySyncStateSetChanged(currentSyncStateSet);
        }
    }

    public void updateConnectionLastCaughtUpTime(String slaveAddress, long lastCaughtUpTimeMs) {
        Long prevTime = (Long)ConcurrentHashMapUtils.computeIfAbsent(this.connectionCaughtUpTimeTable, (Object)slaveAddress, k -> 0L);
        this.connectionCaughtUpTimeTable.put(slaveAddress, Math.max(prevTime, lastCaughtUpTimeMs));
    }

    public long getConfirmOffset() {
        if (this.defaultMessageStore.getMessageStoreConfig().getBrokerRole() != BrokerRole.SLAVE) {
            if (this.syncStateSet.size() == 1) {
                return this.defaultMessageStore.getMaxPhyOffset();
            }
            if (this.confirmOffset <= 0L) {
                this.confirmOffset = this.computeConfirmOffset();
            }
        }
        return this.confirmOffset;
    }

    public void updateConfirmOffsetWhenSlaveAck(String slaveAddress) {
        if (this.syncStateSet.contains(slaveAddress)) {
            this.confirmOffset = this.computeConfirmOffset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int inSyncReplicasNums(long masterPutWhere) {
        Lock readLock = this.readWriteLock.readLock();
        try {
            readLock.lock();
            int n = this.syncStateSet.size();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public HARuntimeInfo getRuntimeInfo(long masterPutWhere) {
        HARuntimeInfo info = new HARuntimeInfo();
        if (BrokerRole.SLAVE.equals((Object)this.getDefaultMessageStore().getMessageStoreConfig().getBrokerRole())) {
            info.setMaster(false);
            info.getHaClientRuntimeInfo().setMasterAddr(this.haClient.getHaMasterAddress());
            info.getHaClientRuntimeInfo().setMaxOffset(this.getDefaultMessageStore().getMaxPhyOffset());
            info.getHaClientRuntimeInfo().setLastReadTimestamp(this.haClient.getLastReadTimestamp());
            info.getHaClientRuntimeInfo().setLastWriteTimestamp(this.haClient.getLastWriteTimestamp());
            info.getHaClientRuntimeInfo().setTransferredByteInSecond(this.haClient.getTransferredByteInSecond());
            info.getHaClientRuntimeInfo().setMasterFlushOffset(this.defaultMessageStore.getMasterFlushedOffset());
        } else {
            info.setMaster(true);
            info.setMasterCommitLogMaxOffset(masterPutWhere);
            for (HAConnection conn : this.connectionList) {
                HARuntimeInfo.HAConnectionRuntimeInfo cInfo = new HARuntimeInfo.HAConnectionRuntimeInfo();
                long slaveAckOffset = conn.getSlaveAckOffset();
                cInfo.setSlaveAckOffset(slaveAckOffset);
                cInfo.setDiff(masterPutWhere - slaveAckOffset);
                cInfo.setAddr(conn.getClientAddress().substring(1));
                cInfo.setTransferredByteInSecond(conn.getTransferredByteInSecond());
                cInfo.setTransferFromWhere(conn.getTransferFromWhere());
                cInfo.setInSync(this.syncStateSet.contains(((AutoSwitchHAConnection)conn).getSlaveAddress()));
                info.getHaConnectionInfo().add(cInfo);
            }
            info.setInSyncSlaveNums(this.syncStateSet.size() - 1);
        }
        return info;
    }

    public void updateConfirmOffset(long confirmOffset) {
        this.confirmOffset = confirmOffset;
    }

    private long computeConfirmOffset() {
        Set<String> currentSyncStateSet = this.getSyncStateSet();
        long confirmOffset = this.defaultMessageStore.getMaxPhyOffset();
        for (HAConnection connection : this.connectionList) {
            String slaveAddress = ((AutoSwitchHAConnection)connection).getSlaveAddress();
            if (!currentSyncStateSet.contains(slaveAddress)) continue;
            confirmOffset = Math.min(confirmOffset, connection.getSlaveAckOffset());
        }
        return confirmOffset;
    }

    public void setSyncStateSet(Set<String> syncStateSet) {
        Lock writeLock = this.readWriteLock.writeLock();
        try {
            writeLock.lock();
            this.syncStateSet.clear();
            this.syncStateSet.addAll(syncStateSet);
            this.confirmOffset = this.computeConfirmOffset();
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getSyncStateSet() {
        Lock readLock = this.readWriteLock.readLock();
        try {
            readLock.lock();
            HashSet<String> set = new HashSet<String>(this.syncStateSet.size());
            set.addAll(this.syncStateSet);
            HashSet<String> hashSet = set;
            return hashSet;
        }
        finally {
            readLock.unlock();
        }
    }

    public void truncateEpochFilePrefix(long offset) {
        this.epochCache.truncatePrefixByOffset(offset);
    }

    public void truncateEpochFileSuffix(long offset) {
        this.epochCache.truncateSuffixByOffset(offset);
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long truncateInvalidMsg() {
        SelectMappedBufferResult result;
        long dispatchBehind = this.defaultMessageStore.dispatchBehindBytes();
        if (dispatchBehind <= 0L) {
            LOGGER.info("Dispatch complete, skip truncate");
            return -1L;
        }
        boolean doNext = true;
        long reputFromOffset = this.defaultMessageStore.getMaxPhyOffset() - dispatchBehind;
        while ((result = this.defaultMessageStore.getCommitLog().getData(reputFromOffset)) != null) {
            try {
                int size;
                reputFromOffset = result.getStartOffset();
                for (int readSize = 0; readSize < result.getSize(); readSize += size) {
                    DispatchRequest dispatchRequest = this.defaultMessageStore.getCommitLog().checkMessageAndReturnSize(result.getByteBuffer(), false, false);
                    if (dispatchRequest.isSuccess()) {
                        size = dispatchRequest.getMsgSize();
                        if (size > 0) {
                            reputFromOffset += (long)size;
                            continue;
                        }
                        reputFromOffset = this.defaultMessageStore.getCommitLog().rollNextFile(reputFromOffset);
                    } else {
                        doNext = false;
                    }
                    break;
                }
            }
            finally {
                result.release();
            }
            if (reputFromOffset < this.defaultMessageStore.getMaxPhyOffset() && doNext) continue;
        }
        LOGGER.info("Truncate commitLog to {}", (Object)reputFromOffset);
        this.defaultMessageStore.truncateDirtyFiles(reputFromOffset);
        return reputFromOffset;
    }

    public int getLastEpoch() {
        return this.epochCache.lastEpoch();
    }

    public List<EpochEntry> getEpochEntries() {
        return this.epochCache.getAllEntries();
    }

    class AutoSwitchAcceptSocketService
    extends DefaultHAService.AcceptSocketService {
        public AutoSwitchAcceptSocketService(MessageStoreConfig messageStoreConfig) {
            super(AutoSwitchHAService.this, messageStoreConfig);
        }

        public String getServiceName() {
            if (AutoSwitchHAService.this.defaultMessageStore.getBrokerConfig().isInBrokerContainer()) {
                return AutoSwitchHAService.this.defaultMessageStore.getBrokerConfig().getIdentifier() + DefaultHAService.AcceptSocketService.class.getSimpleName();
            }
            return AutoSwitchAcceptSocketService.class.getSimpleName();
        }

        @Override
        protected HAConnection createConnection(SocketChannel sc) throws IOException {
            return new AutoSwitchHAConnection(AutoSwitchHAService.this, sc, AutoSwitchHAService.this.epochCache);
        }
    }
}

