/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.kv;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.attribute.CleanupPolicy;
import org.apache.rocketmq.common.utils.CleanupPolicyUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.CommitLog;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.GetMessageResult;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.kv.CompactionStore;

public class CompactionService
extends ServiceThread {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private final CompactionStore compactionStore;
    private final DefaultMessageStore defaultMessageStore;
    private final CommitLog commitLog;
    private final LinkedBlockingQueue<TopicPartitionOffset> compactionMsgQ = new LinkedBlockingQueue();

    public CompactionService(CommitLog commitLog, DefaultMessageStore messageStore, CompactionStore compactionStore) {
        this.commitLog = commitLog;
        this.defaultMessageStore = messageStore;
        this.compactionStore = compactionStore;
    }

    public void putRequest(DispatchRequest request) {
        if (request == null) {
            return;
        }
        String topic = request.getTopic();
        Optional<TopicConfig> topicConfig = this.defaultMessageStore.getTopicConfig(topic);
        CleanupPolicy policy = CleanupPolicyUtils.getDeletePolicy(topicConfig);
        if (Objects.equals(policy, CleanupPolicy.COMPACTION)) {
            int queueId = request.getQueueId();
            long physicalOffset = request.getCommitLogOffset();
            TopicPartitionOffset tpo = new TopicPartitionOffset(topic, queueId, physicalOffset);
            this.compactionMsgQ.offer(tpo);
            this.wakeup();
        }
    }

    public GetMessageResult getMessage(String group, String topic, int queueId, long offset, int maxMsgNums, int maxTotalMsgSize) {
        return this.compactionStore.getMessage(group, topic, queueId, offset, maxMsgNums, maxTotalMsgSize);
    }

    public String getServiceName() {
        if (this.defaultMessageStore != null && this.defaultMessageStore.getBrokerConfig().isInBrokerContainer()) {
            return this.defaultMessageStore.getBrokerConfig().getIdentifier() + CompactionService.class.getSimpleName();
        }
        return CompactionService.class.getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.isStopped()) {
            try {
                TopicPartitionOffset tpo = this.compactionMsgQ.poll(1L, TimeUnit.MILLISECONDS);
                if (null != tpo) {
                    SelectMappedBufferResult smr = null;
                    try {
                        smr = this.commitLog.getData(tpo.physicalOffset);
                        if (smr == null) continue;
                        this.compactionStore.putMessage(tpo.topic, tpo.queueId, smr);
                        continue;
                    }
                    catch (Exception e) {
                        log.error("putMessage into {}:{} compactionLog exception: ", new Object[]{tpo.topic, tpo.queueId, e});
                        continue;
                    }
                    finally {
                        if (smr != null) {
                            smr.release();
                        }
                        continue;
                    }
                }
                this.waitForRunning(100L);
            }
            catch (InterruptedException e) {
                log.error("poll from compaction pos queue interrupted.");
            }
        }
    }

    public boolean load(boolean exitOK) {
        try {
            this.compactionStore.load(exitOK);
            return true;
        }
        catch (Exception e) {
            log.error("load compaction store error ", (Throwable)e);
            return false;
        }
    }

    public void shutdown() {
        super.shutdown();
        this.compactionStore.shutdown();
    }

    public void updateMasterAddress(String addr) {
        this.compactionStore.updateMasterAddress(addr);
    }

    static class TopicPartitionOffset {
        String topic;
        int queueId;
        long physicalOffset;

        public TopicPartitionOffset(String topic, int queueId, long physicalOffset) {
            this.topic = topic;
            this.queueId = queueId;
            this.physicalOffset = physicalOffset;
        }

        public String getTopic() {
            return this.topic;
        }

        public void setTopic(String topic) {
            this.topic = topic;
        }

        public int getQueueId() {
            return this.queueId;
        }

        public void setQueueId(int queueId) {
            this.queueId = queueId;
        }

        public long getPhysicalOffset() {
            return this.physicalOffset;
        }

        public void setPhysicalOffset(long physicalOffset) {
            this.physicalOffset = physicalOffset;
        }
    }
}

