/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.container;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.tieredstore.common.AppendResult;
import org.apache.rocketmq.tieredstore.common.TieredMessageStoreConfig;
import org.apache.rocketmq.tieredstore.container.TieredFileQueue;
import org.apache.rocketmq.tieredstore.provider.TieredFileSegment;
import org.apache.rocketmq.tieredstore.util.MessageBufferUtil;

public class TieredCommitLog {
    private static final Logger logger = LoggerFactory.getLogger((String)"RocketmqTieredStore");
    public static final int CODA_SIZE = 16;
    public static final int BLANK_MAGIC_CODE = -875286124;
    private final MessageQueue messageQueue;
    private final TieredMessageStoreConfig storeConfig;
    private final TieredFileQueue fileQueue;

    public TieredCommitLog(MessageQueue messageQueue, TieredMessageStoreConfig storeConfig) throws ClassNotFoundException, NoSuchMethodException {
        this.messageQueue = messageQueue;
        this.storeConfig = storeConfig;
        this.fileQueue = new TieredFileQueue(TieredFileSegment.FileSegmentType.COMMIT_LOG, messageQueue, storeConfig);
        if (this.fileQueue.getBaseOffset() == -1L) {
            this.fileQueue.setBaseOffset(0L);
        }
    }

    public long getMinOffset() {
        return this.fileQueue.getMinOffset();
    }

    public long getCommitOffset() {
        return this.fileQueue.getCommitOffset();
    }

    public long getCommitMsgQueueOffset() {
        return this.fileQueue.getCommitMsgQueueOffset();
    }

    public long getMaxOffset() {
        return this.fileQueue.getMaxOffset();
    }

    public long getBeginTimestamp() {
        TieredFileSegment firstIndexFile = this.fileQueue.getFileByIndex(0);
        if (firstIndexFile == null) {
            return -1L;
        }
        long beginTimestamp = firstIndexFile.getBeginTimestamp();
        return beginTimestamp != Long.MAX_VALUE ? beginTimestamp : -1L;
    }

    public long getEndTimestamp() {
        return this.fileQueue.getFileToWrite().getEndTimestamp();
    }

    public AppendResult append(ByteBuffer byteBuf) {
        return this.fileQueue.append(byteBuf, MessageBufferUtil.getStoreTimeStamp(byteBuf));
    }

    public AppendResult append(ByteBuffer byteBuf, boolean commit) {
        return this.fileQueue.append(byteBuf, MessageBufferUtil.getStoreTimeStamp(byteBuf), commit);
    }

    public CompletableFuture<ByteBuffer> readAsync(long offset, int length) {
        return this.fileQueue.readAsync(offset, length);
    }

    public void commit(boolean sync) {
        this.fileQueue.commit(sync);
    }

    public void cleanExpiredFile(long expireTimestamp) {
        this.fileQueue.cleanExpiredFile(expireTimestamp);
    }

    public void destroyExpiredFile() {
        this.fileQueue.destroyExpiredFile();
        if (this.fileQueue.getFileSegmentCount() == 0) {
            return;
        }
        TieredFileSegment fileSegment = this.fileQueue.getFileToWrite();
        try {
            if (System.currentTimeMillis() - fileSegment.getEndTimestamp() > (long)this.storeConfig.getCommitLogRollingInterval() * 60L * 60L * 1000L && fileSegment.getSize() > (long)this.storeConfig.getCommitLogRollingMinimumSize()) {
                this.fileQueue.rollingNewFile();
            }
        }
        catch (Exception e) {
            logger.error("Rolling to next file failed:", (Throwable)e);
        }
    }

    public void destroy() {
        this.fileQueue.destroy();
    }
}

