/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.provider.inputstream;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.rocketmq.tieredstore.common.FileSegmentType;
import org.apache.rocketmq.tieredstore.provider.inputstream.TieredFileSegmentInputStream;

public class TieredCommitLogInputStream
extends TieredFileSegmentInputStream {
    private long commitLogOffset;
    private final ByteBuffer codaBuffer;
    private long markCommitLogOffset = -1L;

    public TieredCommitLogInputStream(FileSegmentType fileType, long startOffset, List<ByteBuffer> uploadBufferList, ByteBuffer codaBuffer, int contentLength) {
        super(fileType, uploadBufferList, contentLength);
        this.commitLogOffset = startOffset;
        this.codaBuffer = codaBuffer;
    }

    @Override
    public synchronized void mark(int ignore) {
        super.mark(ignore);
        this.markCommitLogOffset = this.commitLogOffset;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this.commitLogOffset = this.markCommitLogOffset;
    }

    @Override
    public ByteBuffer getCodaBuffer() {
        return this.codaBuffer;
    }

    @Override
    public int read() {
        int res;
        if (this.available() <= 0) {
            return -1;
        }
        ++this.readPosition;
        if (this.curReadBufferIndex >= this.uploadBufferList.size()) {
            return this.readCoda();
        }
        if (this.readPosInCurBuffer >= this.curBuffer.remaining()) {
            ++this.curReadBufferIndex;
            if (this.curReadBufferIndex >= this.uploadBufferList.size()) {
                this.readPosInCurBuffer = 0;
                return this.readCoda();
            }
            this.curBuffer = (ByteBuffer)this.uploadBufferList.get(this.curReadBufferIndex);
            this.commitLogOffset += (long)this.readPosInCurBuffer;
            this.readPosInCurBuffer = 0;
        }
        if (this.readPosInCurBuffer >= 28 && this.readPosInCurBuffer < 36) {
            res = (int)(this.commitLogOffset >> 8 * (36 - this.readPosInCurBuffer - 1) & 0xFFL);
            ++this.readPosInCurBuffer;
        } else {
            res = this.curBuffer.get(this.readPosInCurBuffer++) & 0xFF;
        }
        return res;
    }

    private int readCoda() {
        if (this.codaBuffer == null || this.readPosInCurBuffer >= this.codaBuffer.remaining()) {
            return -1;
        }
        return this.codaBuffer.get(this.readPosInCurBuffer++) & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || len > b.length - off");
        }
        if (this.readPosition >= this.contentLength) {
            return -1;
        }
        int available = this.available();
        if (len > available) {
            len = available;
        }
        if (len <= 0) {
            return 0;
        }
        int needRead = len;
        int pos = this.readPosition;
        int bufIndex = this.curReadBufferIndex;
        int posInCurBuffer = this.readPosInCurBuffer;
        long curCommitLogOffset = this.commitLogOffset;
        ByteBuffer curBuf = this.curBuffer;
        while (needRead > 0 && bufIndex <= this.uploadBufferList.size()) {
            int readLen;
            int remaining;
            int realReadLen = 0;
            if (bufIndex == this.uploadBufferList.size()) {
                remaining = this.codaBuffer.remaining() - posInCurBuffer;
                readLen = Math.min(remaining, needRead);
                this.codaBuffer.position(posInCurBuffer);
                this.codaBuffer.get(b, off, readLen);
                this.codaBuffer.position(0);
                off += readLen;
                needRead -= readLen;
                pos += readLen;
                posInCurBuffer += readLen;
                continue;
            }
            remaining = curBuf.remaining() - posInCurBuffer;
            readLen = Math.min(remaining, needRead);
            curBuf = (ByteBuffer)this.uploadBufferList.get(bufIndex);
            if (posInCurBuffer < 28) {
                realReadLen = Math.min(28 - posInCurBuffer, readLen);
                curBuf.position(posInCurBuffer);
                curBuf.get(b, off, realReadLen);
                curBuf.position(0);
            } else if (posInCurBuffer < 36) {
                realReadLen = Math.min(36 - posInCurBuffer, readLen);
                byte[] physicalOffsetBytes = new byte[realReadLen];
                for (int i = 0; i < realReadLen; ++i) {
                    physicalOffsetBytes[i] = (byte)(curCommitLogOffset >> 8 * (36 - posInCurBuffer - i - 1) & 0xFFL);
                }
                System.arraycopy(physicalOffsetBytes, 0, b, off, realReadLen);
            } else {
                realReadLen = readLen;
                curBuf.position(posInCurBuffer);
                curBuf.get(b, off, readLen);
                curBuf.position(0);
            }
            off += realReadLen;
            needRead -= realReadLen;
            pos += realReadLen;
            if ((posInCurBuffer += realReadLen) != curBuf.remaining()) continue;
            ++bufIndex;
            curCommitLogOffset += (long)posInCurBuffer;
            posInCurBuffer = 0;
        }
        this.readPosition = pos;
        this.curReadBufferIndex = bufIndex;
        this.readPosInCurBuffer = posInCurBuffer;
        this.commitLogOffset = curCommitLogOffset;
        this.curBuffer = curBuf;
        return len;
    }
}

